/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.spark.sql.Row;

public interface RowRecordKeyExtractor
extends Serializable {
    public String getPartitionPath(Row var1);

    public String getRecordKey(Row var1);

    public static RowRecordKeyExtractor getRowRecordKeyExtractor(boolean populateMetaFields, Option<BuiltinKeyGenerator> keyGeneratorOpt) {
        if (populateMetaFields) {
            return new MetaFiledRowKeyExtractor();
        }
        if (keyGeneratorOpt.isPresent()) {
            return new BuiltInKeyGenRowKeyExtractor((BuiltinKeyGenerator)keyGeneratorOpt.get());
        }
        return new EmptyRowKeyExtractor();
    }

    public static class EmptyRowKeyExtractor
    implements RowRecordKeyExtractor {
        @Override
        public String getPartitionPath(Row row) {
            return "";
        }

        @Override
        public String getRecordKey(Row row) {
            return "";
        }
    }

    public static class BuiltInKeyGenRowKeyExtractor
    implements RowRecordKeyExtractor {
        private final BuiltinKeyGenerator keyGenerator;

        public BuiltInKeyGenRowKeyExtractor(BuiltinKeyGenerator keyGenerator) {
            this.keyGenerator = keyGenerator;
        }

        @Override
        public String getPartitionPath(Row row) {
            return this.keyGenerator.getPartitionPath(row);
        }

        @Override
        public String getRecordKey(Row row) {
            return this.keyGenerator.getRecordKey(row);
        }
    }

    public static class MetaFiledRowKeyExtractor
    implements RowRecordKeyExtractor {
        @Override
        public String getPartitionPath(Row row) {
            return row.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        }

        @Override
        public String getRecordKey(Row row) {
            return row.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
        }
    }
}

