/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.util.ConsistentHashingUpdateStrategyUtils;
import org.apache.hudi.table.action.commit.BucketBulkInsertDataInternalWriterHelper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentBucketBulkInsertDataInternalWriterHelper
extends BucketBulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentBucketBulkInsertDataInternalWriterHelper.class);

    public ConsistentBucketBulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, false);
    }

    public ConsistentBucketBulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted, boolean shouldPreserveHoodieMetadata) {
        super(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, shouldPreserveHoodieMetadata);
    }

    @Override
    public void write(InternalRow row) throws IOException {
        try {
            if (this.handle == null) {
                String partitionPath = String.valueOf(this.extractPartitionPath(row));
                String recordKey = String.valueOf(this.extractRecordKey(row));
                this.handle = this.getBucketRowCreateHandle(partitionPath, recordKey);
            }
            this.handle.write(row);
        }
        catch (Throwable t) {
            LOG.error("Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw new IOException(t);
        }
    }

    private HoodieRowCreateHandle getBucketRowCreateHandle(String partitionPath, String recordKey) {
        ConsistentBucketIdentifier identifier = this.getBucketIdentifier(partitionPath);
        ConsistentHashingNode node = identifier.getBucket(recordKey, this.indexKeyFields);
        String fileId = FSUtils.createNewFileId((String)node.getFileIdPrefix(), (int)0);
        ValidationUtils.checkArgument((node.getTag() != ConsistentHashingNode.NodeTag.NORMAL || this.hoodieTable.getFileSystemView().getAllFileGroups(partitionPath).filter(fg -> fg.getAllFileSlices().findAny().isPresent()).noneMatch(fg -> fg.getFileGroupId().getFileId().equals(fileId)) ? 1 : 0) != 0, (String)"Consistent Hashing bulk_insert only support write to new file group");
        return new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, fileId, this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType, this.shouldPreserveHoodieMetadata);
    }

    private ConsistentBucketIdentifier getBucketIdentifier(String partition) {
        Set fileGroupsInPendingClustering = this.hoodieTable.getFileSystemView().getFileGroupsInPendingClustering().map(Pair::getKey).collect(Collectors.toSet());
        if (fileGroupsInPendingClustering.stream().anyMatch(f -> f.getPartitionPath().equals(partition))) {
            Pair bucketIdentifierPair = (Pair)ConsistentHashingUpdateStrategyUtils.constructPartitionToIdentifier(Collections.singleton(partition), (HoodieTable)this.hoodieTable).get(partition);
            return (ConsistentBucketIdentifier)bucketIdentifierPair.getRight();
        }
        HoodieConsistentHashingMetadata metadata = ConsistentBucketIndexUtils.loadOrCreateMetadata((HoodieTable)this.hoodieTable, (String)String.valueOf(partition), (int)this.bucketNum);
        ValidationUtils.checkState((metadata != null ? 1 : 0) != 0);
        return new ConsistentBucketIdentifier(metadata);
    }

    @Override
    public void close() throws IOException {
        if (this.handle != null) {
            LOG.info("Closing bulk insert file " + this.handle.getFileName());
            this.writeStatusList.add(this.handle.close());
            this.handle = null;
        }
    }
}

