/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.SparkHoodiePartitioner;
import scala.Tuple2;

public class SparkBucketIndexPartitioner<T>
extends SparkHoodiePartitioner<T> {
    private final int numBuckets;
    private final String indexKeyField;
    private final int totalPartitionPaths;
    private final List<String> partitionPaths;
    private final Map<String, Integer> partitionPathOffset;
    private final boolean isOverwrite;
    private Map<String, Set<String>> updatePartitionPathFileIds;

    public SparkBucketIndexPartitioner(WorkloadProfile profile, HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config) {
        super(profile, table);
        if (!(table.getIndex() instanceof HoodieBucketIndex)) {
            throw new HoodieException(" Bucket index partitioner should only be used by BucketIndex other than " + table.getIndex().getClass().getSimpleName());
        }
        this.numBuckets = ((HoodieBucketIndex)table.getIndex()).getNumBuckets();
        this.indexKeyField = config.getBucketIndexHashField();
        this.totalPartitionPaths = profile.getPartitionPaths().size();
        this.partitionPaths = new ArrayList<String>(profile.getPartitionPaths());
        this.partitionPathOffset = new HashMap<String, Integer>();
        int i = 0;
        for (Object partitionPath : profile.getPartitionPaths()) {
            this.partitionPathOffset.put(partitionPath.toString(), i);
            i += this.numBuckets;
        }
        this.assignUpdates(profile);
        WriteOperationType operationType = profile.getOperationType();
        this.isOverwrite = WriteOperationType.INSERT_OVERWRITE.equals((Object)operationType) || WriteOperationType.INSERT_OVERWRITE_TABLE.equals((Object)operationType);
    }

    private void assignUpdates(WorkloadProfile profile) {
        this.updatePartitionPathFileIds = new HashMap<String, Set<String>>();
        Set partitionStatEntries = profile.getInputPartitionPathStatMap().entrySet();
        for (Map.Entry partitionStat : partitionStatEntries) {
            if (!this.updatePartitionPathFileIds.containsKey(partitionStat.getKey())) {
                this.updatePartitionPathFileIds.put((String)partitionStat.getKey(), new HashSet());
            }
            for (Map.Entry updateLocEntry : ((WorkloadStat)partitionStat.getValue()).getUpdateLocationToCount().entrySet()) {
                this.updatePartitionPathFileIds.get(partitionStat.getKey()).add((String)updateLocEntry.getKey());
            }
        }
    }

    @Override
    public BucketInfo getBucketInfo(int bucketNumber) {
        String partitionPath = this.partitionPaths.get(bucketNumber / this.numBuckets);
        String bucketId = BucketIdentifier.bucketIdStr((int)(bucketNumber % this.numBuckets));
        if (this.isOverwrite) {
            return new BucketInfo(BucketType.INSERT, BucketIdentifier.newBucketFileIdPrefix((String)bucketId), partitionPath);
        }
        Option fileIdOption = Option.fromJavaOptional(this.updatePartitionPathFileIds.getOrDefault(partitionPath, Collections.emptySet()).stream().filter(e -> e.startsWith(bucketId)).findFirst());
        if (fileIdOption.isPresent()) {
            return new BucketInfo(BucketType.UPDATE, (String)fileIdOption.get(), partitionPath);
        }
        return new BucketInfo(BucketType.INSERT, BucketIdentifier.newBucketFileIdPrefix((String)bucketId), partitionPath);
    }

    public int numPartitions() {
        return this.totalPartitionPaths * this.numBuckets;
    }

    public int getPartition(Object key) {
        Tuple2 keyLocation = (Tuple2)key;
        String partitionPath = ((HoodieKey)keyLocation._1).getPartitionPath();
        Option location = (Option)keyLocation._2;
        int bucketId = location.isPresent() ? BucketIdentifier.bucketIdFromFileId((String)((HoodieRecordLocation)location.get()).getFileId()) : BucketIdentifier.getBucketId((HoodieKey)((HoodieKey)keyLocation._1), (String)this.indexKeyField, (int)this.numBuckets);
        return this.partitionPathOffset.get(partitionPath) + bucketId;
    }
}

