/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteCommitActionExecutor;

public class SparkInsertOverwriteTableCommitActionExecutor<T>
extends SparkInsertOverwriteCommitActionExecutor<T> {
    public SparkInsertOverwriteTableCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieData<HoodieRecord<T>> inputRecordsRDD) {
        super(context, config, table, instantTime, inputRecordsRDD, WriteOperationType.INSERT_OVERWRITE_TABLE);
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<HoodieData<WriteStatus>> writeMetadata) {
        List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieStorage)this.table.getStorage(), (HoodieMetadataConfig)this.config.getMetadataConfig(), (String)this.table.getMetaClient().getBasePath());
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Getting ExistingFileIds of all partitions");
        return HoodieJavaPairRDD.getJavaPairRDD(this.context.parallelize(partitionPaths, partitionPaths.size()).mapToPair((SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
    }
}

