/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.HoodieCompactor;

public class HoodieSparkMergeOnReadTableCompactor<T>
extends HoodieCompactor<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    public void preCompact(HoodieTable table, HoodieTimeline pendingCompactionTimeline, WriteOperationType operationType, String instantTime) {
        HoodieInstant requestedCompactionInstantTime;
        HoodieInstant hoodieInstant = requestedCompactionInstantTime = WriteOperationType.COMPACT.equals((Object)operationType) ? HoodieTimeline.getCompactionRequestedInstant((String)instantTime) : HoodieTimeline.getLogCompactionRequestedInstant((String)instantTime);
        if (!pendingCompactionTimeline.containsInstant(requestedCompactionInstantTime)) {
            throw new IllegalStateException("No Compaction request available at " + requestedCompactionInstantTime.getTimestamp() + " to run compaction");
        }
    }

    public void maybePersist(HoodieData<WriteStatus> writeStatus, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        writeStatus.persist(config.getString(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL_VALUE), context, HoodieData.HoodieDataCacheKey.of((String)config.getBasePath(), (String)instantTime));
    }
}

