/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class PathUtils$ {
    public static PathUtils$ MODULE$;

    static {
        new PathUtils$();
    }

    public boolean isGlobPath(StoragePath pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1 & java.io.Serializable & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem)));
    }

    public Seq<StoragePath> globPath(HoodieStorage storage, StoragePath pattern) {
        ObjectRef basePath = ObjectRef.create((Object)pattern.getParent());
        while (((StoragePath)basePath.elem).getName().equals("*")) {
            basePath.elem = ((StoragePath)basePath.elem).getParent();
        }
        return (Seq)Option$.MODULE$.apply((Object)storage.globEntries(pattern)).map((Function1 & java.io.Serializable & Serializable)pathInfoList -> {
            Buffer nonMetaStatuses = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pathInfoList).asScala()).filterNot((Function1 & java.io.Serializable & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PathUtils$.$anonfun$globPath$2(basePath, entry)));
            return ((SeqLike)nonMetaStatuses.map((Function1 & java.io.Serializable & Serializable)e -> e.getPath().makeQualified(storage.getUri()), Buffer$.MODULE$.canBuildFrom())).toSeq();
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Seq<StoragePath> globPathIfNecessary(HoodieStorage storage, StoragePath pattern) {
        return this.isGlobPath(pattern) ? this.globPath(storage, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoragePath[]{pattern}));
    }

    public Seq<StoragePath> checkAndGlobPathIfNecessary(Seq<String> paths, HoodieStorage storage) {
        return (Seq)paths.flatMap((Function1 & java.io.Serializable & Serializable)path -> {
            StoragePath qualified = new StoragePath(path).makeQualified(storage.getUri());
            return MODULE$.globPathIfNecessary(storage, qualified);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$globPath$2(ObjectRef basePath$1, StoragePathInfo entry) {
        StoragePath leafPath = entry.getPath();
        while (!leafPath.equals((Object)((StoragePath)basePath$1.elem)) && !leafPath.getName().equals(".hoodie")) {
            leafPath = leafPath.getParent();
        }
        return leafPath.getName().equals(".hoodie");
    }

    private PathUtils$() {
        MODULE$ = this;
    }
}

