/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.optimize.HilbertCurveUtils;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.hudi.execution.ByteArraySorting;
import org.apache.spark.sql.hudi.execution.RangeSample;
import org.apache.spark.sql.hudi.execution.RangeSample$;
import org.apache.spark.sql.hudi.execution.RawDecisionBound;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.MutablePair;
import org.davidmoten.hilbert.HilbertCurve;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class RangeSampleSort$ {
    public static RangeSampleSort$ MODULE$;

    static {
        new RangeSampleSort$();
    }

    public Dataset<Row> sortDataFrameBySample(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, Seq<String> orderByCols, int targetPartitionsCount) {
        Dataset dataset;
        SparkSession spark = df.sparkSession();
        Map columnsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).map((Function1 & Serializable & scala.Serializable)item -> new Tuple2((Object)item.name(), item), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        int fieldNum = df.schema().fields().length;
        Seq checkCols = (Seq)orderByCols.filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)RangeSampleSort$.$anonfun$sortDataFrameBySample$2(columnsMap, col)));
        if (orderByCols.isEmpty() || checkCols.isEmpty()) {
            dataset = df;
        } else {
            Seq zFields = (Seq)((TraversableLike)orderByCols.map((Function1 & Serializable & scala.Serializable)col -> {
                Tuple2 tuple2;
                StructField newCol = (StructField)columnsMap.apply(col);
                if (newCol == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), null);
                } else {
                    DataType dataType = newCol.dataType();
                    boolean bl = LongType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType))))))));
                    Tuple2 tuple22 = bl ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).indexOf((Object)newCol)), (Object)newCol) : (dataType instanceof DecimalType ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).indexOf((Object)newCol)), (Object)newCol) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), null));
                    tuple2 = tuple22;
                }
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)RangeSampleSort$.$anonfun$sortDataFrameBySample$4(x$12)));
            if (zFields.length() != orderByCols.length()) {
                return this.sortDataFrameBySampleSupportAllTypes(df, orderByCols, targetPartitionsCount);
            }
            RDD rawRdd = df.rdd();
            RDD sampleRdd = rawRdd.map((Function1 & Serializable & scala.Serializable)row -> {
                Object[] values = (Object[])((TraversableOnce)((TraversableLike)zFields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int index = tuple2._1$mcI$sp();
                    StructField field = (StructField)tuple2._2();
                    DataType dataType = field.dataType();
                    Object object = LongType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getLong(index))) : (DoubleType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)Double.doubleToLongBits(row.getDouble(index)))) : (IntegerType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getInt(index))) : (FloatType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)Double.doubleToLongBits(row.getFloat(index)))) : (StringType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? "" : row.getString(index)) : (DateType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getDate(index).getTime())) : (TimestampType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getTimestamp(index).getTime())) : (ByteType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getByte(index))) : (ShortType$.MODULE$.equals(dataType) ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getShort(index))) : (dataType instanceof DecimalType ? (row.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)row.getDecimal(index).longValue())) : null)))))))));
                    Long l = object;
                    return l;
                }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)RangeSampleSort$.$anonfun$sortDataFrameBySample$7(v)))).toArray(ClassTag$.MODULE$.Any());
                return new Tuple2((Object)values, null);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            int zOrderBounds = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.key(), ((String)HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.defaultValue()).toString()))).toInt();
            RangeSample sample = new RangeSample(zOrderBounds, sampleRdd, RangeSample$.MODULE$.$lessinit$greater$default$3(), RangeSample$.MODULE$.$lessinit$greater$default$4(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
            ArrayBuffer rangeBounds = sample.getRangeBounds();
            if (rangeBounds.size() <= 1) {
                return df;
            }
            int candidateColNumber = ((Object[])((Tuple2)rangeBounds.head())._1()).length;
            IndexedSeq sampleBounds = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), candidateColNumber - 1).map((Function1 & Serializable & scala.Serializable)i -> RangeSampleSort$.$anonfun$sortDataFrameBySample$8(rangeBounds, sample, zOrderBounds, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            int maxLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)sampleBounds.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(x$13)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            IndexedSeq expandSampleBoundsWithFactor = (IndexedSeq)sampleBounds.map((Function1 & Serializable & scala.Serializable)bound -> {
                Tuple2 tuple2;
                int fillFactor = maxLength / Predef$.MODULE$.genericArrayOps(bound).size();
                double[] newBound = new double[ScalaRunTime$.MODULE$.array_length(bound) * fillFactor];
                if (bound instanceof long[] && fillFactor > 1) {
                    long[] longBound = (long[])bound;
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ScalaRunTime$.MODULE$.array_length(bound) - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), fillFactor - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                        newBound$1[j + i$2 * fillFactor$1] = (double)longBound[i] + (double)(j + 1) * (1.0 / (double)fillFactor);
                    }));
                    tuple2 = new Tuple2((Object)newBound, (Object)BoxesRunTime.boxToInteger((int)fillFactor));
                } else {
                    tuple2 = new Tuple2(bound, (Object)BoxesRunTime.boxToInteger((int)0));
                }
                return tuple2;
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Broadcast boundBroadCast = spark.sparkContext().broadcast((Object)expandSampleBoundsWithFactor, ClassTag$.MODULE$.apply(IndexedSeq.class));
            RDD qual$1 = rawRdd.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                IndexedSeq expandBoundsWithFactor = (IndexedSeq)boundBroadCast.value();
                int maxBoundNum = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expandBoundsWithFactor.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(x$14._1())), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
                RawDecisionBound longDecisionBound = new RawDecisionBound(package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$), Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long());
                RawDecisionBound doubleDecisionBound = new RawDecisionBound(package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$), Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
                RawDecisionBound stringDecisionBound = new RawDecisionBound(package$.MODULE$.Ordering().apply((Ordering)Ordering.String$.MODULE$), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy = layoutOptStrategy;
                HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy2 = HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT;
                None$ hilbertCurve = !(layoutOptimizationStrategy != null ? !layoutOptimizationStrategy.equals(layoutOptimizationStrategy2) : layoutOptimizationStrategy2 != null) ? new Some((Object)HilbertCurve.bits((int)32).dimensions(zFields.length())) : None$.MODULE$;
                return iter.map(arg_0 -> RangeSampleSort$.$anonfun$sortDataFrameBySample$16(zFields, maxBoundNum, expandBoundsWithFactor, stringDecisionBound, threadLocalRandom, layoutOptStrategy, (Option)hilbertCurve, doubleDecisionBound, longDecisionBound, arg_0));
            }, rawRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x -> new ByteArraySorting((byte[])x.getAs(fieldNum));
            int x$2 = targetPartitionsCount;
            boolean x$3 = qual$1.sortBy$default$2();
            RDD indexRdd = qual$1.sortBy((Function1)x$1, x$3, x$2, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(ByteArraySorting.class));
            Dataset newDF = df.sparkSession().createDataFrame(indexRdd, new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("index", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
            dataset = newDF.drop("index");
        }
        return dataset;
    }

    public Dataset<Row> sortDataFrameBySampleSupportAllTypes(Dataset<Row> df, Seq<String> zCols, int fileNum) {
        Dataset dataset;
        SparkSession spark = df.sparkSession();
        RDD internalRdd = df.queryExecution().toRdd();
        StructType schema = df.schema();
        Seq outputAttributes = df.queryExecution().analyzed().output();
        Seq sortingExpressions = (Seq)outputAttributes.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)zCols.contains((Object)p.name())));
        if (sortingExpressions.length() == 0 || sortingExpressions.length() != zCols.size()) {
            dataset = df;
        } else {
            int zOrderBounds = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.key(), ((String)HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.defaultValue()).toString()))).toInt();
            RDD sampleRdd = internalRdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create(sortingExpressions, outputAttributes);
                MutablePair mutablePair = new MutablePair();
                return iter.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)projection.apply(row).copy(), null));
            }, internalRdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Seq orderings = (Seq)((TraversableLike)((IterableLike)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$18 -> SortOrder$.MODULE$.apply((Expression)x$18, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SortOrder ord = (SortOrder)tuple2._1();
                int i = tuple2._2$mcI$sp();
                SortOrder sortOrder = ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                return sortOrder;
            }, Seq$.MODULE$.canBuildFrom());
            Seq lazyGeneratedOrderings = (Seq)orderings.map((Function1 & Serializable & scala.Serializable)ord -> new LazilyGeneratedOrdering((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{ord}))), Seq$.MODULE$.canBuildFrom());
            RangeSample sample = new RangeSample(zOrderBounds, sampleRdd, RangeSample$.MODULE$.$lessinit$greater$default$3(), RangeSample$.MODULE$.$lessinit$greater$default$4(), ClassTag$.MODULE$.apply(InternalRow.class));
            ArrayBuffer rangeBounds = sample.getRangeBounds();
            if (rangeBounds.size() <= 1) {
                return df;
            }
            LazilyGeneratedOrdering ordering1 = (LazilyGeneratedOrdering)lazyGeneratedOrderings.apply(0);
            UnsafeRow[][] sampleBounds = sample.determineRowBounds(rangeBounds, scala.math.package$.MODULE$.min(zOrderBounds, rangeBounds.length()), lazyGeneratedOrderings, (Seq<Attribute>)sortingExpressions, ordering1, ClassTag$.MODULE$.apply(InternalRow.class));
            Seq origin_orderings = (Seq)((TraversableLike)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$19 -> SortOrder$.MODULE$.apply((Expression)x$19, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)ord -> ord.copy((Expression)new BoundReference(0, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4()), Seq$.MODULE$.canBuildFrom());
            Seq origin_lazyGeneratedOrderings = (Seq)origin_orderings.map((Function1 & Serializable & scala.Serializable)ord -> new LazilyGeneratedOrdering((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{ord}))), Seq$.MODULE$.canBuildFrom());
            int maxLength = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleBounds)).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)RangeSampleSort$.$anonfun$sortDataFrameBySampleSupportAllTypes$10(x$20)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
            Tuple2[] expandSampleBoundsWithFactor = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleBounds)).map((Function1 & Serializable & scala.Serializable)bound -> {
                double fillFactor = (double)maxLength / (double)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bound)).size();
                return new Tuple2(bound, (Object)BoxesRunTime.boxToDouble((double)fillFactor));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Broadcast boundBroadCast = spark.sparkContext().broadcast((Object)expandSampleBoundsWithFactor, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            RDD qual$1 = internalRdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> {
                Tuple2[] boundsWithFactor = (Tuple2[])boundBroadCast.value();
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                int maxBoundNum = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])boundsWithFactor)).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)RangeSampleSort$.$anonfun$sortDataFrameBySampleSupportAllTypes$13(x$21)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
                Seq origin_Projections = (Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)se -> UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{se})), outputAttributes), Seq$.MODULE$.canBuildFrom());
                return iter.map((Function1 & Serializable & scala.Serializable)unsafeRow -> {
                    byte[][] interleaveValues = (byte[][])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])((TraversableOnce)((TraversableLike)((IterableLike)origin_Projections.zip((GenIterable)origin_lazyGeneratedOrderings, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)RangeSampleSort$.$anonfun$sortDataFrameBySampleSupportAllTypes$16(unsafeRow, ordering1, maxBoundNum, boundsWithFactor, threadLocalRandom, x0$2)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)x$23 -> RangeSampleSort$.$anonfun$sortDataFrameBySampleSupportAllTypes$17(BoxesRunTime.unboxToInt((Object)x$23)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
                    byte[] zValues = BinaryUtil.interleaving((byte[][])interleaveValues, (int)8);
                    MutablePair mutablePair = new MutablePair();
                    return mutablePair.update(unsafeRow, (Object)zValues);
                });
            }, internalRdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x -> new ByteArraySorting((byte[])x._2());
            int x$2 = fileNum;
            boolean x$3 = qual$1.sortBy$default$2();
            RDD indexRdd = qual$1.sortBy((Function1)x$1, x$3, x$2, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(ByteArraySorting.class)).map((Function1 & Serializable & scala.Serializable)x$24 -> (InternalRow)x$24._1(), ClassTag$.MODULE$.apply(InternalRow.class));
            dataset = spark.internalCreateDataFrame(indexRdd, schema, spark.internalCreateDataFrame$default$3());
        }
        return dataset;
    }

    public static final /* synthetic */ boolean $anonfun$sortDataFrameBySample$2(Map columnsMap$1, String col) {
        return columnsMap$1.apply((Object)col) != null;
    }

    public static final /* synthetic */ boolean $anonfun$sortDataFrameBySample$4(Tuple2 x$12) {
        return x$12._1$mcI$sp() != -1;
    }

    public static final /* synthetic */ boolean $anonfun$sortDataFrameBySample$7(Object v) {
        return v != null;
    }

    public static final /* synthetic */ Object $anonfun$sortDataFrameBySample$8(ArrayBuffer rangeBounds$1, RangeSample sample$1, int zOrderBounds$1, int i) {
        ArrayBuffer colRangeBound = (ArrayBuffer)rangeBounds$1.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((Object[])x._1())[i], x._2()), ArrayBuffer$.MODULE$.canBuildFrom());
        return ((Tuple2)colRangeBound.head())._1() instanceof String ? sample$1.determineBound(colRangeBound, scala.math.package$.MODULE$.min(zOrderBounds$1, rangeBounds$1.length()), package$.MODULE$.Ordering().apply((Ordering)Ordering.String$.MODULE$), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : sample$1.determineBound(colRangeBound, scala.math.package$.MODULE$.min(zOrderBounds$1, rangeBounds$1.length()), package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$), Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long());
    }

    private static final int getRank$1(int rawIndex, long value, boolean isNull, IndexedSeq expandBoundsWithFactor$1, RawDecisionBound doubleDecisionBound$1, ThreadLocalRandom threadLocalRandom$1, RawDecisionBound longDecisionBound$1) {
        Tuple2 tuple2 = (Tuple2)expandBoundsWithFactor$1.apply(rawIndex);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object expandBound = tuple2._1();
        int factor = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2(expandBound, (Object)BoxesRunTime.boxToInteger((int)factor));
        Tuple2 tuple23 = tuple22;
        Object expandBound2 = tuple23._1();
        int factor2 = tuple23._2$mcI$sp();
        return isNull ? ScalaRunTime$.MODULE$.array_length(expandBound2) + 1 : (factor2 > 1 ? doubleDecisionBound$1.getBound(BoxesRunTime.boxToDouble((double)((double)value + (double)(threadLocalRandom$1.nextInt(factor2) + 1) * (1.0 / (double)factor2))), (double[])expandBound2) : longDecisionBound$1.getBound(BoxesRunTime.boxToLong((long)value), (long[])expandBound2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$sortDataFrameBySample$17(Row row$2, int maxBoundNum$1, IndexedSeq expandBoundsWithFactor$1, RawDecisionBound stringDecisionBound$1, ThreadLocalRandom threadLocalRandom$1, RawDecisionBound doubleDecisionBound$1, RawDecisionBound longDecisionBound$1, Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int rawIndex = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        int index = tuple22._1$mcI$sp();
        StructField field = (StructField)tuple22._2();
        DataType dataType = field.dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : row$2.getLong(index), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : Double.doubleToLongBits(row$2.getDouble(index)), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : (long)row$2.getInt(index), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : Double.doubleToLongBits(row$2.getFloat(index)), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (StringType$.MODULE$.equals(dataType)) {
            int n2;
            double factor = (double)maxBoundNum$1 / (double)ScalaRunTime$.MODULE$.array_length(((Tuple2)expandBoundsWithFactor$1.apply(rawIndex))._1());
            if (row$2.isNullAt(index)) {
                n2 = maxBoundNum$1 + 1;
            } else {
                int currentRank = stringDecisionBound$1.getBound(row$2.getString(index), (String[])((Tuple2)expandBoundsWithFactor$1.apply(rawIndex))._1());
                n2 = factor > 1.0 ? (int)((double)currentRank * factor) + threadLocalRandom$1.nextInt((int)factor) : currentRank;
            }
            n = n2;
            return n;
        } else if (DateType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : row$2.getDate(index).getTime(), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : row$2.getTimestamp(index).getTime(), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : (long)row$2.getByte(index), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : (long)row$2.getShort(index), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
            return n;
        } else {
            if (!(dataType instanceof DecimalType)) return -1;
            boolean isNull = row$2.isNullAt(index);
            n = RangeSampleSort$.getRank$1(rawIndex, isNull ? 0L : row$2.getDecimal(index).longValue(), isNull, expandBoundsWithFactor$1, doubleDecisionBound$1, threadLocalRandom$1, longDecisionBound$1);
        }
        return n;
    }

    public static final /* synthetic */ byte[] $anonfun$sortDataFrameBySample$20(int x$17) {
        return BinaryUtil.intTo8Byte((int)x$17);
    }

    public static final /* synthetic */ Row $anonfun$sortDataFrameBySample$16(Seq zFields$1, int maxBoundNum$1, IndexedSeq expandBoundsWithFactor$1, RawDecisionBound stringDecisionBound$1, ThreadLocalRandom threadLocalRandom$1, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy$1, Option hilbertCurve$1, RawDecisionBound doubleDecisionBound$1, RawDecisionBound longDecisionBound$1, Row row) {
        byte[] byArray;
        Seq values = (Seq)((TraversableLike)((TraversableLike)zFields$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)RangeSampleSort$.$anonfun$sortDataFrameBySample$17(row, maxBoundNum$1, expandBoundsWithFactor$1, stringDecisionBound$1, threadLocalRandom$1, doubleDecisionBound$1, longDecisionBound$1, x0$2)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)v -> v != -1);
        HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy = layoutOptStrategy$1;
        if (HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT.equals(layoutOptimizationStrategy)) {
            byArray = HilbertCurveUtils.indexBytes((HilbertCurve)((HilbertCurve)hilbertCurve$1.get()), (long[])((long[])((TraversableOnce)values.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$16 -> x$16, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long())), (int)32);
        } else if (HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER.equals(layoutOptimizationStrategy)) {
            byArray = BinaryUtil.interleaving((byte[][])((byte[][])((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)x$17 -> RangeSampleSort$.$anonfun$sortDataFrameBySample$20(BoxesRunTime.unboxToInt((Object)x$17)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), (int)8);
        } else {
            throw new MatchError((Object)layoutOptimizationStrategy);
        }
        byte[] mapValues = byArray;
        return Row$.MODULE$.fromSeq((Seq)row.toSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{mapValues})), Seq$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ int $anonfun$sortDataFrameBySampleSupportAllTypes$10(UnsafeRow[] x$20) {
        return x$20.length;
    }

    public static final /* synthetic */ int $anonfun$sortDataFrameBySampleSupportAllTypes$13(Tuple2 x$21) {
        return ((UnsafeRow[])x$21._1()).length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$sortDataFrameBySampleSupportAllTypes$16(InternalRow unsafeRow$1, LazilyGeneratedOrdering ordering1$1, int maxBoundNum$2, Tuple2[] boundsWithFactor$1, ThreadLocalRandom threadLocalRandom$2, Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        UnsafeProjection rowProject = (UnsafeProjection)tuple22._1();
        LazilyGeneratedOrdering lazyOrdering = (LazilyGeneratedOrdering)tuple22._2();
        UnsafeRow row = rowProject.apply(unsafeRow$1);
        RawDecisionBound decisionBound = new RawDecisionBound(lazyOrdering, ordering1$1, ClassTag$.MODULE$.apply(InternalRow.class));
        if (row.isNullAt(0)) {
            n = maxBoundNum$2 + 1;
            return n;
        } else {
            Tuple2 tuple23 = boundsWithFactor$1[index];
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            UnsafeRow[] bound = (UnsafeRow[])tuple23._1();
            double factor = tuple23._2$mcD$sp();
            Tuple2 tuple24 = new Tuple2((Object)bound, (Object)BoxesRunTime.boxToDouble((double)factor));
            Tuple2 tuple25 = tuple24;
            UnsafeRow[] bound2 = (UnsafeRow[])tuple25._1();
            double factor2 = tuple25._2$mcD$sp();
            if (factor2 > 1.0) {
                int currentRank = decisionBound.getBound(row, (InternalRow[])bound2);
                n = currentRank * (int)factor2 + threadLocalRandom$2.nextInt((int)factor2);
                return n;
            } else {
                n = decisionBound.getBound(row, (InternalRow[])bound2);
            }
        }
        return n;
    }

    public static final /* synthetic */ byte[] $anonfun$sortDataFrameBySampleSupportAllTypes$17(int x$23) {
        return BinaryUtil.intTo8Byte((int)x$23);
    }

    private RangeSampleSort$() {
        MODULE$ = this;
    }
}

