/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.OverwriteWithLatestSparkRecordMerger;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import scala.Function1;

public abstract class BaseSparkInternalRowReaderContext
extends HoodieReaderContext<InternalRow> {
    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return Option.of((Object)new DefaultSparkRecordMerger());
            }
            case COMMIT_TIME_ORDERING: {
                return Option.of((Object)new OverwriteWithLatestSparkRecordMerger());
            }
        }
        if (mergeStrategyId.equals("00000000-0000-0000-0000-000000000000")) {
            return Option.of((Object)HoodieAvroRecordMerger.INSTANCE);
        }
        Option mergerClass = HoodieRecordUtils.createValidRecordMerger((EngineType)EngineType.SPARK, (String)mergeImplClasses, (String)mergeStrategyId);
        if (mergerClass.isEmpty()) {
            throw new IllegalArgumentException("No valid spark merger implementation set for `hoodie.write.record.merge.custom.implementation.classes`");
        }
        return mergerClass;
    }

    public Object getValue(InternalRow row, Schema schema, String fieldName) {
        return this.getFieldValueFromInternalRow(row, schema, fieldName);
    }

    public String getRecordKey(InternalRow row, Schema schema) {
        return this.getFieldValueFromInternalRow(row, schema, HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    public HoodieRecord<InternalRow> constructHoodieRecord(Option<InternalRow> rowOption, Map<String, Object> metadataMap) {
        if (!rowOption.isPresent()) {
            return new HoodieEmptyRecord(new HoodieKey((String)metadataMap.get("_0"), (String)metadataMap.get("_1")), HoodieRecord.HoodieRecordType.SPARK);
        }
        Schema schema = this.getSchemaHandler().decodeAvroSchema(metadataMap.get("_5"));
        InternalRow row = (InternalRow)rowOption.get();
        return new HoodieSparkRecord(row, HoodieInternalRowUtils.getCachedSchema(schema));
    }

    public InternalRow seal(InternalRow internalRow) {
        return internalRow.copy();
    }

    private Object getFieldValueFromInternalRow(InternalRow row, Schema recordSchema, String fieldName) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        scala.Option<HoodieUnsafeRowUtils.NestedFieldPath> cachedNestedFieldPath = HoodieInternalRowUtils.getCachedPosList(structType, fieldName);
        if (cachedNestedFieldPath.isDefined()) {
            HoodieUnsafeRowUtils.NestedFieldPath nestedFieldPath = (HoodieUnsafeRowUtils.NestedFieldPath)cachedNestedFieldPath.get();
            return HoodieUnsafeRowUtils.getNestedInternalRowValue(row, nestedFieldPath);
        }
        return null;
    }

    public UnaryOperator<InternalRow> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        Function1<InternalRow, UnsafeRow> unsafeRowWriter = HoodieInternalRowUtils.getCachedUnsafeRowWriter(HoodieInternalRowUtils.getCachedSchema(from), HoodieInternalRowUtils.getCachedSchema(to), renamedColumns);
        return row -> (InternalRow)unsafeRowWriter.apply(row);
    }

    protected UnaryOperator<InternalRow> getIdentityProjection() {
        return row -> row;
    }
}

