/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDTableServiceClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.SparkReleaseResources;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRDDWriteClient<T>
extends BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRDDWriteClient.class);

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, (Option<EmbeddedTimelineService>)Option.empty());
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance());
        this.tableServiceClient = new SparkRDDTableServiceClient(context, writeConfig, (Option<EmbeddedTimelineService>)this.getTimelineServer());
    }

    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return SparkHoodieIndexFactory.createIndex(this.config);
    }

    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Committing stats: " + this.config.getTableName());
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds, extraPreCommitFunc);
    }

    protected HoodieTable createTable(HoodieWriteConfig config) {
        return this.createTableAndValidate(config, HoodieSparkTable::create);
    }

    protected HoodieTable createTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        return this.createTableAndValidate(config, metaClient, HoodieSparkTable::create);
    }

    public JavaRDD<HoodieRecord<T>> filterExists(JavaRDD<HoodieRecord<T>> hoodieRecords) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        JavaRDD recordsWithLocation = HoodieJavaRDD.getJavaRDD(this.getIndex().tagLocation(HoodieJavaRDD.of(hoodieRecords), this.context, table));
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.filter((Function & Serializable)v1 -> !v1.isCurrentLocationKnown());
    }

    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        this.initTable(WriteOperationType.UPSERT, Option.ofNullable((Object)"00000000000001")).bootstrap(this.context, extraMetadata);
    }

    public JavaRDD<WriteStatus> upsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable((Object)instantTime));
        this.maybeDisableWriteRecordPositions(table.getMetaClient());
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        if (result.getSourceReadAndIndexDurationMs().isPresent()) {
            this.metrics.updateSourceReadAndIndexMetrics("duration", ((Long)result.getSourceReadAndIndexDurationMs().get()).longValue());
        }
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> upsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable((Object)instantTime));
        this.maybeDisableWriteRecordPositions(table.getMetaClient());
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> insert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> insertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_PREPPED, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult insertOverwrite(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwrite(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult((JavaRDD<WriteStatus>)((JavaRDD)this.postWrite(resultRDD, instantTime, table)), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult insertOverwriteTable(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE_TABLE, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE_TABLE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwriteTable(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult((JavaRDD<WriteStatus>)((JavaRDD)this.postWrite(resultRDD, instantTime, table)), result.getPartitionToReplaceFileIds());
    }

    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, (Option<BulkInsertPartitioner>)Option.empty());
    }

    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsert(this.context, instantTime, HoodieJavaRDD.of(records), userDefinedBulkInsertPartitioner);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> bulkInsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT_PREPPED, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords), bulkInsertPartitioner);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> delete(JavaRDD<HoodieKey> keys, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE, Option.ofNullable((Object)instantTime));
        this.maybeDisableWriteRecordPositions(table.getMetaClient());
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, HoodieJavaRDD.of(keys));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> deletePrepped(JavaRDD<HoodieRecord<T>> preppedRecord, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PREPPED, Option.ofNullable((Object)instantTime));
        this.maybeDisableWriteRecordPositions(table.getMetaClient());
        this.preWrite(instantTime, WriteOperationType.DELETE_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecord));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult deletePartitions(List<String> partitions, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PARTITION, Option.ofNullable((Object)instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePartitions(this.context, instantTime, partitions);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult((JavaRDD<WriteStatus>)((JavaRDD)this.postWrite(resultRDD, instantTime, table)), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult managePartitionTTL(String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PARTITION, Option.ofNullable((Object)instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION, table.getMetaClient());
        HoodieWriteMetadata result = table.managePartitionTTL(this.context, instantTime);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult((JavaRDD<WriteStatus>)((JavaRDD)this.postWrite(resultRDD, instantTime, table)), result.getPartitionToReplaceFileIds());
    }

    protected void initMetadataTable(Option<String> instantTime, HoodieTableMetaClient metaClient) {
        this.initializeMetadataTable(instantTime, metaClient);
    }

    private void initializeMetadataTable(Option<String> inFlightInstantTimestamp, HoodieTableMetaClient metaClient) {
        if (!this.config.isMetadataTableEnabled()) {
            return;
        }
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (tableConfig.isMetadataTableAvailable()) {
            boolean isMetadataColStatsAvailable = false;
            boolean isMetadataBloomFilterAvailable = false;
            boolean isMetadataRliAvailable = false;
            if (tableConfig.getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                isMetadataColStatsAvailable = true;
            }
            if (tableConfig.getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath())) {
                isMetadataBloomFilterAvailable = true;
            }
            if (tableConfig.getMetadataPartitions().contains(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) {
                isMetadataRliAvailable = true;
            }
            this.metrics.emitMetadataEnablementMetrics(true, isMetadataColStatsAvailable, isMetadataBloomFilterAvailable, isMetadataRliAvailable);
        }
        try (HoodieTableMetadataWriter writer = SparkHoodieBackedTableMetadataWriter.create(this.context.getStorageConf(), this.config, this.context, inFlightInstantTimestamp);){
            if (writer.isInitialized()) {
                writer.performTableServices(inFlightInstantTimestamp);
            }
        }
        catch (Exception e) {
            throw new HoodieException("Failed to instantiate Metadata table ", (Throwable)e);
        }
    }

    protected void initWrapperFSMetrics() {
        if (this.config.isMetricsOn()) {
            Registry registryMeta;
            Registry registry;
            JavaSparkContext jsc = ((HoodieSparkEngineContext)this.context).getJavaSparkContext();
            if (this.config.isExecutorMetricsEnabled()) {
                registry = Registry.getRegistry((String)HoodieWrapperFileSystem.class.getSimpleName(), (String)DistributedRegistry.class.getName());
                ((DistributedRegistry)registry).register(jsc);
                registryMeta = Registry.getRegistry((String)(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder"), (String)DistributedRegistry.class.getName());
                ((DistributedRegistry)registryMeta).register(jsc);
            } else {
                registry = Registry.getRegistry((String)HoodieWrapperFileSystem.class.getSimpleName());
                registryMeta = Registry.getRegistry((String)(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder"));
            }
            HoodieWrapperFileSystem.setMetricsRegistry((Registry)registry, (Registry)registryMeta);
        }
    }

    protected void releaseResources(String instantTime) {
        SparkReleaseResources.releaseCachedData(this.context, this.config, this.basePath, instantTime);
    }
}

