/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.SparkLazyInsertIterable;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.function.Function2;

public class BulkInsertMapFunction<T>
implements Function2<Integer, Iterator<HoodieRecord<T>>, Iterator<List<WriteStatus>>> {
    private String instantTime;
    private boolean areRecordsSorted;
    private HoodieWriteConfig config;
    private HoodieTable hoodieTable;
    private boolean useWriterSchema;
    private BulkInsertPartitioner partitioner;
    private WriteHandleFactory writeHandleFactory;

    public BulkInsertMapFunction(String instantTime, boolean areRecordsSorted, HoodieWriteConfig config, HoodieTable hoodieTable, boolean useWriterSchema, BulkInsertPartitioner partitioner, WriteHandleFactory writeHandleFactory) {
        this.instantTime = instantTime;
        this.areRecordsSorted = areRecordsSorted;
        this.config = config;
        this.hoodieTable = hoodieTable;
        this.useWriterSchema = useWriterSchema;
        this.writeHandleFactory = writeHandleFactory;
        this.partitioner = partitioner;
    }

    public Iterator<List<WriteStatus>> call(Integer partition, Iterator<HoodieRecord<T>> recordItr) {
        return new SparkLazyInsertIterable<T>(recordItr, this.areRecordsSorted, this.config, this.instantTime, this.hoodieTable, this.partitioner.getFileIdPfx(partition.intValue()), this.hoodieTable.getTaskContextSupplier(), this.useWriterSchema, (WriteHandleFactory)this.partitioner.getWriteHandleFactory(partition.intValue()).orElse((Object)this.writeHandleFactory));
    }
}

