/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RowCustomColumnsSortPartitioner
implements BulkInsertPartitioner<Dataset<Row>> {
    private final String[] sortColumnNames;

    public RowCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this(RowCustomColumnsSortPartitioner.getSortColumnName(config), config);
    }

    public RowCustomColumnsSortPartitioner(String[] columnNames, HoodieWriteConfig config) {
        this.sortColumnNames = RowCustomColumnsSortPartitioner.tryPrependPartitionPathAndSuffixRecordKeyColumns(columnNames, config);
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> records, int outputSparkPartitions) {
        return records.sort((Column[])Arrays.stream(this.sortColumnNames).map(Column::new).toArray(Column[]::new)).coalesce(outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    static String[] tryPrependPartitionPathAndSuffixRecordKeyColumns(String[] columnNames, HoodieWriteConfig config) {
        String recordKeyFieldName;
        String partitionPath;
        if (config.populateMetaFields()) {
            partitionPath = HoodieRecord.HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.getFieldName();
            recordKeyFieldName = HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName();
        } else {
            partitionPath = config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
            recordKeyFieldName = config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
        }
        LinkedHashSet<String> sortCols = new LinkedHashSet<String>();
        if (!StringUtils.isNullOrEmpty((String)partitionPath)) {
            sortCols = new LinkedHashSet(StringUtils.split((String)partitionPath, (String)","));
        }
        sortCols.addAll(Arrays.asList(columnNames));
        boolean suffixRecordKey = config.getBoolean(HoodieWriteConfig.BULKINSERT_SUFFIX_RECORD_KEY_SORT_COLUMNS);
        if (suffixRecordKey) {
            sortCols.add(recordKeyFieldName);
        }
        return sortCols.toArray(new String[0]);
    }

    private static String[] getSortColumnName(HoodieWriteConfig config) {
        return (String[])Arrays.stream(config.getUserDefinedBulkInsertPartitionerSortColumns().split(",")).map(String::trim).toArray(String[]::new);
    }
}

