/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketizedBloomCheckPartitioner
extends Partitioner {
    private static final Logger LOG = LoggerFactory.getLogger(BucketizedBloomCheckPartitioner.class);
    private int partitions;
    private Map<HoodieFileGroupId, List<Integer>> fileGroupToPartitions = new HashMap<HoodieFileGroupId, List<Integer>>();

    public BucketizedBloomCheckPartitioner(int targetPartitions, Map<HoodieFileGroupId, Long> fileGroupToComparisons, int keysPerBucket) {
        HashMap bucketsPerFileGroup = new HashMap();
        fileGroupToComparisons.forEach((f, c) -> bucketsPerFileGroup.put(f, (int)Math.ceil((double)c.longValue() * 1.0 / (double)keysPerBucket)));
        int totalBuckets = bucketsPerFileGroup.values().stream().mapToInt(i -> i).sum();
        this.partitions = Math.min(targetPartitions, totalBuckets);
        int minBucketsPerPartition = Math.max((int)Math.floor(1.0 * (double)totalBuckets / (double)this.partitions), 1);
        LOG.info(String.format("TotalBuckets %d, min_buckets/partition %d", totalBuckets, minBucketsPerPartition));
        int[] bucketsFilled = new int[this.partitions];
        HashMap bucketsFilledPerFileGroup = new HashMap();
        int partitionIndex = 0;
        for (Map.Entry e : bucketsPerFileGroup.entrySet()) {
            for (int b = 0; b < Math.max(1, (Integer)e.getValue() - 1); ++b) {
                int n = partitionIndex;
                bucketsFilled[n] = bucketsFilled[n] + 1;
                AtomicInteger cnt = bucketsFilledPerFileGroup.getOrDefault(e.getKey(), new AtomicInteger(0));
                cnt.incrementAndGet();
                bucketsFilledPerFileGroup.put(e.getKey(), cnt);
                List partitionList = this.fileGroupToPartitions.getOrDefault(e.getKey(), new ArrayList());
                partitionList.add(partitionIndex);
                this.fileGroupToPartitions.put((HoodieFileGroupId)e.getKey(), partitionList);
                if (bucketsFilled[partitionIndex] < minBucketsPerPartition) continue;
                partitionIndex = (partitionIndex + 1) % this.partitions;
            }
        }
        for (Map.Entry e : bucketsPerFileGroup.entrySet()) {
            int remaining = (Integer)e.getValue() - ((AtomicInteger)bucketsFilledPerFileGroup.get(e.getKey())).intValue();
            for (int r = 0; r < remaining; ++r) {
                this.fileGroupToPartitions.get(e.getKey()).add(partitionIndex);
                int n = partitionIndex;
                bucketsFilled[n] = bucketsFilled[n] + 1;
                partitionIndex = (partitionIndex + 1) % this.partitions;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Partitions assigned per file groups :" + this.fileGroupToPartitions);
            StringBuilder str = new StringBuilder();
            for (int i2 = 0; i2 < bucketsFilled.length; ++i2) {
                str.append("p" + i2 + " : " + bucketsFilled[i2] + ",");
            }
            LOG.debug("Num buckets assigned per file group :" + str);
        }
    }

    public int numPartitions() {
        return this.partitions;
    }

    public int getPartition(Object key) {
        Pair parts = (Pair)key;
        long hashOfKey = NumericUtils.getMessageDigestHash((String)"MD5", (String)((String)parts.getRight()));
        List<Integer> candidatePartitions = this.fileGroupToPartitions.get(parts.getLeft());
        int idx = Math.floorMod((int)hashOfKey, candidatePartitions.size());
        assert (idx >= 0);
        return candidatePartitions.get(idx);
    }

    Map<HoodieFileGroupId, List<Integer>> getFileGroupToPartitions() {
        return this.fileGroupToPartitions;
    }
}

