/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.PartitionPathFormatterBase;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.StringPartitionPathFormatter;
import org.apache.hudi.keygen.UTF8StringPartitionPathFormatter;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Tuple2;

@ThreadSafe
public abstract class BuiltinKeyGenerator
extends BaseKeyGenerator
implements SparkKeyGeneratorInterface {
    private static final Logger LOG = LoggerFactory.getLogger(BuiltinKeyGenerator.class);
    protected static final String FIELDS_SEP = ",";
    protected static final UTF8String NULL_RECORD_KEY_PLACEHOLDER_UTF8 = UTF8String.fromString((String)"__null__");
    protected static final UTF8String EMPTY_RECORD_KEY_PLACEHOLDER_UTF8 = UTF8String.fromString((String)"__empty__");
    protected volatile transient SparkRowConverter rowConverter;
    protected volatile transient SparkRowAccessor rowAccessor;
    protected volatile transient StringPartitionPathFormatter stringPartitionPathFormatter;
    protected volatile transient UTF8StringPartitionPathFormatter utf8StringPartitionPathFormatter;

    protected BuiltinKeyGenerator(TypedProperties config) {
        super(config);
    }

    @Override
    public String getRecordKey(Row row) {
        this.tryInitRowConverter(row.schema());
        return this.getRecordKey(this.rowConverter.convertToAvro(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        this.tryInitRowConverter(schema);
        return UTF8String.fromString((String)this.getRecordKey(this.rowConverter.convertToAvro(internalRow)));
    }

    @Override
    public String getPartitionPath(Row row) {
        this.tryInitRowConverter(row.schema());
        return this.getPartitionPath(this.rowConverter.convertToAvro(row));
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        this.tryInitRowConverter(schema);
        GenericRecord avroRecord = this.rowConverter.convertToAvro(internalRow);
        return UTF8String.fromString((String)this.getPartitionPath(avroRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryInitRowAccessor(StructType schema) {
        if (this.rowAccessor == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.rowAccessor == null) {
                    this.rowAccessor = new SparkRowAccessor(schema);
                }
            }
        }
    }

    protected final String combinePartitionPath(Object ... partitionPathParts) {
        return (String)this.getStringPartitionPathFormatter().combine(this.partitionPathFields, partitionPathParts);
    }

    protected final UTF8String combinePartitionPathUnsafe(Object ... partitionPathParts) {
        return (UTF8String)this.getUTF8StringPartitionPathFormatter().combine(this.partitionPathFields, partitionPathParts);
    }

    protected final String combineRecordKey(List<String> fieldNames, List<Object> recordKeyParts) {
        return this.combineRecordKeyInternal(StringPartitionPathFormatter.JavaStringBuilder::new, BuiltinKeyGenerator::toString, BuiltinKeyGenerator::handleNullRecordKey, fieldNames, recordKeyParts);
    }

    protected final UTF8String combineRecordKeyUnsafe(List<String> fieldNames, List<Object> recordKeyParts) {
        return this.combineRecordKeyInternal(UTF8StringPartitionPathFormatter.UTF8StringBuilder::new, BuiltinKeyGenerator::toUTF8String, BuiltinKeyGenerator::handleNullRecordKey, fieldNames, recordKeyParts);
    }

    protected final String combineCompositeRecordKey(Object ... recordKeyParts) {
        return this.combineCompositeRecordKeyInternal(StringPartitionPathFormatter.JavaStringBuilder::new, BuiltinKeyGenerator::toString, BuiltinKeyGenerator::handleNullOrEmptyCompositeKeyPart, BuiltinKeyGenerator::isNullOrEmptyCompositeKeyPart, recordKeyParts);
    }

    protected final UTF8String combineCompositeRecordKeyUnsafe(Object ... recordKeyParts) {
        return this.combineCompositeRecordKeyInternal(UTF8StringPartitionPathFormatter.UTF8StringBuilder::new, BuiltinKeyGenerator::toUTF8String, BuiltinKeyGenerator::handleNullOrEmptyCompositeKeyPartUTF8, BuiltinKeyGenerator::isNullOrEmptyCompositeKeyPartUTF8, recordKeyParts);
    }

    private <S> S combineRecordKeyInternal(Supplier<PartitionPathFormatterBase.StringBuilder<S>> builderFactory, Function<Object, S> converter, Function<S, S> emptyKeyPartHandler, List<String> fieldNames, List<Object> recordKeyParts) {
        if (recordKeyParts.size() == 1) {
            return emptyKeyPartHandler.apply(converter.apply(recordKeyParts.get(0)));
        }
        PartitionPathFormatterBase.StringBuilder<S> sb = builderFactory.get();
        for (int i = 0; i < recordKeyParts.size(); ++i) {
            sb.appendJava(fieldNames.get(i)).appendJava(":");
            sb.append(emptyKeyPartHandler.apply(converter.apply(recordKeyParts.get(i))));
            if (i >= recordKeyParts.size() - 1) continue;
            sb.appendJava(FIELDS_SEP);
        }
        return sb.build();
    }

    private <S> S combineCompositeRecordKeyInternal(Supplier<PartitionPathFormatterBase.StringBuilder<S>> builderFactory, Function<Object, S> converter, Function<S, S> emptyKeyPartHandler, Predicate<S> isNullOrEmptyKeyPartPredicate, Object ... recordKeyParts) {
        boolean hasNonNullNonEmptyPart = false;
        PartitionPathFormatterBase.StringBuilder<S> sb = builderFactory.get();
        for (int i = 0; i < recordKeyParts.length; ++i) {
            S convertedKeyPart = emptyKeyPartHandler.apply(converter.apply(recordKeyParts[i]));
            if (recordKeyParts.length > 1) {
                sb.appendJava((String)this.recordKeyFields.get(i));
                sb.appendJava(":");
            }
            sb.append(convertedKeyPart);
            hasNonNullNonEmptyPart |= !isNullOrEmptyKeyPartPredicate.test(convertedKeyPart);
            if (i >= recordKeyParts.length - 1) continue;
            sb.appendJava(FIELDS_SEP);
        }
        if (hasNonNullNonEmptyPart) {
            return sb.build();
        }
        throw new HoodieKeyException(String.format("All of the values for (%s) were either null or empty", this.recordKeyFields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitRowConverter(StructType structType) {
        if (this.rowConverter == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.rowConverter == null) {
                    this.rowConverter = new SparkRowConverter(structType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringPartitionPathFormatter getStringPartitionPathFormatter() {
        if (this.stringPartitionPathFormatter == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.stringPartitionPathFormatter == null) {
                    this.stringPartitionPathFormatter = new StringPartitionPathFormatter(StringPartitionPathFormatter.JavaStringBuilder::new, this.hiveStylePartitioning, this.encodePartitionPath);
                }
            }
        }
        return this.stringPartitionPathFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UTF8StringPartitionPathFormatter getUTF8StringPartitionPathFormatter() {
        if (this.utf8StringPartitionPathFormatter == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.utf8StringPartitionPathFormatter == null) {
                    this.utf8StringPartitionPathFormatter = new UTF8StringPartitionPathFormatter(UTF8StringPartitionPathFormatter.UTF8StringBuilder::new, this.hiveStylePartitioning, this.encodePartitionPath);
                }
            }
        }
        return this.utf8StringPartitionPathFormatter;
    }

    protected static String requireNonNullNonEmptyKey(String key) {
        if (key != null && key.length() > 0) {
            return key;
        }
        throw new HoodieKeyException("Record key has to be non-empty string!");
    }

    protected static UTF8String requireNonNullNonEmptyKey(UTF8String key) {
        if (key != null && key.numChars() > 0) {
            return key;
        }
        throw new HoodieKeyException("Record key has to be non-empty string!");
    }

    protected static <S> S handleNullRecordKey(S s) {
        if (s == null || s.toString().isEmpty()) {
            throw new HoodieKeyException("Record key has to be non-null!");
        }
        return s;
    }

    static UTF8String toUTF8String(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof UTF8String) {
            return (UTF8String)o;
        }
        return UTF8String.fromString((String)o.toString());
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static String handleNullOrEmptyCompositeKeyPart(Object keyPart) {
        if (keyPart == null) {
            return "__null__";
        }
        String keyPartStr = keyPart.toString();
        return !keyPartStr.isEmpty() ? keyPartStr : "__empty__";
    }

    private static UTF8String handleNullOrEmptyCompositeKeyPartUTF8(UTF8String keyPart) {
        if (keyPart == null) {
            return NULL_RECORD_KEY_PLACEHOLDER_UTF8;
        }
        if (keyPart.numChars() == 0) {
            return EMPTY_RECORD_KEY_PLACEHOLDER_UTF8;
        }
        return keyPart;
    }

    private static boolean isNullOrEmptyCompositeKeyPart(String keyPart) {
        return keyPart == "__null__" || keyPart == "__empty__";
    }

    private static boolean isNullOrEmptyCompositeKeyPartUTF8(UTF8String keyPart) {
        return keyPart == NULL_RECORD_KEY_PLACEHOLDER_UTF8 || keyPart == EMPTY_RECORD_KEY_PLACEHOLDER_UTF8;
    }

    private static Object convertToLogicalDataType(DataType dataType, Object value) {
        if (value == null) {
            return null;
        }
        if (dataType instanceof TimestampType) {
            return new Timestamp((Long)value / 1000L);
        }
        if (dataType instanceof DateType) {
            return LocalDate.ofEpochDay(((Integer)value).intValue());
        }
        return value;
    }

    protected class SparkRowAccessor {
        private final HoodieUnsafeRowUtils.NestedFieldPath[] recordKeyFieldsPaths;
        private final HoodieUnsafeRowUtils.NestedFieldPath[] partitionPathFieldsPaths;

        SparkRowAccessor(StructType schema) {
            this.recordKeyFieldsPaths = this.resolveNestedFieldPaths(BuiltinKeyGenerator.this.getRecordKeyFieldNames(), schema, false);
            this.partitionPathFieldsPaths = this.resolveNestedFieldPaths(BuiltinKeyGenerator.this.getPartitionPathFields(), schema, true);
        }

        public Object[] getRecordKeyParts(Row row) {
            return this.getNestedFieldValues(row, this.recordKeyFieldsPaths);
        }

        public Object[] getRecordPartitionPathValues(Row row) {
            if (this.partitionPathFieldsPaths == null) {
                throw new HoodieException("Failed to resolve nested partition field");
            }
            return this.getNestedFieldValues(row, this.partitionPathFieldsPaths);
        }

        public Object[] getRecordKeyParts(InternalRow row) {
            return this.getNestedFieldValues(row, this.recordKeyFieldsPaths);
        }

        public Object[] getRecordPartitionPathValues(InternalRow row) {
            if (this.partitionPathFieldsPaths == null) {
                throw new HoodieException("Failed to resolve nested partition field");
            }
            return this.getNestedFieldValues(row, this.partitionPathFieldsPaths);
        }

        private Object[] getNestedFieldValues(Row row, HoodieUnsafeRowUtils.NestedFieldPath[] nestedFieldsPaths) {
            Object[] nestedFieldValues = new Object[nestedFieldsPaths.length];
            for (int i = 0; i < nestedFieldsPaths.length; ++i) {
                nestedFieldValues[i] = HoodieUnsafeRowUtils$.MODULE$.getNestedRowValue(row, nestedFieldsPaths[i]);
            }
            return nestedFieldValues;
        }

        private Object[] getNestedFieldValues(InternalRow row, HoodieUnsafeRowUtils.NestedFieldPath[] nestedFieldsPaths) {
            Object[] nestedFieldValues = new Object[nestedFieldsPaths.length];
            for (int i = 0; i < nestedFieldsPaths.length; ++i) {
                Object rawValue = HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue(row, nestedFieldsPaths[i]);
                DataType dataType = ((StructField)((Tuple2)CollectionUtils.tail((Object[])nestedFieldsPaths[i].parts()))._2).dataType();
                nestedFieldValues[i] = BuiltinKeyGenerator.convertToLogicalDataType(dataType, rawValue);
            }
            return nestedFieldValues;
        }

        private HoodieUnsafeRowUtils.NestedFieldPath[] resolveNestedFieldPaths(List<String> fieldPaths, StructType schema, boolean returnNull) {
            try {
                return (HoodieUnsafeRowUtils.NestedFieldPath[])fieldPaths.stream().map(fieldPath -> (HoodieUnsafeRowUtils.NestedFieldPath)HoodieUnsafeRowUtils$.MODULE$.composeNestedFieldPath(schema, (String)fieldPath).get()).toArray(HoodieUnsafeRowUtils.NestedFieldPath[]::new);
            }
            catch (Exception e) {
                if (returnNull) {
                    return null;
                }
                LOG.error(String.format("Failed to resolve nested field-paths (%s) in schema (%s)", fieldPaths, schema), (Throwable)e);
                throw new HoodieException("Failed to resolve nested field-paths", (Throwable)e);
            }
        }
    }

    protected static class SparkRowConverter {
        private static final String STRUCT_NAME = "hoodieRowTopLevelField";
        private static final String NAMESPACE = "hoodieRow";
        private final Function1<Row, GenericRecord> avroConverter;
        private final SparkRowSerDe rowSerDe;

        SparkRowConverter(StructType schema) {
            this.rowSerDe = HoodieSparkUtils.getCatalystRowSerDe(schema);
            this.avroConverter = AvroConversionUtils.createConverterToAvro(schema, STRUCT_NAME, NAMESPACE);
        }

        GenericRecord convertToAvro(Row row) {
            return (GenericRecord)this.avroConverter.apply((Object)row);
        }

        GenericRecord convertToAvro(InternalRow row) {
            return (GenericRecord)this.avroConverter.apply((Object)this.rowSerDe.deserializeRow(row));
        }
    }
}

