/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;

public class SparkBulkInsertCommitActionExecutor<T>
extends BaseSparkCommitActionExecutor<T> {
    private final HoodieData<HoodieRecord<T>> inputRecordsRDD;
    private final Option<BulkInsertPartitioner> bulkInsertPartitioner;

    public SparkBulkInsertCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieData<HoodieRecord<T>> inputRecordsRDD, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        this(context, config, table, instantTime, inputRecordsRDD, bulkInsertPartitioner, (Option<Map<String, String>>)Option.empty());
    }

    public SparkBulkInsertCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieData<HoodieRecord<T>> inputRecordsRDD, Option<BulkInsertPartitioner> bulkInsertPartitioner, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime, WriteOperationType.BULK_INSERT, extraMetadata);
        this.inputRecordsRDD = inputRecordsRDD;
        this.bulkInsertPartitioner = bulkInsertPartitioner;
    }

    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute() {
        try {
            return SparkBulkInsertHelper.newInstance().bulkInsert(this.inputRecordsRDD, this.instantTime, this.table, this.config, this, true, this.bulkInsertPartitioner);
        }
        catch (HoodieInsertException ie) {
            throw ie;
        }
        catch (Throwable e) {
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

