/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;

public class SparkBulkInsertPreppedCommitActionExecutor<T>
extends BaseSparkCommitActionExecutor<T> {
    private final HoodieData<HoodieRecord<T>> preppedInputRecordRdd;
    private final Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner;

    public SparkBulkInsertPreppedCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieData<HoodieRecord<T>> preppedInputRecordRdd, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        super(context, config, table, instantTime, WriteOperationType.BULK_INSERT);
        this.preppedInputRecordRdd = preppedInputRecordRdd;
        this.userDefinedBulkInsertPartitioner = userDefinedBulkInsertPartitioner;
    }

    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute() {
        try {
            return SparkBulkInsertHelper.newInstance().bulkInsert(this.preppedInputRecordRdd, this.instantTime, this.table, this.config, this, false, this.userDefinedBulkInsertPartitioner);
        }
        catch (Throwable e) {
            if (e instanceof HoodieInsertException) {
                throw e;
            }
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

