/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.DeletePartitionUtils;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.exception.HoodieDeletePartitionException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.SparkInsertOverwriteCommitActionExecutor;

public class SparkDeletePartitionCommitActionExecutor<T>
extends SparkInsertOverwriteCommitActionExecutor<T> {
    private List<String> partitions;

    public SparkDeletePartitionCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<String> partitions) {
        super(context, config, table, instantTime, null, WriteOperationType.DELETE_PARTITION);
        this.partitions = partitions;
    }

    @Override
    public HoodieWriteMetadata<HoodieData<WriteStatus>> execute() {
        DeletePartitionUtils.checkForPendingTableServiceActions((HoodieTable)this.table, this.partitions);
        try {
            HoodieTimer timer = HoodieTimer.start();
            this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Gather all file ids from all deleting partitions.");
            Map partitionToReplaceFileIds = HoodieJavaPairRDD.getJavaPairRDD(this.context.parallelize(this.partitions).distinct().mapToPair((SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
            HoodieWriteMetadata result = new HoodieWriteMetadata();
            result.setPartitionToReplaceFileIds(partitionToReplaceFileIds);
            result.setIndexUpdateDuration(Duration.ofMillis(timer.endTimer()));
            result.setWriteStatuses((Object)this.context.emptyHoodieData());
            HoodieInstant dropPartitionsInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", this.instantTime);
            if (!this.table.getStorage().exists(new StoragePath(this.table.getMetaClient().getTimelinePath(), this.instantFileNameGenerator.getFileName(dropPartitionsInstant)))) {
                HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.DELETE_PARTITION.name()).setExtraMetadata((Map)this.extraMetadata.orElse(Collections.emptyMap())).build();
                this.table.getMetaClient().getActiveTimeline().saveToPendingReplaceCommit(dropPartitionsInstant, TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)requestedReplaceMetadata));
            }
            this.saveWorkloadProfileMetadataToInflight(new WorkloadProfile(Pair.of(new HashMap(), (Object)new WorkloadStat())), this.instantTime);
            this.commitOnAutoCommit(result);
            return result;
        }
        catch (Exception e) {
            throw new HoodieDeletePartitionException("Failed to drop partitions for commit time " + this.instantTime, (Throwable)e);
        }
    }
}

