/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.CompactionAdminClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.CompactionTestUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompactionAdminClient
extends HoodieClientTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactionAdminClient.class);
    private HoodieTableMetaClient metaClient;
    private CompactionAdminClient client;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        this.client = new CompactionAdminClient((HoodieEngineContext)this.context, this.basePath);
    }

    @AfterEach
    public void cleanUp() throws Exception {
        this.cleanupResources();
    }

    @Test
    public void testUnscheduleCompactionPlan() throws Exception {
        int numEntriesPerInstant = 10;
        CompactionTestUtils.setupAndValidateCompactionOperations((HoodieTableMetaClient)this.metaClient, (boolean)false, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant);
        this.validateUnSchedulePlan(this.client, "000", "001", numEntriesPerInstant);
        this.validateUnSchedulePlan(this.client, "002", "003", numEntriesPerInstant);
        this.validateUnSchedulePlan(this.client, "004", "005", numEntriesPerInstant);
        this.validateUnSchedulePlan(this.client, "006", "007", numEntriesPerInstant);
    }

    @Test
    public void testUnscheduleCompactionFileId() throws Exception {
        int numEntriesPerInstant = 10;
        CompactionTestUtils.setupAndValidateCompactionOperations((HoodieTableMetaClient)this.metaClient, (boolean)false, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant);
        Map<String, CompactionOperation> instantsWithOp = Stream.of("001", "003", "005", "007").map(instant -> {
            try {
                return Pair.of((Object)instant, (Object)CompactionUtils.getCompactionPlan((HoodieTableMetaClient)this.metaClient, (String)instant));
            }
            catch (Exception ioe) {
                throw new HoodieException((Throwable)ioe);
            }
        }).map(instantWithPlan -> ((HoodieCompactionPlan)instantWithPlan.getRight()).getOperations().stream().map(op -> Pair.of((Object)instantWithPlan.getLeft(), (Object)CompactionOperation.convertFromAvroRecordInstance((HoodieCompactionOperation)op))).findFirst().get()).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.validateUnScheduleFileId(this.client, "000", "001", instantsWithOp.get("001"));
        this.validateUnScheduleFileId(this.client, "002", "003", instantsWithOp.get("003"));
        this.validateUnScheduleFileId(this.client, "004", "005", instantsWithOp.get("005"));
        this.validateUnScheduleFileId(this.client, "006", "007", instantsWithOp.get("007"));
    }

    @Test
    public void testRepairCompactionPlan() throws Exception {
        int numEntriesPerInstant = 10;
        CompactionTestUtils.setupAndValidateCompactionOperations((HoodieTableMetaClient)this.metaClient, (boolean)false, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant, (int)numEntriesPerInstant);
        this.validateRepair("000", "001", numEntriesPerInstant);
        this.validateRepair("002", "003", numEntriesPerInstant);
        this.validateRepair("004", "005", numEntriesPerInstant);
        this.validateRepair("006", "007", numEntriesPerInstant);
    }

    private void validateRepair(String ingestionInstant, String compactionInstant, int numEntriesPerInstant) throws Exception {
        List<Pair<HoodieLogFile, HoodieLogFile>> renameFiles = this.validateUnSchedulePlan(this.client, ingestionInstant, compactionInstant, numEntriesPerInstant);
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
        Assertions.assertFalse((boolean)this.metaClient.getCommitsAndCompactionTimeline().containsInstant(compactionInstant), (String)"Compaction should be unscheduled");
        Assertions.assertTrue((boolean)renameFiles.isEmpty(), (String)"Rename Files must be empty");
    }

    private void ensureValidCompactionPlan(String compactionInstant) throws Exception {
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
        List validationResults = this.client.validateCompactionPlan(this.metaClient, compactionInstant, 1);
        Assertions.assertFalse((boolean)validationResults.stream().anyMatch(v -> !v.isSuccess()), (String)"Some validations failed");
    }

    private void validateRenameFiles(List<Pair<HoodieLogFile, HoodieLogFile>> renameFiles, String ingestionInstant, String compactionInstant, HoodieTableFileSystemView fsView) {
        HashSet uniqNewLogFiles = new HashSet();
        HashSet uniqOldLogFiles = new HashSet();
        renameFiles.forEach(lfPair -> {
            Assertions.assertFalse((boolean)uniqOldLogFiles.contains(lfPair.getKey()), (String)"Old Log File Names do not collide");
            Assertions.assertFalse((boolean)uniqNewLogFiles.contains(lfPair.getValue()), (String)"New Log File Names do not collide");
            uniqOldLogFiles.add(lfPair.getKey());
            uniqNewLogFiles.add(lfPair.getValue());
        });
        renameFiles.forEach(lfPair -> {
            HoodieLogFile oldLogFile = (HoodieLogFile)lfPair.getLeft();
            HoodieLogFile newLogFile = (HoodieLogFile)lfPair.getValue();
            Assertions.assertEquals((Object)ingestionInstant, (Object)newLogFile.getDeltaCommitTime(), (String)"Base Commit time of ingestion instant is expected");
            Assertions.assertEquals((Object)compactionInstant, (Object)oldLogFile.getDeltaCommitTime(), (String)"Base Commit time of compaction instant is expected");
            Assertions.assertEquals((Object)oldLogFile.getFileId(), (Object)newLogFile.getFileId(), (String)"File Id is expected");
            HoodieLogFile lastLogFileBeforeCompaction = fsView.getLatestMergedFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], ingestionInstant).filter(fs -> fs.getFileId().equals(oldLogFile.getFileId())).map(fs -> (HoodieLogFile)fs.getLogFiles().findFirst().get()).findFirst().get();
            Assertions.assertEquals((int)(lastLogFileBeforeCompaction.getLogVersion() + oldLogFile.getLogVersion()), (int)newLogFile.getLogVersion(), (String)"Log Version expected");
            Assertions.assertTrue((newLogFile.getLogVersion() > lastLogFileBeforeCompaction.getLogVersion() ? 1 : 0) != 0, (String)"Log version does not collide");
        });
    }

    private List<Pair<HoodieLogFile, HoodieLogFile>> validateUnSchedulePlan(CompactionAdminClient client, String ingestionInstant, String compactionInstant, int numEntriesPerInstant) throws Exception {
        this.ensureValidCompactionPlan(compactionInstant);
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getCommitsAndCompactionTimeline());
        Map<String, Long> fileIdToCountsBeforeRenaming = fsView.getLatestMergedFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], compactionInstant).filter(fs -> fs.getBaseInstantTime().equals(ingestionInstant)).map(fs -> Pair.of((Object)fs.getFileId(), (Object)fs.getLogFiles().count())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        client.unscheduleCompactionPlan(compactionInstant, false, 1, false);
        this.metaClient.reloadActiveTimeline();
        HoodieTableFileSystemView newFsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getCommitsAndCompactionTimeline());
        Set commitsWithDataFile = CollectionUtils.createSet((Object[])new String[]{"000", "004"});
        newFsView.getLatestFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], compactionInstant, true).filter(fs -> fs.getBaseInstantTime().compareTo(compactionInstant) <= 0).forEach(fs -> {
            if (commitsWithDataFile.contains(fs.getBaseInstantTime())) {
                Assertions.assertTrue((boolean)fs.getBaseFile().isPresent(), (String)"Data file must be present");
            } else {
                Assertions.assertFalse((boolean)fs.getBaseFile().isPresent(), (String)"No Data file should be present");
            }
            Assertions.assertEquals((long)2L, (long)fs.getLogFiles().count(), (String)"Has Log Files");
        });
        Map<String, Long> fileIdToCountsAfterRenaming = newFsView.getLatestMergedFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], ingestionInstant).filter(fs -> fs.getBaseInstantTime().equals(ingestionInstant)).map(fs -> Pair.of((Object)fs.getFileId(), (Object)fs.getLogFiles().count())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Assertions.assertEquals(fileIdToCountsBeforeRenaming, fileIdToCountsAfterRenaming, (String)"Each File Id has same number of log-files");
        Assertions.assertEquals((int)numEntriesPerInstant, (int)fileIdToCountsAfterRenaming.size(), (String)"Not Empty");
        return new ArrayList<Pair<HoodieLogFile, HoodieLogFile>>();
    }

    private void validateUnScheduleFileId(CompactionAdminClient client, String ingestionInstant, String compactionInstant, CompactionOperation op) throws Exception {
        this.ensureValidCompactionPlan(compactionInstant);
        this.metaClient.reloadActiveTimeline();
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getCommitsAndCompactionTimeline());
        Map<String, Long> fileIdToCountsBeforeRenaming = fsView.getLatestMergedFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], compactionInstant).filter(fs -> fs.getBaseInstantTime().equals(ingestionInstant)).filter(fs -> fs.getFileId().equals(op.getFileId())).map(fs -> Pair.of((Object)fs.getFileId(), (Object)fs.getLogFiles().count())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        client.unscheduleCompactionFileId(op.getFileGroupId(), false, false);
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)this.basePath);
        HoodieTableFileSystemView newFsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getCommitsAndCompactionTimeline());
        newFsView.getLatestFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], compactionInstant, true).filter(fs -> fs.getBaseInstantTime().equals(compactionInstant)).filter(fs -> fs.getFileId().equals(op.getFileId())).forEach(fs -> {
            Assertions.assertFalse((boolean)fs.getBaseFile().isPresent(), (String)"No Data file must be present");
            Assertions.assertEquals((long)0L, (long)fs.getLogFiles().count(), (String)"No Log Files");
        });
        Map<String, Long> fileIdToCountsAfterRenaming = newFsView.getLatestMergedFileSlicesBeforeOrOn(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], ingestionInstant).filter(fs -> fs.getBaseInstantTime().equals(ingestionInstant)).filter(fs -> fs.getFileId().equals(op.getFileId())).map(fs -> Pair.of((Object)fs.getFileId(), (Object)fs.getLogFiles().count())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Assertions.assertEquals(fileIdToCountsBeforeRenaming, fileIdToCountsAfterRenaming, (String)"Each File Id has same number of log-files");
        Assertions.assertEquals((int)1, (int)fileIdToCountsAfterRenaming.size(), (String)"Not Empty");
    }
}

