/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.HoodieSparkIndexClient;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Test;

public class TestHoodieSparkIndex
extends HoodieClientTestBase {
    @Test
    public void testIndexCreateAndDrop() throws IOException {
        HoodieWriteConfig cfg = this.getConfigBuilder().build();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(6059L);
        this.initMetaClient(HoodieTableType.COPY_ON_WRITE);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String commitTime1 = "001";
            client.startCommitWithTime(commitTime1);
            List records1 = dataGen.generateInserts(commitTime1, Integer.valueOf(200));
            JavaRDD writeRecords1 = this.jsc.parallelize(records1, 1);
            List statuses1 = client.upsert(writeRecords1, commitTime1).collect();
            Assertions.assertNoWriteErrors((List)statuses1);
        }
        HoodieSparkIndexClient sparkIndexClient = new HoodieSparkIndexClient(cfg, (HoodieEngineContext)this.context);
        String indexNamePrefix = "index";
        String fieldNamePrefix = "field";
        for (int i = 0; i < 5; ++i) {
            String indexName = indexNamePrefix + "_" + i;
            String fieldName = fieldNamePrefix + "_" + i;
            HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexName, i % 2 == 0 ? "secondary_index" : "expr_index", fieldName);
            HoodieIndexUtils.register((HoodieTableMetaClient)this.metaClient, (HoodieIndexDefinition)indexDefinition);
            this.readAndValidateIndexDefn(indexDefinition);
        }
        HoodieIndexDefinition colStatsIndexDefinition = this.getIndexDefinition("column_stats", "column_stats", fieldNamePrefix + "_5");
        HoodieIndexUtils.register((HoodieTableMetaClient)this.metaClient, (HoodieIndexDefinition)colStatsIndexDefinition);
        this.readAndValidateIndexDefn(colStatsIndexDefinition);
        this.metaClient.deleteIndexDefinition(this.getIndexFullName(indexNamePrefix + "_1", "expr_index"));
        this.metaClient.deleteIndexDefinition(this.getIndexFullName(indexNamePrefix + "_2", "secondary_index"));
        HoodieTableMetaClient newMetaClient = HoodieTableMetaClient.builder().setBasePath(this.metaClient.getBasePath()).setConf(this.metaClient.getStorageConf()).build();
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexNamePrefix + "_0", "secondary_index", fieldNamePrefix + "_0");
        this.readAndValidateIndexDefn(indexDefinition, newMetaClient);
        indexDefinition = this.getIndexDefinition(indexNamePrefix + "_3", "expr_index", fieldNamePrefix + "_3");
        this.readAndValidateIndexDefn(indexDefinition, newMetaClient);
        indexDefinition = this.getIndexDefinition(indexNamePrefix + "_4", "secondary_index", fieldNamePrefix + "_4");
        this.readAndValidateIndexDefn(indexDefinition, newMetaClient);
        this.readAndValidateIndexDefn(colStatsIndexDefinition);
        List<String> colsToIndex = IntStream.range(0, 10).mapToObj(number -> fieldNamePrefix + "_" + number).collect(Collectors.toList());
        colStatsIndexDefinition = this.getIndexDefinition("column_stats", "column_stats", "column_stats", colsToIndex, Collections.EMPTY_MAP);
        HoodieIndexUtils.register((HoodieTableMetaClient)this.metaClient, (HoodieIndexDefinition)colStatsIndexDefinition);
        this.readAndValidateIndexDefn(colStatsIndexDefinition);
        this.metaClient.deleteIndexDefinition(colStatsIndexDefinition.getIndexName());
        this.readAndValidateIndexDefnNotPresent(colStatsIndexDefinition, HoodieTableMetaClient.builder().setBasePath(this.metaClient.getBasePath()).setConf(this.metaClient.getStorageConf()).build());
    }

    private void readAndValidateIndexDefn(HoodieIndexDefinition expectedIndexDefn) {
        HoodieTableMetaClient newMetaClient = HoodieTableMetaClient.builder().setBasePath(this.metaClient.getBasePath()).setConf(this.metaClient.getStorageConf()).build();
        this.readAndValidateIndexDefn(expectedIndexDefn, newMetaClient);
    }

    private void readAndValidateIndexDefn(HoodieIndexDefinition expectedIndexDefn, HoodieTableMetaClient metaClient) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((!((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().isEmpty() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().containsKey(expectedIndexDefn.getIndexName()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedIndexDefn, ((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().get(expectedIndexDefn.getIndexName()));
    }

    private void readAndValidateIndexDefnNotPresent(HoodieIndexDefinition expectedIndexDefn, HoodieTableMetaClient metaClient) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((!((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().isEmpty() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((!((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().containsKey(expectedIndexDefn.getIndexName()) ? 1 : 0) != 0);
    }

    private HoodieIndexDefinition getIndexDefinition(String indexName, String indexType, String sourceField) {
        return this.getIndexDefinition(indexName, indexType, "identity", Collections.singletonList(sourceField), Collections.emptyMap());
    }

    private HoodieIndexDefinition getIndexDefinition(String indexName, String indexType, String indexFunc, List<String> sourceFields, Map<String, String> indexOptions) {
        String fullIndexName = this.getIndexFullName(indexName, indexType);
        return HoodieIndexDefinition.newBuilder().withIndexName(fullIndexName).withIndexType(indexType).withIndexFunction(indexFunc).withSourceFields(sourceFields).withIndexOptions(indexOptions).build();
    }

    private String getIndexFullName(String indexName, String indexType) {
        if (indexName.equals("column_stats")) {
            return "column_stats";
        }
        return indexType.equals("secondary_index") ? "secondary_index_" + indexName : "expr_index_" + indexName;
    }
}

