/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSavepoint
extends HoodieClientTestBase {
    private static Stream<Arguments> testSavepointParams() {
        return Arrays.stream(new Object[][]{{true, FileSystemViewStorageType.MEMORY, HoodieTableType.COPY_ON_WRITE}, {true, FileSystemViewStorageType.EMBEDDED_KV_STORE, HoodieTableType.COPY_ON_WRITE}, {false, FileSystemViewStorageType.MEMORY, HoodieTableType.COPY_ON_WRITE}, {false, FileSystemViewStorageType.EMBEDDED_KV_STORE, HoodieTableType.COPY_ON_WRITE}, {true, FileSystemViewStorageType.MEMORY, HoodieTableType.MERGE_ON_READ}, {true, FileSystemViewStorageType.EMBEDDED_KV_STORE, HoodieTableType.MERGE_ON_READ}, {false, FileSystemViewStorageType.MEMORY, HoodieTableType.MERGE_ON_READ}, {false, FileSystemViewStorageType.EMBEDDED_KV_STORE, HoodieTableType.MERGE_ON_READ}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"testSavepointParams"})
    public void testSavepoint(boolean enableMetadataTable, FileSystemViewStorageType storageType, HoodieTableType tableType) throws IOException {
        HoodieWriteConfig cfg = this.getWriteConfig(enableMetadataTable, storageType);
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(6059L);
        this.initMetaClient(tableType);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String commitTime1 = "001";
            client.startCommitWithTime(commitTime1);
            List records1 = dataGen.generateInserts(commitTime1, Integer.valueOf(200));
            JavaRDD writeRecords1 = this.jsc.parallelize(records1, 1);
            List statuses1 = client.upsert(writeRecords1, commitTime1).collect();
            Assertions.assertNoWriteErrors((List)statuses1);
            String commitTime2 = "002";
            client.startCommitWithTime(commitTime2);
            List records2 = dataGen.generateInserts(commitTime2, Integer.valueOf(200));
            JavaRDD writeRecords2 = this.jsc.parallelize(records2, 1);
            List statuses2 = client.upsert(writeRecords2, commitTime2).collect();
            Assertions.assertNoWriteErrors((List)statuses2);
            client.savepoint("user", "hoodie-savepoint-unit-test");
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            HoodieTimeline savepointTimeline = table.getActiveTimeline().getSavePointTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)savepointTimeline.countInstants());
            Map savepointPartitionMetadataMap = TimelineMetadataUtils.deserializeHoodieSavepointMetadata((byte[])((byte[])savepointTimeline.getInstantDetails((HoodieInstant)savepointTimeline.firstInstant().get()).get())).getPartitionMetadata();
            HoodieTimeline commitsTimeline = table.getActiveTimeline().getCommitsTimeline();
            Map partitionToWriteStats = ((HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize((HoodieInstant)commitsTimeline.lastInstant().get(), (byte[])commitsTimeline.getInstantDetails((HoodieInstant)commitsTimeline.lastInstant().get()).get(), HoodieCommitMetadata.class)).getPartitionToWriteStats();
            org.junit.jupiter.api.Assertions.assertEquals((int)partitionToWriteStats.size(), (int)savepointPartitionMetadataMap.size());
            for (Map.Entry entry : partitionToWriteStats.entrySet()) {
                String partition = (String)entry.getKey();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)savepointPartitionMetadataMap.containsKey(partition));
                org.junit.jupiter.api.Assertions.assertEquals(((List)entry.getValue()).stream().map(path -> this.getFileNameFromPath(path.getPath())).sorted().collect(Collectors.toList()), ((HoodieSavepointPartitionMetadata)savepointPartitionMetadataMap.get(partition)).getSavepointDataFile().stream().sorted().collect(Collectors.toList()));
            }
        }
    }

    private HoodieWriteConfig getWriteConfig(boolean enableMetadataTable, FileSystemViewStorageType storageType) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).forTable("raw_trips").withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withEnableBackupForRemoteFileSystemView(false).withRemoteServerPort(Integer.valueOf(timelineServicePort)).withStorageType(storageType).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
    }

    private String getFileNameFromPath(String path) {
        String[] parts = path.split("/");
        return parts[parts.length - 1];
    }
}

