/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.curator.test.TestingServer;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.marker.SimpleTransactionDirectMarkerBasedDetectionStrategy;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSimpleTransactionDirectMarkerBasedDetectionStrategyWithZKLockProvider
extends HoodieClientTestBase {
    private HoodieWriteConfig config;
    private TestingServer server;

    private void setUp(boolean partitioned) throws Exception {
        this.initPath();
        if (partitioned) {
            this.initTestDataGenerator();
        } else {
            this.initTestDataGenerator(new String[]{""});
        }
        this.initHoodieStorage();
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        Properties properties = TestSimpleTransactionDirectMarkerBasedDetectionStrategyWithZKLockProvider.getPropertiesForKeyGen();
        properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        this.server = new TestingServer();
        properties.setProperty("hoodie.write.lock.zookeeper.base_path", this.basePath);
        properties.setProperty("hoodie.write.lock.zookeeper.url", this.server.getConnectString());
        properties.setProperty("hoodie.write.lock.zookeeper.base_path", this.server.getTempDirectory().getAbsolutePath());
        properties.setProperty("hoodie.write.lock.zookeeper.lock_key", "key");
        this.config = this.getConfigBuilder().withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.MEMORY).withSecondaryStorageType(FileSystemViewStorageType.MEMORY).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(false)).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.SIMPLE).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().withAutoArchive(Boolean.valueOf(false)).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withMarkersType(MarkerType.DIRECT.name()).withEarlyConflictDetectionEnable(true).withEarlyConflictDetectionStrategy(SimpleTransactionDirectMarkerBasedDetectionStrategy.class.getName()).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(ZookeeperBasedLockProvider.class).build()).withAutoCommit(false).withProperties(properties).build();
    }

    @AfterEach
    public void clean() throws IOException {
        this.cleanupResources();
        FileIOUtils.deleteDirectory((File)new File(this.basePath));
        if (this.server != null) {
            this.server.close();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSimpleTransactionDirectMarkerBasedDetectionStrategy(boolean partitioned) throws Exception {
        this.setUp(partitioned);
        String nextCommitTime1 = "00000000000001";
        SparkRDDWriteClient client1 = this.getHoodieWriteClient(this.config);
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction1 = this.generateWrapRecordsFn(false, this.config, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)));
        List records1 = (List)recordGenFunction1.apply((Object)"00000000000001", (Object)200);
        JavaRDD writeRecords1 = this.jsc.parallelize(records1, 1);
        client1.startCommitWithTime("00000000000001");
        JavaRDD writeStatusList1 = client1.insert(writeRecords1, "00000000000001");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)client1.commit("00000000000001", (Object)writeStatusList1), (String)"Commit should succeed");
        SparkRDDWriteClient client2 = this.getHoodieWriteClient(this.config);
        SparkRDDWriteClient client3 = this.getHoodieWriteClient(this.config);
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction2 = this.generateWrapRecordsFn(false, this.config, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateUniqueUpdates(arg_0, arg_1)));
        String nextCommitTime2 = "00000000000002";
        List records2 = (List)recordGenFunction2.apply((Object)"00000000000002", (Object)200);
        JavaRDD writeRecords2 = this.jsc.parallelize(records2, 1);
        client2.startCommitWithTime("00000000000002");
        JavaRDD writeStatusList2 = client2.upsert(writeRecords2, "00000000000002");
        Assertions.assertNoWriteErrors((List)writeStatusList2.collect());
        String nextCommitTime3 = "00000000000003";
        org.junit.jupiter.api.Assertions.assertThrows(SparkException.class, () -> {
            List records3 = (List)recordGenFunction2.apply((Object)"00000000000003", (Object)200);
            JavaRDD writeRecords3 = this.jsc.parallelize(records3, 1);
            client3.startCommitWithTime("00000000000003");
            JavaRDD writeStatusList3 = client3.upsert(writeRecords3, "00000000000003");
            client3.commit("00000000000003", (Object)writeStatusList3);
        }, (String)"Early conflict detected but cannot resolve conflicts for overlapping writes");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> client2.commit("00000000000002", (Object)writeStatusList2));
    }
}

