/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.selector.UniformBootstrapModeSelector;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUniformBootstrapModeSelector {
    @Test
    public void testFullBootstrapModeSelector() {
        FullRecordBootstrapModeSelector modeSelector = new FullRecordBootstrapModeSelector(HoodieWriteConfig.newBuilder().withPath("").build());
        this.testModeSelector((UniformBootstrapModeSelector)modeSelector, BootstrapMode.FULL_RECORD);
    }

    @Test
    public void testMetadataOnlyBootstrapModeSelector() {
        MetadataOnlyBootstrapModeSelector modeSelector = new MetadataOnlyBootstrapModeSelector(HoodieWriteConfig.newBuilder().withPath("").build());
        this.testModeSelector((UniformBootstrapModeSelector)modeSelector, BootstrapMode.METADATA_ONLY);
    }

    private void testModeSelector(UniformBootstrapModeSelector modeSelector, BootstrapMode mode) {
        List<String> partitionPaths = Arrays.asList("2020/05/01", "2020/05/02", "2020/05/10", "2020/05/11");
        List input = partitionPaths.stream().map(p -> Pair.of((Object)p, new ArrayList())).collect(Collectors.toList());
        Map result = modeSelector.select(input);
        Assertions.assertTrue((boolean)((List)result.get(mode)).contains("2020/05/01"));
        Assertions.assertTrue((boolean)((List)result.get(mode)).contains("2020/05/02"));
        Assertions.assertTrue((boolean)((List)result.get(mode)).contains("2020/05/10"));
        Assertions.assertTrue((boolean)((List)result.get(mode)).contains("2020/05/11"));
        Assertions.assertEquals((int)4, (int)((List)result.get(mode)).size());
    }
}

