/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class TestSparkSizeBasedClusteringPlanStrategy {
    @Mock
    HoodieSparkCopyOnWriteTable table;
    @Mock
    HoodieSparkEngineContext context;

    @Test
    public void testBuildClusteringGroup() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("").withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanStrategyClass(SparkSizeBasedClusteringPlanStrategy.class.getName()).withClusteringMaxBytesInGroup(2000L).withClusteringTargetFileMaxBytes(1000L).withClusteringPlanSmallFileLimit(500L).build()).build();
        SparkSizeBasedClusteringPlanStrategy planStrategy = new SparkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, config);
        ArrayList<FileSlice> fileSlices = new ArrayList<FileSlice>();
        fileSlices.add(this.createFileSlice(200L));
        fileSlices.add(this.createFileSlice(200L));
        fileSlices.add(this.createFileSlice(300L));
        fileSlices.add(this.createFileSlice(300L));
        fileSlices.add(this.createFileSlice(400L));
        fileSlices.add(this.createFileSlice(400L));
        fileSlices.add(this.createFileSlice(400L));
        fileSlices.add(this.createFileSlice(400L));
        Stream clusteringGroupStream = (Stream)planStrategy.buildClusteringGroupsForPartition("p0", fileSlices).getLeft();
        List clusteringGroups = clusteringGroupStream.collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)clusteringGroups.size());
        Assertions.assertEquals((int)5, (int)((HoodieClusteringGroup)clusteringGroups.get(0)).getSlices().size());
        Assertions.assertEquals((int)2, (Integer)((HoodieClusteringGroup)clusteringGroups.get(0)).getNumOutputFileGroups());
        Assertions.assertEquals((int)3, (int)((HoodieClusteringGroup)clusteringGroups.get(1)).getSlices().size());
        Assertions.assertEquals((int)1, (Integer)((HoodieClusteringGroup)clusteringGroups.get(1)).getNumOutputFileGroups());
    }

    private FileSlice createFileSlice(long baseFileSize) {
        String fileId = FSUtils.createNewFileId((String)FSUtils.createNewFileIdPfx(), (int)0);
        FileSlice fs = new FileSlice("p0", "001", fileId);
        HoodieBaseFile f = new HoodieBaseFile(fileId);
        f.setFileLen(baseFileSize);
        fs.setBaseFile(f);
        return fs;
    }
}

