/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.util.Arrays;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestHoodieSparkEngineContext
extends SparkClientFunctionalTestHarness {
    private HoodieSparkEngineContext context;

    TestHoodieSparkEngineContext() {
    }

    @BeforeEach
    void setUp() {
        this.context = new HoodieSparkEngineContext(this.jsc());
    }

    @Test
    void testAddRemoveCachedDataIds() {
        String basePath = "/tmp/foo";
        String instantTime = "000";
        this.context.putCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime), new int[]{1, 2, 3});
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)this.context.getCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)));
        Assertions.assertEquals(Arrays.asList(1, 2, 3), (Object)this.context.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)));
        Assertions.assertTrue((boolean)this.context.getCachedDataIds(HoodieData.HoodieDataCacheKey.of((String)basePath, (String)instantTime)).isEmpty());
    }

    @Test
    void testSetJobStatus() {
        String jobGroupId = "jobGroupId";
        String initialJobDescription = "initialJobDescription";
        String activeModule = "TestModule";
        String activityDescription = "Running test operation";
        String expectedJobDescription = String.format("%s:%s", activeModule, activityDescription);
        this.context.getJavaSparkContext().setJobGroup(jobGroupId, initialJobDescription);
        Assertions.assertEquals((Object)jobGroupId, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.jobGroup.id"));
        Assertions.assertEquals((Object)initialJobDescription, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.job.description"));
        this.context.setJobStatus(activeModule, activityDescription);
        Assertions.assertEquals((Object)expectedJobDescription, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.job.description"));
        Assertions.assertEquals((Object)jobGroupId, (Object)this.context.getJavaSparkContext().getLocalProperty("spark.jobGroup.id"));
    }
}

