/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieSparkIOFactory;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieBackedTableMetadata
extends TestHoodieMetadataBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieBackedTableMetadata.class);

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTableOperations(boolean reuseReaders) throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType);
        this.doWriteInsertAndUpsert(testTable);
        this.doWriteOperation(testTable, "0000003");
        this.verifyBaseMetadataTable(reuseReaders);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiReaderForHoodieBackedTableMetadata(boolean reuse) throws Exception {
        int taskNumber = 3;
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType);
        testTable.doWriteOperation("000001", WriteOperationType.INSERT, Collections.emptyList(), Arrays.asList("p1"), 1);
        final HoodieBackedTableMetadata tableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.storage, this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), reuse);
        Assertions.assertTrue((boolean)tableMetadata.enabled());
        List metadataPartitions = tableMetadata.getAllPartitionPaths();
        String partition = (String)metadataPartitions.get(0);
        final String finalPartition = this.basePath + "/" + partition;
        ExecutorService executors = Executors.newFixedThreadPool(3);
        final AtomicBoolean flag = new AtomicBoolean(false);
        final CountDownLatch downLatch = new CountDownLatch(3);
        final AtomicInteger filesNumber = new AtomicInteger(0);
        for (int i = 0; i < 3; ++i) {
            executors.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        downLatch.countDown();
                        downLatch.await();
                        List files = tableMetadata.getAllFilesInPartition(new StoragePath(finalPartition));
                        if (files.size() != 1) {
                            LOG.warn("Miss match data file numbers.");
                            throw new RuntimeException("Miss match data file numbers.");
                        }
                        filesNumber.addAndGet(files.size());
                    }
                    catch (Exception e) {
                        LOG.warn("Catch Exception while reading data files from MDT.", (Throwable)e);
                        flag.compareAndSet(false, true);
                    }
                }
            });
        }
        executors.shutdown();
        executors.awaitTermination(5L, TimeUnit.MINUTES);
        Assertions.assertFalse((boolean)flag.get());
        Assertions.assertEquals((int)filesNumber.get(), (int)3);
    }

    private void doWriteInsertAndUpsert(HoodieTestTable testTable) throws Exception {
        this.doWriteInsertAndUpsert(testTable, "0000001", "0000002", false);
    }

    private void verifyBaseMetadataTable(boolean reuseMetadataReaders) throws IOException {
        HoodieBackedTableMetadata tableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.storage, this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), reuseMetadataReaders);
        Assertions.assertTrue((boolean)tableMetadata.enabled());
        List fsPartitionPaths = testTable.getAllPartitionPaths();
        ArrayList fsPartitions = new ArrayList();
        fsPartitionPaths.forEach(entry -> fsPartitions.add(entry.getFileName().toString()));
        List metadataPartitions = tableMetadata.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        Assertions.assertEquals((int)fsPartitions.size(), (int)metadataPartitions.size(), (String)"Partitions should match");
        Assertions.assertEquals(fsPartitions, (Object)metadataPartitions, (String)"Partitions should match");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.writeConfig, (HoodieEngineContext)this.context);
        SyncableFileSystemView tableView = table.getHoodieView();
        List fullPartitionPaths = fsPartitions.stream().map(partition -> this.basePath + "/" + partition).collect(Collectors.toList());
        Map partitionToFilesMap = tableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        Assertions.assertEquals((int)fsPartitions.size(), (int)partitionToFilesMap.size());
        fsPartitions.forEach(arg_0 -> this.lambda$verifyBaseMetadataTable$2(tableMetadata, (TableFileSystemView)tableView, partitionToFilesMap, arg_0));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataTableKeyGenerator(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        HoodieBackedTableMetadata tableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.storage, this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), false);
        Assertions.assertEquals((Object)HoodieTableMetadataKeyGenerator.class.getCanonicalName(), (Object)tableMetadata.getMetadataMetaClient().getTableConfig().getKeyGeneratorClassName());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testNotExistPartition(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        HoodieBackedTableMetadata tableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.storage, this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), false);
        List allFilesInPartition = tableMetadata.getAllFilesInPartition(new StoragePath(this.writeConfig.getBasePath() + "dummy"));
        Assertions.assertEquals((int)allFilesInPartition.size(), (int)0);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataRecordKeyExcludeFromPayload(HoodieTableType tableType) throws Exception {
        this.initPath();
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(3).build()).build();
        this.init(tableType, this.writeConfig);
        this.doWriteOperation(testTable, "0000001", WriteOperationType.INSERT);
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        HoodieWriteConfig metadataTableWriteConfig = this.getMetadataWriteConfig(this.writeConfig);
        metadataMetaClient.reloadActiveTimeline();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)metadataTableWriteConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metadataMetaClient);
        Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$3((HoodieTable)table, metadataMetaClient), (String)"Metadata table should have valid log files!");
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles((HoodieTable)table);
        this.doWriteOperation(testTable, "0000002", WriteOperationType.UPSERT);
        this.doWriteOperation(testTable, "0000004", WriteOperationType.UPSERT);
        Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$4((HoodieTable)table, metadataMetaClient), (String)"Metadata table should have valid log files!");
        Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$5((HoodieTable)table), (String)"Metadata table should have a valid base file!");
        this.doWriteOperation(testTable, "0000005", WriteOperationType.UPSERT);
        this.doClean(testTable, "0000006", Arrays.asList("0000004"));
        this.doWriteOperation(testTable, "0000007", WriteOperationType.UPSERT);
        Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$6((HoodieTable)table, metadataMetaClient), (String)"Metadata table should have valid log files!");
        Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$7((HoodieTable)table), (String)"Metadata table should have a valid base file!");
        this.validateMetadata(testTable);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRepeatedCleanActionsWithMetadataTableEnabled(HoodieTableType tableType) throws Exception {
        this.initPath();
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(4).build()).build();
        this.init(tableType, this.writeConfig);
        String partition = "p1";
        String instant1 = this.metaClient.createNewInstantTime();
        HoodieCommitMetadata commitMetadata1 = testTable.doWriteOperation(instant1, WriteOperationType.BULK_INSERT, Collections.emptyList(), Arrays.asList(partition), 1);
        String instant2 = this.metaClient.createNewInstantTime();
        HoodieCommitMetadata commitMetadata2 = testTable.doWriteOperation(instant2, WriteOperationType.BULK_INSERT, Collections.emptyList(), Arrays.asList(partition), 1);
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        while (this.getNumCompactions(metadataMetaClient) == 0) {
            testTable.doWriteOperation(this.metaClient.createNewInstantTime(), WriteOperationType.BULK_INSERT, Collections.emptyList(), Arrays.asList(partition), 1);
            metadataMetaClient.reloadActiveTimeline();
        }
        Assertions.assertEquals((int)1, (int)this.getNumCompactions(metadataMetaClient));
        ArrayList fileIdsToReplace = new ArrayList();
        fileIdsToReplace.addAll(commitMetadata1.getFileIdAndRelativePaths().keySet());
        fileIdsToReplace.addAll(commitMetadata2.getFileIdAndRelativePaths().keySet());
        testTable.doCluster(this.metaClient.createNewInstantTime(), Collections.singletonMap(partition, fileIdsToReplace), Arrays.asList(partition), 1);
        Set<String> fileSetBeforeCleaning = this.getFilePathsInPartition(partition);
        String cleanInstant = this.metaClient.createNewInstantTime();
        HoodieCleanMetadata cleanMetadata = testTable.doCleanBasedOnCommits(cleanInstant, Arrays.asList(instant1, instant2));
        List deleteFileList = ((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get(partition)).getDeletePathPatterns();
        Assertions.assertTrue((deleteFileList.size() > 0 ? 1 : 0) != 0);
        Set<String> fileSetAfterFirstCleaning = this.getFilePathsInPartition(partition);
        this.validateFilesAfterCleaning(deleteFileList, fileSetBeforeCleaning, fileSetAfterFirstCleaning);
        this.metaClient.reloadActiveTimeline();
        HoodieCleanerPlan cleanerPlan = CleanerUtils.getCleanerPlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanInstant));
        testTable.repeatClean(this.metaClient.createNewInstantTime(), cleanerPlan, cleanMetadata);
        Assertions.assertEquals((int)1, (int)this.getNumCompactions(metadataMetaClient));
        Set<String> fileSetAfterSecondCleaning = this.getFilePathsInPartition(partition);
        this.validateFilesAfterCleaning(deleteFileList, fileSetBeforeCleaning, fileSetAfterSecondCleaning);
    }

    private int getNumCompactions(HoodieTableMetaClient metaClient) {
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
        return timeline.filter(s -> {
            try {
                return s.getAction().equals("commit") && ((HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize(s, (byte[])timeline.getInstantDetails(s).get(), HoodieCommitMetadata.class)).getOperationType().equals((Object)WriteOperationType.COMPACT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).countInstants();
    }

    private Set<String> getFilePathsInPartition(String partition) throws IOException {
        HoodieBackedTableMetadata tableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(this.storageConf), this.storage, HoodieMetadataConfig.newBuilder().enable(true).build(), this.basePath);
        return tableMetadata.getAllFilesInPartition(new StoragePath(this.basePath, partition)).stream().map(status -> status.getPath().getName()).collect(Collectors.toSet());
    }

    private void validateFilesAfterCleaning(List<String> deleteFileList, Set<String> fileSetBeforeCleaning, Set<String> fileSetAfterCleaning) {
        Assertions.assertEquals((int)deleteFileList.size(), (int)(fileSetBeforeCleaning.size() - fileSetAfterCleaning.size()));
        for (String deleteFile : deleteFileList) {
            Assertions.assertFalse((boolean)fileSetAfterCleaning.contains(deleteFile));
        }
        for (String file : fileSetAfterCleaning) {
            Assertions.assertTrue((boolean)fileSetBeforeCleaning.contains(file));
        }
    }

    private void verifyMetadataRecordKeyExcludeFromPayloadLogFiles(HoodieTable table, HoodieTableMetaClient metadataMetaClient, String latestCommitTimestamp) throws IOException {
        table.getHoodieView().sync();
        List fileSlices = table.getSliceView().getLatestFileSlices(MetadataPartitionType.FILES.getPartitionPath()).collect(Collectors.toList());
        if (fileSlices.isEmpty()) {
            throw new IllegalStateException("LogFile slices are not available!");
        }
        List<HoodieLogFile> logFiles = ((FileSlice)fileSlices.get(0)).getLogFiles().map(logFile -> logFile).collect(Collectors.toList());
        List<String> logFilePaths = logFiles.stream().map(logFile -> logFile.getPath().toString()).collect(Collectors.toList());
        this.verifyMetadataRawRecords(table, logFiles);
        this.verifyMetadataMergedRecords(metadataMetaClient, logFilePaths, latestCommitTimestamp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyMetadataRawRecords(HoodieTable table, List<HoodieLogFile> logFiles) throws IOException {
        Iterator<HoodieLogFile> iterator = logFiles.iterator();
        block17: while (iterator.hasNext()) {
            HoodieLogFile logFile = iterator.next();
            List pathInfoList = this.storage.listDirectEntries(logFile.getPath());
            Schema writerSchema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)this.storage, (StoragePath)logFile.getPath());
            if (writerSchema == null) continue;
            HoodieLogFormat.Reader logFileReader = HoodieLogFormat.newReader((HoodieStorage)this.storage, (HoodieLogFile)new HoodieLogFile(((StoragePathInfo)pathInfoList.get(0)).getPath()), (Schema)writerSchema);
            Throwable throwable = null;
            try {
                while (true) {
                    ClosableIterator recordItr;
                    block21: {
                        if (!logFileReader.hasNext()) continue block17;
                        HoodieLogBlock logBlock = (HoodieLogBlock)logFileReader.next();
                        if (!(logBlock instanceof HoodieDataBlock)) continue;
                        recordItr = ((HoodieDataBlock)logBlock).getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        Throwable throwable2 = null;
                        try {
                            recordItr.forEachRemaining(indexRecord -> {
                                GenericRecord record = (GenericRecord)indexRecord.getData();
                                Assertions.assertNull((Object)record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                                Assertions.assertNull((Object)record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                                String key = String.valueOf(record.get("key"));
                                Assertions.assertFalse((boolean)key.isEmpty());
                            });
                            if (recordItr == null) continue;
                            if (throwable2 == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (recordItr == null) throw throwable4;
                                if (throwable2 != null) {
                                    try {
                                        recordItr.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                                recordItr.close();
                                throw throwable4;
                            }
                        }
                        try {
                            recordItr.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    recordItr.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (logFileReader == null) continue;
                if (throwable != null) {
                    try {
                        logFileReader.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                logFileReader.close();
            }
        }
    }

    private void verifyMetadataMergedRecords(HoodieTableMetaClient metadataMetaClient, List<String> logFilePaths, String latestCommitTimestamp) {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)HoodieMetadataRecord.getClassSchema());
        HoodieMetadataLogRecordReader logRecordReader = HoodieMetadataLogRecordReader.newBuilder().withStorage(metadataMetaClient.getStorage()).withBasePath(metadataMetaClient.getBasePath()).withLogFilePaths(logFilePaths).withLatestInstantTime(latestCommitTimestamp).withPartition(MetadataPartitionType.FILES.getPartitionPath()).withReaderSchema(schema).withMaxMemorySizeInBytes(Long.valueOf(100000L)).withBufferSize(4096).withSpillableMapBasePath(this.tempDir.toString()).withDiskMapType(ExternalSpillableMap.DiskMapType.BITCASK).build();
        for (HoodieRecord entry : logRecordReader.getRecords()) {
            Assertions.assertFalse((boolean)entry.getRecordKey().isEmpty());
            Assertions.assertEquals((Object)entry.getKey().getRecordKey(), (Object)entry.getRecordKey());
        }
    }

    private void verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(HoodieTable table) throws IOException {
        table.getHoodieView().sync();
        List fileSlices = table.getSliceView().getLatestFileSlices(MetadataPartitionType.FILES.getPartitionPath()).collect(Collectors.toList());
        if (!((FileSlice)fileSlices.get(0)).getBaseFile().isPresent()) {
            throw new IllegalStateException("Base file not available!");
        }
        HoodieBaseFile baseFile = (HoodieBaseFile)((FileSlice)fileSlices.get(0)).getBaseFile().get();
        HoodieAvroHFileReaderImplBase hoodieHFileReader = (HoodieAvroHFileReaderImplBase)HoodieSparkIOFactory.getHoodieSparkIOFactory((HoodieStorage)this.storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader((HoodieConfig)table.getConfig(), new StoragePath(baseFile.getPath()));
        List records = HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)hoodieHFileReader);
        records.forEach(entry -> {
            Assertions.assertNull((Object)((GenericRecord)entry).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
            String keyInPayload = (String)((GenericRecord)entry).get("key");
            Assertions.assertFalse((boolean)keyInPayload.isEmpty());
        });
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$7(HoodieTable table) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(table);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$6(HoodieTable table, HoodieTableMetaClient metadataMetaClient) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "7");
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$5(HoodieTable table) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(table);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$4(HoodieTable table, HoodieTableMetaClient metadataMetaClient) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "0000002");
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$3(HoodieTable table, HoodieTableMetaClient metadataMetaClient) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "0000001");
    }

    private /* synthetic */ void lambda$verifyBaseMetadataTable$2(HoodieBackedTableMetadata tableMetadata, TableFileSystemView tableView, Map partitionToFilesMap, String partition) {
        try {
            this.validateFilesPerPartition(testTable, (HoodieTableMetadata)tableMetadata, tableView, partitionToFilesMap, partition);
        }
        catch (IOException e) {
            Assertions.fail((String)("Exception should not be raised: " + e));
        }
    }
}

