/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieJavaRDD
extends HoodieClientTestBase {
    @Test
    public void testGetNumPartitions() {
        int numPartitions = 6;
        HoodieJavaRDD rddData = HoodieJavaRDD.of((JavaRDD)this.jsc.parallelize(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()), numPartitions));
        Assertions.assertEquals((int)numPartitions, (int)rddData.getNumPartitions());
    }

    @Test
    public void testDeduceNumPartitions() {
        int numPartitions = 100;
        this.jsc.sc().conf().remove("spark.default.parallelism");
        SQLConf.get().unsetConf("spark.sql.shuffle.partitions");
        SQLConf.get().setConfString("spark.sql.shuffle.partitions", "5");
        HoodieJavaRDD rddData = HoodieJavaRDD.of((JavaRDD)this.jsc.parallelize(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()), numPartitions));
        Assertions.assertEquals((int)5, (int)rddData.deduceNumPartitions());
        SQLConf.get().unsetConf("spark.sql.shuffle.partitions");
        this.jsc.sc().conf().set("spark.default.parallelism", "6");
        rddData = HoodieJavaRDD.of((JavaRDD)this.jsc.parallelize(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()), numPartitions));
        Assertions.assertEquals((int)6, (int)rddData.deduceNumPartitions());
        HoodiePairData shuffleRDD = rddData.mapToPair((SerializablePairFunction & Serializable)key -> Pair.of((Object)key, (Object)1)).reduceByKey((SerializableBiFunction & Serializable)(p1, p2) -> p1, 11);
        Assertions.assertEquals((int)11, (int)shuffleRDD.deduceNumPartitions());
    }
}

