/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.nio.file.Path;
import java.util.Properties;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.index.SparkMetadataTableRecordIndex;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.index.bucket.HoodieSparkConsistentBucketIndex;
import org.apache.hudi.index.hbase.SparkHoodieHBaseIndex;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHoodieIndexConfigs {
    private String basePath;

    @BeforeEach
    public void setUp(@TempDir Path tempDir) {
        this.basePath = tempDir.toString();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieIndex.IndexType.class, names={"BLOOM", "GLOBAL_BLOOM", "SIMPLE", "GLOBAL_SIMPLE", "HBASE", "BUCKET", "RECORD_INDEX"})
    public void testCreateIndex(HoodieIndex.IndexType indexType) {
        HoodieWriteConfig.Builder clientConfigBuilder = HoodieWriteConfig.newBuilder();
        HoodieIndexConfig.Builder indexConfigBuilder = HoodieIndexConfig.newBuilder();
        switch (indexType) {
            case INMEMORY: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.INMEMORY).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieInMemoryHashIndex));
                break;
            }
            case BLOOM: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.BLOOM).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieBloomIndex));
                break;
            }
            case GLOBAL_BLOOM: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.GLOBAL_BLOOM).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieGlobalBloomIndex));
                break;
            }
            case SIMPLE: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.SIMPLE).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieSimpleIndex));
                break;
            }
            case HBASE: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.HBASE).withHBaseIndexConfig(new HoodieHBaseIndexConfig.Builder().build()).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof SparkHoodieHBaseIndex));
                break;
            }
            case BUCKET: {
                Properties props = new Properties();
                props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieSimpleBucketIndex));
                config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(indexConfigBuilder.fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof HoodieSparkConsistentBucketIndex));
                break;
            }
            case RECORD_INDEX: {
                HoodieWriteConfig config = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexType(HoodieIndex.IndexType.RECORD_INDEX).build()).build();
                Assertions.assertTrue((boolean)(SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config) instanceof SparkMetadataTableRecordIndex));
                break;
            }
        }
    }

    @Test
    public void testCreateIndexWithException() {
        HoodieWriteConfig.Builder clientConfigBuilder = HoodieWriteConfig.newBuilder();
        HoodieIndexConfig.Builder indexConfigBuilder = HoodieIndexConfig.newBuilder();
        HoodieWriteConfig config1 = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexClass(IndexWithConstructor.class.getName()).build()).build();
        Throwable thrown1 = Assertions.assertThrows(HoodieException.class, () -> SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config1), (String)"exception is expected");
        Assertions.assertTrue((boolean)thrown1.getMessage().contains("is not a subclass of HoodieIndex"));
        HoodieWriteConfig config2 = clientConfigBuilder.withPath(this.basePath).withIndexConfig(indexConfigBuilder.withIndexClass(IndexWithoutConstructor.class.getName()).build()).build();
        Throwable thrown2 = Assertions.assertThrows(HoodieException.class, () -> SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)config2), (String)"exception is expected");
        Assertions.assertTrue((boolean)thrown2.getMessage().contains("Unable to instantiate class"));
    }

    public static class IndexWithoutConstructor {
    }

    public static class IndexWithConstructor {
        public IndexWithConstructor(HoodieWriteConfig config) {
        }
    }
}

