/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Tuple2;

public class TestHoodieBloomIndex
extends TestHoodieMetadataBase {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestHoodieBloomIndex.class, (String)"/exampleSchema.avsc", (boolean)true);
    private static final String TEST_NAME_WITH_PARAMS = "[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}";
    private static final Random RANDOM = new Random(57069L);

    public static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{true, true, true, false}, {false, true, true, false}, {true, true, false, false}, {true, false, true, false}, {true, true, true, true}, {false, true, true, true}, {true, true, false, true}, {true, false, true, true}};
        return Stream.of(data).map(Arguments::of);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.initMetaClient();
        HoodieIndexConfig.Builder indexBuilder = HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(indexBuilder.build()).build();
        this.writeClient = this.getHoodieWriteClient(config);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    private HoodieWriteConfig makeConfig(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().bloomIndexPruneByRanges(rangePruning).bloomIndexTreebasedFilter(treeFiltering).bloomIndexBucketizedChecking(bucketizedChecking).bloomIndexKeysPerBucket(2).bloomIndexUseMetadata(useMetadataTable).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexBloomFilter(useMetadataTable).withMetadataIndexColumnStats(useMetadataTable).build()).build();
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testLoadInvolvedFiles(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) throws Exception {
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        testTable.withPartitionMetaFiles(new String[]{"2016/01/21", "2016/04/01", "2015/03/12"});
        RawTripTestPayload rowChange1 = new RawTripTestPayload("{\"_row_key\":\"000\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload("{\"_row_key\":\"001\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload("{\"_row_key\":\"002\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload("{\"_row_key\":\"003\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        List<String> partitions = Arrays.asList("2016/01/21", "2016/04/01", "2015/03/12");
        List filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)0, (int)filesList.size());
        String fileId1 = "1";
        String fileId2 = "2";
        String fileId3 = "3";
        String fileId4 = "4";
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String commitTime = "20160401010101";
        StoragePath baseFilePath = testTable.forCommit(commitTime).withInserts(partitions.get(1), "2", Collections.emptyList());
        long baseFileLength = this.storage.getPathInfo(new StoragePath(baseFilePath.toUri())).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(partitions.get(1), k -> new ArrayList()).add(Pair.of((Object)"2", (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Arrays.asList(partitions.get(1)), partitionToFilesNameLengthMap, false, false);
        commitTime = "20150312101010";
        partitionToFilesNameLengthMap.clear();
        testTable.forCommit(commitTime);
        baseFilePath = testTable.withInserts(partitions.get(2), "1", Collections.emptyList());
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(partitions.get(2), k -> new ArrayList()).add(Pair.of((Object)"1", (Object)((int)baseFileLength)));
        baseFilePath = testTable.withInserts(partitions.get(2), "3", Collections.singletonList(record1));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(partitions.get(2), k -> new ArrayList()).add(Pair.of((Object)"3", (Object)((int)baseFileLength)));
        baseFilePath = testTable.withInserts(partitions.get(2), "4", Arrays.asList(record2, record3, record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(partitions.get(2), k -> new ArrayList()).add(Pair.of((Object)"4", (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Arrays.asList(partitions.get(2)), partitionToFilesNameLengthMap, false, false);
        filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)4, (int)filesList.size());
        if (rangePruning) {
            Assertions.assertNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(0)).getRight()).getMaxRecordKey());
            Assertions.assertNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(0)).getRight()).getMinRecordKey());
            Assertions.assertFalse((boolean)((BloomIndexFileInfo)((Pair)filesList.get(1)).getRight()).hasKeyRanges());
            Assertions.assertNotNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(2)).getRight()).getMaxRecordKey());
            Assertions.assertNotNull((Object)((BloomIndexFileInfo)((Pair)filesList.get(2)).getRight()).getMinRecordKey());
            Assertions.assertTrue((boolean)((BloomIndexFileInfo)((Pair)filesList.get(3)).getRight()).hasKeyRanges());
            List<ImmutablePair> expected = Arrays.asList(new ImmutablePair((Object)"2016/04/01", (Object)new BloomIndexFileInfo("2")), new ImmutablePair((Object)"2015/03/12", (Object)new BloomIndexFileInfo("1")), new ImmutablePair((Object)"2015/03/12", (Object)new BloomIndexFileInfo("3", "000", "000")), new ImmutablePair((Object)"2015/03/12", (Object)new BloomIndexFileInfo("4", "001", "003")));
            Assertions.assertEquals(expected, (Object)filesList);
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testRangePruning(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) {
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        HoodieBloomIndex index = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        HashMap<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo = new HashMap<String, List<BloomIndexFileInfo>>();
        partitionToFileIndexInfo.put("2017/10/22", Arrays.asList(new BloomIndexFileInfo("f1"), new BloomIndexFileInfo("f2", "000", "000"), new BloomIndexFileInfo("f3", "001", "003"), new BloomIndexFileInfo("f4", "002", "007"), new BloomIndexFileInfo("f5", "009", "010")));
        JavaPairRDD partitionRecordKeyPairRDD = this.jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/22", (Object)"003"), new Tuple2((Object)"2017/10/22", (Object)"002"), new Tuple2((Object)"2017/10/22", (Object)"005"), new Tuple2((Object)"2017/10/22", (Object)"004"))).mapToPair((PairFunction & Serializable)t -> t);
        List comparisonKeyList = index.explodeRecordsWithFileComparisons(partitionToFileIndexInfo, (HoodiePairData)HoodieJavaPairRDD.of((JavaPairRDD)partitionRecordKeyPairRDD)).collectAsList();
        Assertions.assertEquals((int)10, (int)comparisonKeyList.size());
        Map recordKeyToFileComps = comparisonKeyList.stream().collect(Collectors.groupingBy(t -> (String)t.getRight(), Collectors.mapping(t -> ((HoodieFileGroupId)t.getLeft()).getFileId(), Collectors.toList())));
        Assertions.assertEquals((int)4, (int)recordKeyToFileComps.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f3", "f4")), new HashSet(recordKeyToFileComps.get("002")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f3", "f4")), new HashSet(recordKeyToFileComps.get("003")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f4")), new HashSet(recordKeyToFileComps.get("004")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f1", "f4")), new HashSet(recordKeyToFileComps.get("005")));
    }

    @Test
    public void testCheckUUIDsAgainstOneFile() throws Exception {
        String partition = "2016/01/31";
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"3eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"4eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        filter.add(record3.getRecordKey());
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, filter, this.metadataWriter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String commitTime = "0000001";
        String fileId = TestHoodieBloomIndex.genRandomUUID();
        StoragePath baseFilePath = testTable.forCommit("0000001").withInserts("2016/01/31", fileId, Arrays.asList(record1, record2));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000001", WriteOperationType.UPSERT, Collections.singletonList("2016/01/31"), partitionToFilesNameLengthMap, false, false);
        String filename = testTable.getBaseFileNameById(fileId);
        Assertions.assertTrue((boolean)filter.mightContain(record1.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record2.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record3.getRecordKey()));
        Assertions.assertFalse((boolean)filter.mightContain(record4.getRecordKey()));
        List<String> uuids = Arrays.asList(record1.getRecordKey(), record2.getRecordKey(), record3.getRecordKey(), record4.getRecordKey());
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        List results = HoodieIndexUtils.filterKeysFromFile((StoragePath)new StoragePath(Paths.get(this.basePath, "2016/01/31", filename).toString()), uuids, (HoodieStorage)this.storage);
        Assertions.assertEquals((int)results.size(), (int)2);
        Assertions.assertTrue((((String)((Pair)results.get(0)).getLeft()).equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0") || ((String)((Pair)results.get(1)).getLeft()).equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0") ? 1 : 0) != 0);
        Assertions.assertTrue((((String)((Pair)results.get(0)).getLeft()).equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0") || ((String)((Pair)results.get(1)).getLeft()).equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0") ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testTagLocationWithEmptyRDD(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) {
        JavaRDD recordRDD = this.jsc.emptyRDD();
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        Assertions.assertDoesNotThrow(() -> this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)table), (String)"EmptyRDD should not result in IllegalArgumentException: Positive number of slices required");
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testTagLocationOnPartitionedTable(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) throws Exception {
        String rowKey1 = TestHoodieBloomIndex.genRandomUUID();
        String rowKey2 = TestHoodieBloomIndex.genRandomUUID();
        String rowKey3 = TestHoodieBloomIndex.genRandomUUID();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2, record3, record4));
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String partition1 = "2016/01/31";
        String partition2 = "2015/01/31";
        String fileId1 = TestHoodieBloomIndex.genRandomUUID();
        String commit1 = "0000001";
        StoragePath baseFilePath = testTable.forCommit("0000001").withInserts("2016/01/31", fileId1, Collections.singletonList(record1));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId1, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000001", WriteOperationType.UPSERT, Collections.singletonList("2016/01/31"), partitionToFilesNameLengthMap, false, false);
        String fileId2 = TestHoodieBloomIndex.genRandomUUID();
        String commit2 = "0000002";
        baseFilePath = testTable.forCommit("0000002").withInserts("2016/01/31", fileId2, Collections.singletonList(record2));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId2, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000002", WriteOperationType.UPSERT, Collections.singletonList("2016/01/31"), partitionToFilesNameLengthMap, false, false);
        String fileId3 = TestHoodieBloomIndex.genRandomUUID();
        String commit3 = "0000003";
        baseFilePath = testTable.forCommit("0000003").withInserts("2015/01/31", fileId3, Collections.singletonList(record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId3, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000003", WriteOperationType.UPSERT, Collections.singletonList("2015/01/31"), partitionToFilesNameLengthMap, false, false);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient));
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            if (record.getRecordKey().equals(rowKey1)) {
                if (record.getPartitionPath().equals("2015/01/31")) {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId3);
                    continue;
                }
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId1);
                continue;
            }
            if (record.getRecordKey().equals(rowKey2)) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId2);
                continue;
            }
            if (!record.getRecordKey().equals(rowKey3)) continue;
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testTagLocationOnNonpartitionedTable(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) throws Exception {
        String rowKey1 = TestHoodieBloomIndex.genRandomUUID();
        String rowKey2 = TestHoodieBloomIndex.genRandomUUID();
        String rowKey3 = TestHoodieBloomIndex.genRandomUUID();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String emptyPartitionPath = "";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), emptyPartitionPath), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), emptyPartitionPath), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), emptyPartitionPath), (HoodieRecordPayload)rowChange3);
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2, record3));
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String fileId1 = TestHoodieBloomIndex.genRandomUUID();
        String commit1 = "0000001";
        StoragePath baseFilePath = testTable.forCommit("0000001").withInserts(emptyPartitionPath, fileId1, Collections.singletonList(record1));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(emptyPartitionPath, k -> new ArrayList()).add(Pair.of((Object)fileId1, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000001", WriteOperationType.UPSERT, Collections.singletonList(emptyPartitionPath), partitionToFilesNameLengthMap, false, false);
        String fileId2 = TestHoodieBloomIndex.genRandomUUID();
        String commit2 = "0000002";
        baseFilePath = testTable.forCommit("0000002").withInserts(emptyPartitionPath, fileId2, Collections.singletonList(record2));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent(emptyPartitionPath, k -> new ArrayList()).add(Pair.of((Object)fileId2, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000002", WriteOperationType.UPSERT, Collections.singletonList(emptyPartitionPath), partitionToFilesNameLengthMap, false, false);
        String fileId3 = UUID.randomUUID().toString();
        String commit3 = "0000003";
        baseFilePath = testTable.forCommit("0000003").withInserts(emptyPartitionPath, fileId3, Collections.singletonList(record3));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent(emptyPartitionPath, k -> new ArrayList()).add(Pair.of((Object)fileId3, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000003", WriteOperationType.UPSERT, Collections.singletonList(emptyPartitionPath), partitionToFilesNameLengthMap, false, false);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient));
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            if (record.getRecordKey().equals(rowKey1)) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId1);
                continue;
            }
            if (record.getRecordKey().equals(rowKey2)) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId2);
                continue;
            }
            if (!record.getRecordKey().equals(rowKey3)) continue;
            Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId3);
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testCheckExists(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) throws Exception {
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"3eb5b87c-1fej-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieKey key1 = new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath());
        HoodieAvroRecord record1 = new HoodieAvroRecord(key1, (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieKey key2 = new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath());
        HoodieAvroRecord record2 = new HoodieAvroRecord(key2, (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieKey key3 = new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath());
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieKey key4 = new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath());
        HoodieAvroRecord record4 = new HoodieAvroRecord(key4, (HoodieRecordPayload)rowChange4);
        JavaRDD keysRDD = this.jsc.parallelize(Arrays.asList(key1, key2, key3, key4));
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)keysRDD.map((Function & Serializable)k -> new HoodieAvroRecord(k, null)), (HoodieTable)hoodieTable);
        JavaPairRDD recordLocationsRDD = taggedRecords.mapToPair((PairFunction & Serializable)hr -> new Tuple2((Object)hr.getKey(), (Object)(hr.isCurrentLocationKnown() ? Option.of((Object)Pair.of((Object)hr.getPartitionPath(), (Object)hr.getCurrentLocation().getFileId())) : Option.empty())));
        for (Tuple2 record : recordLocationsRDD.collect()) {
            Assertions.assertTrue((!((Option)record._2).isPresent() ? 1 : 0) != 0);
        }
        String partition1 = "2016/01/31";
        String partition2 = "2015/01/31";
        String fileId1 = TestHoodieBloomIndex.genRandomUUID();
        String fileId2 = TestHoodieBloomIndex.genRandomUUID();
        String fileId3 = TestHoodieBloomIndex.genRandomUUID();
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String commit1 = "0000001";
        StoragePath baseFilePath = testTable.forCommit("0000001").withInserts("2016/01/31", fileId1, Collections.singletonList(record1));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId1, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000001", WriteOperationType.UPSERT, Collections.singletonList("2016/01/31"), partitionToFilesNameLengthMap, false, false);
        String commit2 = "0000002";
        partitionToFilesNameLengthMap.clear();
        baseFilePath = testTable.forCommit("0000002").withInserts("2016/01/31", fileId2, Collections.singletonList(record2));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId2, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000002", WriteOperationType.UPSERT, Collections.singletonList("2016/01/31"), partitionToFilesNameLengthMap, false, false);
        String commit3 = "0000003";
        partitionToFilesNameLengthMap.clear();
        baseFilePath = testTable.forCommit("0000003").withInserts("2015/01/31", fileId3, Collections.singletonList(record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/01/31", k -> new ArrayList()).add(Pair.of((Object)fileId3, (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000003", WriteOperationType.UPSERT, Collections.singletonList("2015/01/31"), partitionToFilesNameLengthMap, false, false);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        taggedRecords = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)keysRDD.map((Function & Serializable)k -> new HoodieAvroRecord(k, null)), (HoodieTable)hoodieTable);
        recordLocationsRDD = taggedRecords.mapToPair((PairFunction & Serializable)hr -> new Tuple2((Object)hr.getKey(), (Object)(hr.isCurrentLocationKnown() ? Option.of((Object)Pair.of((Object)hr.getPartitionPath(), (Object)hr.getCurrentLocation().getFileId())) : Option.empty())));
        for (Tuple2 record : recordLocationsRDD.collect()) {
            if (((HoodieKey)record._1).getRecordKey().equals("1eb5b87a-1feh-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertTrue((boolean)((Option)record._2).isPresent());
                Assertions.assertEquals((Object)fileId1, (Object)((Pair)((Option)record._2).get()).getRight());
                continue;
            }
            if (((HoodieKey)record._1).getRecordKey().equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertTrue((boolean)((Option)record._2).isPresent());
                if (((HoodieKey)record._1).getPartitionPath().equals("2015/01/31")) {
                    Assertions.assertEquals((Object)fileId3, (Object)((Pair)((Option)record._2).get()).getRight());
                    continue;
                }
                Assertions.assertEquals((Object)fileId2, (Object)((Pair)((Option)record._2).get()).getRight());
                continue;
            }
            if (!((HoodieKey)record._1).getRecordKey().equals("3eb5b87c-1fej-4edd-87b4-6ec96dc405a0")) continue;
            Assertions.assertFalse((boolean)((Option)record._2).isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] Test with rangePruning={0}, treeFiltering={1}, bucketizedChecking={2}, useMetadataTable={3}")
    @MethodSource(value={"configParams"})
    public void testBloomFilterFalseError(boolean rangePruning, boolean treeFiltering, boolean bucketizedChecking, boolean useMetadataTable) throws Exception {
        String recordStr1 = "{\"_row_key\":\"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"2eb5b87b-1feu-4edd-87b4-6ec96dc405a0\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        filter.add(record2.getRecordKey());
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, filter, (Option<HoodieEngineContext>)Option.of((Object)this.context));
        String fileId = testTable.addCommit("000").getFileIdWithInserts("2016/01/31", new HoodieRecord[]{record1});
        Assertions.assertTrue((boolean)filter.mightContain(record1.getRecordKey()));
        Assertions.assertTrue((boolean)filter.mightContain(record2.getRecordKey()));
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2));
        HoodieWriteConfig config = this.makeConfig(rangePruning, treeFiltering, bucketizedChecking, useMetadataTable);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieBloomIndex bloomIndex = new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation((HoodieIndex)bloomIndex, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)table);
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            if (record.getKey().equals((Object)"1eb5b87a-1feh-4edd-87b4-6ec96dc405a0")) {
                Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId);
                continue;
            }
            if (!record.getRecordKey().equals("2eb5b87b-1feu-4edd-87b4-6ec96dc405a0")) continue;
            Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
    }

    private static String genRandomUUID() {
        return HoodieTestDataGenerator.genPseudoRandomUUID((Random)RANDOM).toString();
    }
}

