/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.hudi.index.bloom.KeyRangeLookupTree;
import org.apache.hudi.index.bloom.KeyRangeNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyRangeLookupTree {
    private static final Random RANDOM = new Random();
    private KeyRangeLookupTree keyRangeLookupTree = new KeyRangeLookupTree();
    private Map<String, HashSet<String>> expectedMatches = new HashMap<String, HashSet<String>>();

    @Test
    public void testFileGroupLookUpOneEntry() {
        KeyRangeNode toInsert = new KeyRangeNode(Long.toString(300L), Long.toString(450L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        this.testRangeOfInputs(290L, 305L);
        this.testRangeOfInputs(390L, 400L);
        this.testRangeOfInputs(445L, 455L);
        this.testRangeOfInputs(600L, 605L);
    }

    @Test
    public void testFileGroupLookUpManyEntriesWithSameStartValue() {
        String startKey = Long.toString(120L);
        long endKey = 250L;
        KeyRangeNode toInsert = new KeyRangeNode(startKey, Long.toString(endKey), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        for (int i = 0; i < 10; ++i) {
            toInsert = new KeyRangeNode(startKey, Long.toString(endKey += (long)(1 + RANDOM.nextInt(50))), UUID.randomUUID().toString());
            this.updateExpectedMatchesToTest(toInsert);
            this.keyRangeLookupTree.insert(toInsert);
        }
        this.testRangeOfInputs(110L, endKey + 5L);
    }

    @Test
    public void testFileGroupLookUpManyDuplicateEntries() {
        KeyRangeNode toInsert = new KeyRangeNode(Long.toString(1200L), Long.toString(2000L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        for (int i = 0; i < 10; ++i) {
            toInsert = new KeyRangeNode(Long.toString(1200L), Long.toString(2000L), UUID.randomUUID().toString());
            this.updateExpectedMatchesToTest(toInsert);
            this.keyRangeLookupTree.insert(toInsert);
        }
        this.testRangeOfInputs(1050L, 1100L);
        this.testRangeOfInputs(1500L, 1600L);
        this.testRangeOfInputs(1990L, 2100L);
    }

    @Test
    public void testFileGroupLookUp() {
        KeyRangeNode toInsert = new KeyRangeNode(Long.toString(500L), Long.toString(600L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(750L), Long.toString(950L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(120L), Long.toString(620L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(550L), Long.toString(775L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(725L), Long.toString(850L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(750L), Long.toString(825L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(750L), Long.toString(990L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(800L), Long.toString(820L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(200L), Long.toString(550L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(520L), Long.toString(600L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        toInsert = new KeyRangeNode(Long.toString(120L), Long.toString(620L), UUID.randomUUID().toString());
        this.updateExpectedMatchesToTest(toInsert);
        this.keyRangeLookupTree.insert(toInsert);
        this.testRangeOfInputs(110L, 999L);
    }

    private void testRangeOfInputs(long start, long end) {
        for (long i = start; i <= end; ++i) {
            String iStr = Long.toString(i);
            if (!this.expectedMatches.containsKey(iStr)) {
                Assertions.assertEquals((Object)Collections.EMPTY_SET, (Object)this.keyRangeLookupTree.getMatchingIndexFiles(iStr));
                continue;
            }
            Assertions.assertEquals(this.expectedMatches.get(iStr), (Object)this.keyRangeLookupTree.getMatchingIndexFiles(iStr));
        }
    }

    private void updateExpectedMatchesToTest(KeyRangeNode toInsert) {
        long startKey = Long.parseLong(toInsert.getMinRecordKey());
        long endKey = Long.parseLong(toInsert.getMaxRecordKey());
        for (long i = startKey; i <= endKey; ++i) {
            String iStr = Long.toString(i);
            if (!this.expectedMatches.containsKey(iStr)) {
                this.expectedMatches.put(iStr, new HashSet());
            }
            this.expectedMatches.get(iStr).add((String)toInsert.getFileNameList().get(0));
        }
    }
}

