/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieSimpleBucketIndex
extends HoodieSparkClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieSimpleBucketIndex.class);
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestHoodieSimpleBucketIndex.class, (String)"/exampleSchema.avsc", (boolean)true);
    private static final int NUM_BUCKET = 8;

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @Test
    public void testBucketIndexValidityCheck() {
        Properties props = new Properties();
        props.setProperty(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "_row_key");
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "uuid");
        Assertions.assertThrows(HoodieIndexException.class, () -> HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).withBucketNum("8").build());
        props.setProperty(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "uuid");
        HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).withBucketNum("8").build();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTagLocation(boolean isInsert) throws Exception {
        String rowKey1 = UUID.randomUUID().toString();
        String rowKey2 = UUID.randomUUID().toString();
        String rowKey3 = UUID.randomUUID().toString();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        RawTripTestPayload rowChange1 = new RawTripTestPayload(recordStr1);
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload(recordStr2);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload(recordStr3);
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload(recordStr4);
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2, record3, record4));
        HoodieWriteConfig config = this.makeConfig();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieSimpleBucketIndex bucketIndex = new HoodieSimpleBucketIndex(config);
        HoodieData taggedRecordRDD = bucketIndex.tagLocation((HoodieData)HoodieJavaRDD.of((JavaRDD)recordRDD), (HoodieEngineContext)this.context, (HoodieTable)table);
        Assertions.assertFalse((boolean)taggedRecordRDD.collectAsList().stream().anyMatch(r -> r.isCurrentLocationKnown()));
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of((HoodieTable)table, SCHEMA);
        if (isInsert) {
            testTable.addCommit("001").withInserts("2016/01/31", this.getRecordFileId((HoodieRecord)record1), new HoodieRecord[]{record1});
            testTable.addCommit("002").withInserts("2016/01/31", this.getRecordFileId((HoodieRecord)record2), new HoodieRecord[]{record2});
            testTable.addCommit("003").withInserts("2016/01/31", this.getRecordFileId((HoodieRecord)record3), new HoodieRecord[]{record3});
        } else {
            testTable.addCommit("001").withLogAppends("2016/01/31", this.getRecordFileId((HoodieRecord)record1), new HoodieRecord[]{record1});
            testTable.addCommit("002").withLogAppends("2016/01/31", this.getRecordFileId((HoodieRecord)record2), new HoodieRecord[]{record2});
            testTable.addCommit("003").withLogAppends("2016/01/31", this.getRecordFileId((HoodieRecord)record3), new HoodieRecord[]{record3});
        }
        taggedRecordRDD = bucketIndex.tagLocation((HoodieData)HoodieJavaRDD.of((JavaRDD)recordRDD), (HoodieEngineContext)this.context, (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient));
        Assertions.assertFalse((boolean)taggedRecordRDD.collectAsList().stream().filter(r -> r.isCurrentLocationKnown()).filter(r -> BucketIdentifier.bucketIdFromFileId((String)r.getCurrentLocation().getFileId()) != this.getRecordBucketId((HoodieRecord)r)).findAny().isPresent());
        Assertions.assertTrue((taggedRecordRDD.collectAsList().stream().filter(r -> r.getPartitionPath().equals("2015/01/31") && !r.isCurrentLocationKnown()).count() == 1L ? 1 : 0) != 0);
        Assertions.assertTrue((taggedRecordRDD.collectAsList().stream().filter(r -> r.getPartitionPath().equals("2016/01/31") && r.isCurrentLocationKnown()).count() == 3L ? 1 : 0) != 0);
    }

    private HoodieWriteConfig makeConfig() {
        Properties props = new Properties();
        props.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema(SCHEMA.toString()).withIndexConfig(HoodieIndexConfig.newBuilder().fromProperties(props).withIndexType(HoodieIndex.IndexType.BUCKET).withBucketIndexEngineType(HoodieIndex.BucketIndexEngineType.SIMPLE).withIndexKeyField("_row_key").withBucketNum(String.valueOf(8)).build()).build();
    }

    private String getRecordFileId(HoodieRecord record) {
        return BucketIdentifier.bucketIdStr((int)BucketIdentifier.getBucketId((HoodieRecord)record, (String)"_row_key", (int)8));
    }

    private int getRecordBucketId(HoodieRecord record) {
        return BucketIdentifier.getBucketId((HoodieRecord)record, (String)"_row_key", (int)8);
    }
}

