/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.expression;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.index.expression.HoodieSparkExpressionIndex;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieSparkExpressionIndex
extends HoodieSparkClientTestHarness {
    @BeforeEach
    public void setup() {
        this.initSparkContexts("TestHoodieSparkExpressionIndex");
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
    }

    @Test
    public void testYearFunction() {
        Dataset df = this.sparkSession.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Timestamp.valueOf("2021-03-15 12:34:56")}), RowFactory.create((Object[])new Object[]{Timestamp.valueOf("2022-07-10 23:45:01")})), DataTypes.createStructType(Arrays.asList(DataTypes.createStructField((String)"timestampColumn", (DataType)DataTypes.TimestampType, (boolean)false))));
        df.createOrReplaceTempView("testData");
        HoodieSparkExpressionIndex index = new HoodieSparkExpressionIndex("yearIndex", "year", Arrays.asList("timestampColumn"), new HashMap());
        Column yearColumn = index.apply(Arrays.asList(functions.col((String)"timestampColumn")));
        Dataset resultDf = df.withColumn("year", yearColumn);
        List results = resultDf.select("year", new String[0]).collectAsList();
        Assertions.assertEquals((Object)"2021", (Object)((Row)results.get(0)).getAs("year").toString());
        Assertions.assertEquals((Object)"2022", (Object)((Row)results.get(1)).getAs("year").toString());
    }

    @Test
    public void testHourFunction() {
        Dataset df = this.sparkSession.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Timestamp.valueOf("2021-03-15 12:34:56")}), RowFactory.create((Object[])new Object[]{Timestamp.valueOf("2022-07-10 23:45:01")})), DataTypes.createStructType(Arrays.asList(DataTypes.createStructField((String)"timestampColumn", (DataType)DataTypes.TimestampType, (boolean)false))));
        df.createOrReplaceTempView("testData");
        HoodieSparkExpressionIndex index = new HoodieSparkExpressionIndex("hourIndex", "hour", Arrays.asList("timestampColumn"), new HashMap());
        Column hourColumn = index.apply(Arrays.asList(functions.col((String)"timestampColumn")));
        Dataset resultDf = df.withColumn("hour", hourColumn);
        List results = resultDf.select("hour", new String[0]).collectAsList();
        Assertions.assertEquals((Object)"12", (Object)((Row)results.get(0)).getAs("hour").toString());
        Assertions.assertEquals((Object)"23", (Object)((Row)results.get(1)).getAs("hour").toString());
    }

    @Test
    public void testApplyYearFunctionWithWrongNumberOfArguments() {
        List<Column> sourceColumns = Arrays.asList(functions.col((String)"timestampColumn"), functions.col((String)"extraColumn"));
        HoodieSparkExpressionIndex index = new HoodieSparkExpressionIndex("yearIndex", "year", Arrays.asList("timestampColumn", "extraColumn"), Collections.emptyMap());
        Assertions.assertThrows(IllegalArgumentException.class, () -> index.apply(sourceColumns));
    }
}

