/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.timeline.versioning.v2.LSMTimelineWriter;
import org.apache.hudi.client.timeline.versioning.v2.TimelineArchiverV2;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieLSMTimelineManifest;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.LSMTimeline;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieTimelineArchiver
extends HoodieSparkClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieTimelineArchiver.class);
    private HoodieTableMetadataWriter metadataWriter;
    private HoodieTestTable testTable;

    public void init() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
    }

    public void init(HoodieTableType tableType) throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.initTimelineService();
        this.initMetaClient();
        this.storage = this.metaClient.getStorage();
        this.metaClient.getStorage().createDirectory(new StoragePath(this.basePath));
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)tableType);
    }

    private void initWriteConfigAndMetatableWriter(HoodieWriteConfig writeConfig, boolean enableMetadataTable) {
        if (enableMetadataTable) {
            this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            this.testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.metadataWriter, (Option)Option.of((Object)this.context));
        } else {
            this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        }
    }

    @AfterEach
    public void clean() throws Exception {
        this.cleanupResources();
        if (this.metadataWriter != null) {
            this.metadataWriter.close();
        }
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommitsMetadataTable, HoodieTableType.COPY_ON_WRITE);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommits, maxDeltaCommitsMetadataTable, tableType, 10, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, 5, maxDeltaCommitsMetadataTable, tableType, 10, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommitsMetadataTable, int archiveFilesBatch) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, 5, maxDeltaCommitsMetadataTable, HoodieTableType.COPY_ON_WRITE, archiveFilesBatch, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER);
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType, int archiveFilesBatch, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, WriteConcurrencyMode writeConcurrencyMode) throws Exception {
        return this.initTestTableAndGetWriteConfig(enableMetadata, minArchivalCommits, maxArchivalCommits, maxDeltaCommits, maxDeltaCommitsMetadataTable, tableType, archiveFilesBatch, failedWritesCleaningPolicy, writeConcurrencyMode, (Boolean)HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT.defaultValue());
    }

    private HoodieWriteConfig initTestTableAndGetWriteConfig(boolean enableMetadata, int minArchivalCommits, int maxArchivalCommits, int maxDeltaCommits, int maxDeltaCommitsMetadataTable, HoodieTableType tableType, int archiveFilesBatch, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, WriteConcurrencyMode writeConcurrencyMode, boolean archiveProceedBeyondSavepoints) throws Exception {
        this.init(tableType);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).withFailedWritesCleaningPolicy(failedWritesCleaningPolicy).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().withTimelineCompactionBatchSize(archiveFilesBatch).archiveCommitsWith(minArchivalCommits, maxArchivalCommits).withArchiveBeyondSavepoint(archiveProceedBeyondSavepoints).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(maxDeltaCommits).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadata).withMaxNumDeltaCommitsBeforeCompaction(maxDeltaCommitsMetadataTable).withMetadataIndexColumnStats(false).build()).withWriteConcurrencyMode(writeConcurrencyMode).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).forTable("test-trip-table").build();
        this.initWriteConfigAndMetatableWriter(writeConfig, enableMetadata);
        return writeConfig;
    }

    @Test
    public void testArchiveEmptyTable() throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        int result = archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Assertions.assertEquals((int)0, (int)result);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTableWithArchival(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i < 6) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 6) {
                this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000005", "00000006")), commitsAfterArchival, false);
                continue;
            }
            if (i < 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i == 8) {
                this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004")), this.getActiveCommitInstants(Arrays.asList("00000005", "00000006", "00000007", "00000008")), commitsAfterArchival, false);
                continue;
            }
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
    }

    @Test
    public void testArchiveTableWithReplaceCommits() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2);
        for (int i = 1; i < 9; ++i) {
            if (i < 3) {
                this.testTable.doWriteOperation(this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            } else {
                this.testTable.doWriteOperation(this.metaClient.createNewInstantTime(), WriteOperationType.INSERT_OVERWRITE, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i != 8) continue;
            Assertions.assertEquals((int)6, (int)originalCommits.size());
            Assertions.assertEquals((int)4, (int)commitsAfterArchival.size());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"KEEP_LATEST_BY_HOURS", "KEEP_LATEST_COMMITS"})
    public void testArchivalWithAutoAdjustmentBasedOnCleanConfigs(String cleaningPolicy) throws Exception {
        this.init();
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(5).withMetadataIndexColumnStats(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withCleanerPolicy(HoodieCleaningPolicy.valueOf((String)cleaningPolicy)).cleanerNumHoursRetained(1).retainCommits(5).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(3, 4).build()).build();
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        String p0 = "2020/01/01";
        String p1 = "2020/01/02";
        Instant instant = Instant.now();
        ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        ArrayList<HoodieInstant> expectedAllCommits = new ArrayList<HoodieInstant>();
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 90, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 80, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 70, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 50, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 45, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 40, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 30, false, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 20, false, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 10, true, testTable, config));
        expectedAllCommits.add(this.triggerCommit(p0, p1, commitDateTime, 5, true, testTable, config));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(config, true);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        this.assertInstantListEquals(expectedAllCommits, originalCommits);
        this.assertInstantListEquals(expectedAllCommits.subList(2, expectedAllCommits.size()), commitsAfterArchival);
    }

    private HoodieInstant triggerCommit(final String p0, final String p1, ZonedDateTime curDateTime, int minutesForCommit, boolean isComplete, HoodieTestTable testTable, HoodieWriteConfig config) throws Exception {
        final String file1P0C0 = UUID.randomUUID().toString();
        final String file1P1C0 = UUID.randomUUID().toString();
        String commitTs = TimelineUtils.formatDate((Date)Date.from(curDateTime.minusMinutes(minutesForCommit).toInstant()));
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
                }
            });
            HoodieInstant hoodieInstant = this.commitWithMdt(commitTs, part1ToFileId, testTable, metadataWriter, true, true, isComplete);
            return hoodieInstant;
        }
    }

    private HoodieInstant commitWithMdt(String instantTime, Map<String, List<String>> partToFileId, HoodieTestTable testTable, HoodieTableMetadataWriter metadataWriter, boolean addBaseFiles, boolean addLogFiles, boolean isComplete) throws Exception {
        testTable.addInflightCommit(instantTime);
        if (isComplete) {
            HashMap<String, List<String>> partToFileIds = new HashMap<String, List<String>>();
            partToFileId.forEach((key, value) -> {
                try {
                    ArrayList files = new ArrayList();
                    FileCreateUtilsLegacy.createPartitionMetaFile((String)this.basePath, (String)key);
                    if (addBaseFiles) {
                        files.addAll((Collection)testTable.withBaseFilesInPartition(key, value.toArray(new String[0])).getValue());
                    }
                    if (addLogFiles) {
                        value.forEach(logFilePrefix -> {
                            try {
                                files.addAll((Collection)testTable.withLogFile(key, logFilePrefix, new int[]{1, 2}).getValue());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    partToFileIds.put((String)key, files);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            org.apache.hudi.common.model.HoodieCommitMetadata commitMeta = TestHoodieTimelineArchiver.generateCommitMetadata(instantTime, partToFileIds);
            metadataWriter.performTableServices(Option.of((Object)instantTime));
            metadataWriter.update(commitMeta, instantTime);
            this.metaClient.getActiveTimeline().saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime), TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)this.metaClient.getCommitMetadataSerDe(), (org.apache.hudi.common.model.HoodieCommitMetadata)commitMeta));
        } else {
            org.apache.hudi.common.model.HoodieCommitMetadata commitMeta = TestHoodieTimelineArchiver.generateCommitMetadata(instantTime, new HashMap<String, List<String>>());
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(isComplete ? HoodieInstant.State.COMPLETED : HoodieInstant.State.INFLIGHT, "commit", instantTime);
    }

    protected static org.apache.hudi.common.model.HoodieCommitMetadata generateCommitMetadata(String instantTime, Map<String, List<String>> partitionToFilePaths) {
        org.apache.hudi.common.model.HoodieCommitMetadata metadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        metadata.addMetadata("schema", "{\"namespace\": \"org.apache.hudi.avro.model\", \"type\": \"record\", \"name\": \"PhonyRecord\", \"fields\": []}");
        partitionToFilePaths.forEach((partitionPath, fileList) -> fileList.forEach(f -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(partitionPath + "/" + HoodieTestCommitGenerator.getBaseFilename((String)instantTime, (String)f));
            writeStat.setFileId(f);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            metadata.addWriteStat(partitionPath, writeStat);
        }));
        return metadata;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSavepointWithArchival(boolean archiveBeyondSavepoint) throws Exception {
        boolean enableMetadata = false;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 2, 4, 5, 2, HoodieTableType.COPY_ON_WRITE, 10, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER, archiveBeyondSavepoint);
        for (int i = 1; i < 5; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        String commitToSavepoint = String.format("%08d", 3);
        HoodieSavepointMetadata savepointMetadata = this.testTable.doSavepoint(commitToSavepoint);
        this.testTable.addSavepoint(commitToSavepoint, savepointMetadata);
        for (int i = 5; i < 7; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        if (archiveBeyondSavepoint) {
            this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000004", "00000005")), Stream.concat(this.getActiveCommitInstants(Arrays.asList("00000003", "00000006")).stream(), this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")).stream()).collect(Collectors.toList()), commitsAfterArchival, true);
        } else {
            this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), Stream.concat(this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000005", "00000006")).stream(), this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")).stream()).collect(Collectors.toList()), commitsAfterArchival, false);
        }
        for (int i = 7; i < 10; ++i) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        this.testTable.deleteSavepoint(commitToSavepoint);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        this.metaClient.reloadActiveTimeline();
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000006", "00000007")), this.getActiveCommitInstants(Arrays.asList("00000008", "00000009")), commitsAfterArchival, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testClusteringCommitAndSavepointWithArchival(boolean archiveBeyondSavepoint) throws Exception {
        List<HoodieInstant> archivedCommitInstants;
        boolean enableMetadata = false;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 2, 4, 5, 2, HoodieTableType.COPY_ON_WRITE, 10, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER, archiveBeyondSavepoint);
        for (int i = 1; i < 8; ++i) {
            if (i < 3 || i == 5) {
                this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
                continue;
            }
            this.testTable.doCluster(String.format("%08d", i), Collections.singletonMap("p1", Collections.singletonList("f1")), Collections.singletonList("p2"), 2);
        }
        String commitToSavepoint = String.format("%08d", 3);
        HoodieSavepointMetadata savepointMetadata = this.testTable.doSavepoint(commitToSavepoint);
        this.testTable.addSavepoint(commitToSavepoint, savepointMetadata);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List commitsAfterArchival = (List)commitsList.getValue();
        List<HoodieInstant> expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000005"));
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000006", "00000007"), "replacecommit"));
        expectedActiveInstants.addAll(this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")));
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), expectedActiveInstants, commitsAfterArchival, false);
        HashMap<String, Integer> cleanStats = new HashMap<String, Integer>();
        cleanStats.put("p1", 1);
        cleanStats.put("p2", 2);
        this.testTable.doClean(String.format("%08d", 8), cleanStats, Collections.singletonMap("savepointed_timestamps", "00000003"));
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        commitsAfterArchival = (List)commitsList.getValue();
        expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000005"));
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000006", "00000007"), "replacecommit"));
        expectedActiveInstants.addAll(this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")));
        expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008"), "clean"));
        this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), expectedActiveInstants, commitsAfterArchival, false);
        this.testTable.doClean(String.format("%08d", 9), cleanStats, Collections.singletonMap("savepointed_timestamps", "00000007"));
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        commitsAfterArchival = (List)commitsList.getValue();
        if (archiveBeyondSavepoint) {
            expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000003", "00000007"), "replacecommit");
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008", "00000009"), "clean"));
            expectedActiveInstants.addAll(this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")));
            archivedCommitInstants = this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000005"));
            archivedCommitInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000004", "00000006"), "replacecommit"));
            this.verifyArchival(archivedCommitInstants, expectedActiveInstants, commitsAfterArchival, true);
        } else {
            expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000005"));
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000003", "00000004", "00000006", "00000007"), "replacecommit"));
            expectedActiveInstants.addAll(this.getActiveSavepointedCommitInstants(Arrays.asList("00000003")));
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008", "00000009"), "clean"));
            this.verifyArchival(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002")), expectedActiveInstants, commitsAfterArchival, false);
        }
        this.testTable.deleteSavepoint(commitToSavepoint);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        commitsAfterArchival = (List)commitsList.getValue();
        if (archiveBeyondSavepoint) {
            expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000003", "00000007"), "replacecommit");
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008", "00000009"), "clean"));
            archivedCommitInstants = this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000005"));
            archivedCommitInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000004", "00000006"), "replacecommit"));
            this.verifyArchival(archivedCommitInstants, expectedActiveInstants, commitsAfterArchival, true);
        } else {
            expectedActiveInstants = this.getActiveCommitInstants(Arrays.asList("00000006", "00000007"), "replacecommit");
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000008", "00000009"), "clean"));
            archivedCommitInstants = this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000005"));
            archivedCommitInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000003", "00000004"), "replacecommit"));
            this.verifyArchival(archivedCommitInstants, expectedActiveInstants, commitsAfterArchival, false);
        }
    }

    @Test
    public void testCompactionWithCorruptVersionFile() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, 3);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        this.metaClient.getStorage().deleteDirectory(LSMTimeline.getVersionFilePath((StoragePath)this.metaClient.getArchivePath()));
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)LSMTimeline.getVersionFilePath((StoragePath)this.metaClient.getArchivePath()), (Option)Option.of((Object)StringUtils.getUTF8Bytes((String)"invalid_version")));
        HoodieActiveTimeline rawActiveTimeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)19, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.countInstants()));
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation("1000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieActiveTimeline rawActiveTimeline1 = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine1 = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)26, (int)(archivedTimeLine1.countInstants() + rawActiveTimeline1.countInstants()));
        StoragePath damagedFile = new StoragePath(this.metaClient.getArchivePath(), "300_301_1.parquet");
        FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)damagedFile, (Option)Option.of((Object)StringUtils.getUTF8Bytes((String)"dummy")));
        Assertions.assertDoesNotThrow(() -> this.metaClient.getArchivedTimeline().reload(), (String)"Archived timeline can skip the invalid data and manifest files smartly");
    }

    @Test
    public void testCompactionRecoverWithoutManifestFile() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, 3);
        for (int i = 1; i < 10; ++i) {
            this.testTable.doWriteOperation(this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        LSMTimelineWriter timelineWriter = LSMTimelineWriter.getInstance((HoodieWriteConfig)writeConfig, (HoodieTable)table);
        List candidateFiles = LSMTimeline.latestSnapshotManifest((HoodieTableMetaClient)this.metaClient, (StoragePath)this.metaClient.getArchivePath()).getFiles().stream().sorted().map(HoodieLSMTimelineManifest.LSMFileEntry::getFileName).collect(Collectors.toList());
        String compactedFileName = LSMTimelineWriter.compactedFileName(candidateFiles);
        timelineWriter.compactFiles(candidateFiles, compactedFileName);
        HoodieActiveTimeline rawActiveTimeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline().reload();
        Assertions.assertEquals((int)19, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.reload().countInstants()));
    }

    @Test
    public void testCompactionCleaning() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 2, 3);
        for (int i = 1; i < 19; ++i) {
            this.testTable.doWriteOperation(this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieActiveTimeline rawActiveTimeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(this.metaClient, false);
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline();
        Assertions.assertEquals((int)26, (int)(rawActiveTimeline.countInstants() + archivedTimeLine.countInstants()));
        Assertions.assertEquals((int)9, (int)LSMTimeline.latestSnapshotVersion((HoodieTableMetaClient)this.metaClient, (StoragePath)this.metaClient.getArchivePath()));
        Assertions.assertEquals(Arrays.asList(7, 8, 9), LSMTimeline.allSnapshotVersions((HoodieTableMetaClient)this.metaClient, (StoragePath)this.metaClient.getArchivePath()).stream().sorted().collect(Collectors.toList()));
    }

    @Test
    public void testReadArchivedCompactionPlan() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 5, HoodieTableType.MERGE_ON_READ);
        for (int i = 1; i < 11; i += 2) {
            this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            this.testTable.doCompaction(String.format("%08d", i + 1), Arrays.asList("p1", "p2"));
            this.archiveAndGetCommitsList(writeConfig);
        }
        HoodieArchivedTimeline archivedTimeLine = this.metaClient.getArchivedTimeline();
        archivedTimeLine.loadCompactionDetailsInMemory("00000001", "00000011");
        List compactionInstants = archivedTimeLine.getCommitAndReplaceTimeline().getInstants();
        Assertions.assertEquals((int)2, (int)compactionInstants.size(), (String)"Two compactions instants should be archived.");
        List planDetailsList = compactionInstants.stream().map(arg_0 -> ((HoodieArchivedTimeline)archivedTimeLine).getInstantDetails(arg_0)).collect(Collectors.toList());
        Assertions.assertTrue((boolean)planDetailsList.stream().allMatch(Option::isPresent), (String)"All the compaction instants should have plan details.");
        for (Option planDetails : planDetailsList) {
            Assertions.assertDoesNotThrow(() -> TimelineMetadataUtils.deserializeCompactionPlan((byte[])((byte[])planDetails.get())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testArchivalWithMultiWriters(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 5, 2, HoodieTableType.COPY_ON_WRITE, 10, HoodieFailedWritesCleaningPolicy.LAZY, WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL);
        ExecutorService executors = Executors.newFixedThreadPool(2);
        ArrayList<CompletableFuture<Boolean>> completableFutureList = new ArrayList<CompletableFuture<Boolean>>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<String> lastInstant = new AtomicReference<String>();
        IntStream.range(0, 2).forEach(index -> completableFutureList.add(CompletableFuture.supplyAsync(() -> {
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            try {
                countDownLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new HoodieException("Should not have thrown InterruptedException ", (Throwable)e);
            }
            this.metaClient.reloadActiveTimeline();
            while (!((HoodieInstant)this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get()).requestedTime().equals(lastInstant.get()) || this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().countInstants() > 5) {
                try {
                    TimelineArchiverV2 archiver = new TimelineArchiverV2(writeConfig, (HoodieTable)table);
                    archiver.archiveIfRequired((HoodieEngineContext)this.context, true);
                    if (enableMetadata) {
                        Thread.sleep(2L);
                    }
                }
                catch (IOException e) {
                    throw new HoodieException("IOException thrown while archiving ", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new HoodieException("Should not have thrown InterruptedException ", (Throwable)e);
                }
                table.getMetaClient().reloadActiveTimeline();
            }
            return true;
        }, executors)));
        int numWrites = 30;
        for (int i = 1; i < 30; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            if (i == 29) {
                lastInstant.set(instant);
            }
            this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            if (i != 6) continue;
            countDownLatch.countDown();
        }
        try {
            CompletableFuture completableFuture = TestHoodieTimelineArchiver.allOfTerminateOnFailure(completableFutureList);
            completableFuture.get();
        }
        finally {
            executors.shutdownNow();
        }
    }

    private static CompletableFuture allOfTerminateOnFailure(List<CompletableFuture<Boolean>> futures) {
        CompletableFuture failure = new CompletableFuture();
        AtomicBoolean jobFailed = new AtomicBoolean(false);
        int counter = 0;
        while (counter < futures.size()) {
            CompletableFuture<Boolean> curFuture = futures.get(counter);
            int finalCounter = counter++;
            curFuture.exceptionally(ex -> {
                if (!jobFailed.getAndSet(true)) {
                    LOG.warn("One of the job failed. Cancelling all other futures. " + ex.getCause() + ", " + ex.getMessage());
                    for (int secondCounter = 0; secondCounter < futures.size(); ++secondCounter) {
                        if (secondCounter == finalCounter) continue;
                        ((CompletableFuture)futures.get(secondCounter)).cancel(true);
                    }
                }
                return null;
            });
        }
        return CompletableFuture.anyOf(failure, CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNoArchivalUntilMaxArchiveConfigWithExtraInflightCommits(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        for (int i = 1; i < 6; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        this.testTable.doWriteOperation("00000006", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2, false, true);
        this.testTable.doWriteOperation("00000007", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2, false, true);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
    }

    private static Stream<Arguments> archiveCommitSavepointNoHoleParams() {
        return Arrays.stream(new Boolean[][]{{true, true}, {false, true}, {true, false}, {false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"archiveCommitSavepointNoHoleParams"})
    public void testArchiveCommitSavepointNoHole(boolean enableMetadataTable, boolean archiveBeyondSavepoint) throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 5).withArchiveBeyondSavepoint(archiveBeyondSavepoint).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"100", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"101", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createSavepointFile((String)this.basePath, (String)"101", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"102", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"103", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"104", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"105", (StorageConfiguration)this.storageConf);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"105");
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)6, (int)timeline.countInstants(), (String)"Loaded 6 commits and the count should match");
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        if (archiveBeyondSavepoint) {
            Assertions.assertEquals((int)2, (int)timeline.countInstants(), (String)"Since archiveBeyondSavepoint config is enabled, we will archive commits 102, 103 ");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "101")), (String)"Savepointed commits should always be safe");
            Assertions.assertFalse((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "102")), (String)"102 expected to be archived");
            Assertions.assertFalse((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "103")), (String)"103 expected to be archived");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "105")), (String)"104 expected to be archived");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "105")), (String)"105 expected to be in active timeline");
        } else {
            Assertions.assertEquals((int)5, (int)timeline.countInstants(), (String)"Since we have a savepoint at 101, we should never archive any commit after 101 (we only archive 100)");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "101")), (String)"Archived commits should always be safe");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "102")), (String)"Archived commits should always be safe");
            Assertions.assertTrue((boolean)timeline.containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "103")), (String)"Archived commits should always be safe");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPendingClusteringWillBlockArchival(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        HoodieTestDataGenerator.createPendingClusterFile((String)this.basePath, (String)"00000000", (StorageConfiguration)this.storageConf);
        for (int i = 1; i < 8; ++i) {
            this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)7, (int)timeline.countInstants(), (String)"Since we have a pending clustering instant at 00000000, we should never archive any commit after 00000000");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveRollbacksTestTable(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        ArrayList<Pair> instants = new ArrayList<Pair>();
        boolean hasArchivedInstants = false;
        for (int i = 1; i < 8; i += 3) {
            String commitInstant1 = this.metaClient.createNewInstantTime();
            instants.add(Pair.of((Object)commitInstant1, (Object)"commit"));
            this.testTable.doWriteOperation(commitInstant1, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            try {
                String rollbackInstant = this.metaClient.createNewInstantTime();
                this.testTable.doRollback(commitInstant1, rollbackInstant);
                instants.add(Pair.of((Object)rollbackInstant, (Object)"rollback"));
            }
            catch (HoodieMetadataException rollbackInstant) {
                // empty catch block
            }
            String commitInstant2 = this.metaClient.createNewInstantTime();
            instants.add(Pair.of((Object)commitInstant2, (Object)"commit"));
            this.testTable.doWriteOperation(commitInstant2, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            int numArchivedInstants = originalCommits.size() - commitsAfterArchival.size();
            if (originalCommits.size() - commitsAfterArchival.size() <= 0) continue;
            hasArchivedInstants = true;
            List<HoodieInstant> expectedArchivedInstants = instants.subList(0, numArchivedInstants).stream().map(p -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, (String)p.getValue(), (String)p.getKey())).collect(Collectors.toList());
            List<HoodieInstant> expectedActiveInstants = instants.subList(numArchivedInstants, instants.size()).stream().map(p -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, (String)p.getValue(), (String)p.getKey())).collect(Collectors.toList());
            this.verifyArchival(expectedArchivedInstants, expectedActiveInstants, commitsAfterArchival, false);
        }
        Assertions.assertTrue((boolean)hasArchivedInstants, (String)"Some instants should be archived");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNoArchivalWithInflightCompactionInMiddle(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2, 2, HoodieTableType.MERGE_ON_READ);
        org.apache.hudi.common.model.HoodieCommitMetadata inflightCompactionMetadata = null;
        for (int i = 1; i < 8; ++i) {
            if (i == 2) {
                inflightCompactionMetadata = this.testTable.doCompaction("0000000" + i, Arrays.asList("p1", "p2"), true);
            } else {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (enableMetadata) {
                if (i != 7) {
                    Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                    continue;
                }
                Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)0);
                continue;
            }
            if (i != 7) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)0);
            for (int j = 1; j <= 7; ++j) {
                if (j == 1) {
                    Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j)));
                    continue;
                }
                if (j == 2) {
                    Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", "0000000" + j)));
                    continue;
                }
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000000" + j)));
            }
        }
        this.testTable.moveInflightCompactionToComplete("00000002", inflightCompactionMetadata);
        this.testTable.doWriteOperation("00000008", WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), 2);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List commitsAfterArchival = (List)commitsList.getValue();
        List<HoodieInstant> archivedInstants = this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000003", "00000004"), "deltacommit");
        archivedInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "00000002"));
        this.verifyArchival(archivedInstants, this.getActiveCommitInstants(Arrays.asList("00000005", "00000006", "00000007", "00000008"), "deltacommit"), commitsAfterArchival, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveCommitTimeline(boolean enableMetadataTable) throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"1", (StorageConfiguration)this.storageConf);
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"2", (StorageConfiguration)this.storageConf);
        StoragePath markerPath = new StoragePath(this.metaClient.getMarkerFolderPath("2"));
        this.storage.createDirectory(markerPath);
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "2");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"3", (StorageConfiguration)this.storageConf);
        HoodieInstant instant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "3");
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"4", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)"5", (StorageConfiguration)this.storageConf);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)"5");
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        HoodieArchivedTimeline archivedTimeline = this.metaClient.getArchivedTimeline();
        List<HoodieInstant> archivedInstants = Arrays.asList(instant1, instant2, instant3);
        Assertions.assertEquals(new HashSet<HoodieInstant>(archivedInstants), archivedTimeline.filterCompletedInstants().getInstantsAsStream().collect(Collectors.toSet()));
        Assertions.assertFalse((boolean)this.storage.exists(markerPath));
    }

    @Test
    public void testArchiveMetrics() throws Exception {
        this.init();
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetricsConfig(HoodieMetricsConfig.newBuilder().on(true).withReporterType("INMEMORY").build()).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").build();
        HoodieMetrics metrics = new HoodieMetrics(cfg, this.storage);
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        client.archive();
        Assertions.assertTrue((boolean)metrics.getMetrics().getRegistry().getNames().contains(metrics.getMetricsName("archive", "duration")));
        Assertions.assertTrue((boolean)metrics.getMetrics().getRegistry().getNames().contains(metrics.getMetricsName("archive", "numInstantsArchived")));
    }

    private void verifyInflightInstants(HoodieTableMetaClient metaClient, int expectedTotalInstants) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().reload().getTimelineOfActions(Collections.singleton("clean")).filterInflights();
        Assertions.assertEquals((int)expectedTotalInstants, (int)timeline.countInstants(), (String)"Loaded inflight clean actions and the count should match");
    }

    @Test
    public void testConvertCommitMetadata() throws Exception {
        this.init();
        org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata = new org.apache.hudi.common.model.HoodieCommitMetadata();
        hoodieCommitMetadata.setOperationType(WriteOperationType.INSERT);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieCommitMetadata expectedCommitMetadata = (HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata((org.apache.hudi.common.model.HoodieCommitMetadata)hoodieCommitMetadata);
        Assertions.assertEquals((Object)expectedCommitMetadata.getOperationType(), (Object)WriteOperationType.INSERT.toString());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTableWithCleanCommits(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 2, 4, 8);
        HashMap<String, Integer> cleanStats = new HashMap<String, Integer>();
        cleanStats.put("p1", 1);
        cleanStats.put("p2", 2);
        for (int i = 1; i <= 8; ++i) {
            if (i == 1) {
                this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 20);
            } else if (i <= 3 || i == 5) {
                this.testTable.doClean(String.format("%08d", i), cleanStats);
            } else {
                this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 7) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            ArrayList<HoodieInstant> expectedActiveInstants = new ArrayList<HoodieInstant>(this.getActiveCommitInstants(Arrays.asList("00000007", "00000008")));
            ArrayList<HoodieInstant> expectedArchiveInstants = new ArrayList<HoodieInstant>();
            expectedArchiveInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000004", "00000006")));
            expectedArchiveInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000002", "00000003", "00000005"), "clean"));
            this.verifyArchival(expectedArchiveInstants, expectedActiveInstants, commitsAfterArchival, false);
        }
    }

    @Test
    public void testArchiveTableWithCleanerEarliestSavepoint() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(false, 4, 5, 2);
        HashMap<String, Integer> cleanStats = new HashMap<String, Integer>();
        cleanStats.put("p1", 1);
        cleanStats.put("p2", 2);
        for (int i = 1; i <= 16; ++i) {
            if (i == 7) {
                this.testTable.doCluster(String.format("%08d", i), Collections.emptyMap(), Arrays.asList("p1", "p2"), 20);
            } else if (i != 6 && i <= 12) {
                this.testTable.doWriteOperation(String.format("%08d", i), WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 20);
            } else {
                String savepoint = "00000003";
                if (i == 16) {
                    savepoint = "00000010";
                }
                this.testTable.doClean(String.format("%08d", i), cleanStats, Collections.singletonMap("savepointed_timestamps", savepoint));
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 6) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            if (i <= 10) {
                Assertions.assertEquals((int)(5 + (i % 2 == 0 ? 1 : 0)), (int)commitsAfterArchival.size(), (String)commitsAfterArchival.toString());
                continue;
            }
            if (i < 16) {
                Assertions.assertEquals((int)(i - 5), (int)commitsAfterArchival.size(), (String)commitsAfterArchival.toString());
                continue;
            }
            ArrayList<HoodieInstant> expectedActiveInstants = new ArrayList<HoodieInstant>();
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000009", "00000010", "00000011", "00000012")));
            expectedActiveInstants.addAll(this.getActiveCommitInstants(Arrays.asList("00000013", "00000014", "00000015", "00000016"), "clean"));
            ArrayList<HoodieInstant> expectedArchivedInstants = new ArrayList<HoodieInstant>();
            expectedArchivedInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000001", "00000002", "00000003", "00000004", "00000005", "00000008"), "commit"));
            expectedArchivedInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000006"), "clean"));
            expectedArchivedInstants.addAll(this.getAllArchivedCommitInstants(Arrays.asList("00000007"), "replacecommit"));
            this.verifyArchival(expectedArchivedInstants, expectedActiveInstants, commitsAfterArchival, false);
        }
    }

    @Test
    public void testArchiveRollbacksAndCleanTestTable() throws Exception {
        int i;
        int minArchiveCommits = 2;
        int maxArchiveCommits = 4;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, minArchiveCommits, maxArchiveCommits, 2);
        ArrayList<Pair> instants = new ArrayList<Pair>();
        String instant1 = this.metaClient.createNewInstantTime();
        instants.add(Pair.of((Object)instant1, (Object)"commit"));
        this.testTable.doWriteOperation(instant1, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 20);
        HashMap<String, Integer> partitionToFileDeleteCount = new HashMap<String, Integer>();
        partitionToFileDeleteCount.put("p1", 1);
        partitionToFileDeleteCount.put("p2", 1);
        for (i = 2; i < 5; ++i) {
            String cleanInstant = this.metaClient.createNewInstantTime();
            instants.add(Pair.of((Object)cleanInstant, (Object)"clean"));
            this.testTable.doClean(cleanInstant, partitionToFileDeleteCount);
        }
        for (i = 5; i <= 11; i += 2) {
            String commitInstant1 = this.metaClient.createNewInstantTime();
            instants.add(Pair.of((Object)commitInstant1, (Object)"commit"));
            this.testTable.doWriteOperation(commitInstant1, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            try {
                String rollbackInstant = this.metaClient.createNewInstantTime();
                this.testTable.doRollback(commitInstant1, rollbackInstant);
                instants.add(Pair.of((Object)rollbackInstant, (Object)"rollback"));
                continue;
            }
            catch (HoodieMetadataException rollbackInstant) {
                // empty catch block
            }
        }
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List allCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        boolean archived = true;
        MatcherAssert.assertThat((String)"The archived commits number is not as expected", (Object)(allCommits.size() - commitsAfterArchival.size()), (Matcher)CoreMatchers.is((Object)1));
        List<HoodieInstant> expectedArchiveInstants = instants.subList(0, 1).stream().map(p -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, (String)p.getValue(), (String)p.getKey())).collect(Collectors.toList());
        List<HoodieInstant> expectedActiveInstants = instants.subList(1, instants.size()).stream().map(p -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, (String)p.getValue(), (String)p.getKey())).collect(Collectors.toList());
        this.verifyArchival(expectedArchiveInstants, expectedActiveInstants, commitsAfterArchival, false);
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void testArchiveCompletedRollbackAndClean(boolean isEmpty, boolean enableMetadataTable) throws Exception {
        this.init();
        int minInstantsToKeep = 2;
        int maxInstantsToKeep = 10;
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).forTable("test-trip-table").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(minInstantsToKeep, maxInstantsToKeep).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadataTable).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        int startInstant = 1;
        List<Object> expectedArchivedInstants = new ArrayList<HoodieInstant>();
        int i = 0;
        while (i < maxInstantsToKeep + 1) {
            this.createCleanMetadata(String.format("%02d", startInstant), false, false, isEmpty || i % 2 == 0);
            expectedArchivedInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clean", String.format("%02d", startInstant)));
            ++i;
            ++startInstant;
        }
        i = 0;
        while (i < maxInstantsToKeep + 1) {
            this.createCommitAndRollbackFile(startInstant + 1 + "", startInstant + "", false, isEmpty || i % 2 == 0);
            expectedArchivedInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "rollback", String.format("%02d", startInstant)));
            ++i;
            startInstant += 2;
        }
        this.createCleanMetadata(String.format("%02d", startInstant), false, false, isEmpty);
        if (enableMetadataTable) {
            HoodieTestUtils.createCompactionCommitInMetadataTable((StorageConfiguration)this.storageConf, (String)this.basePath, (String)Integer.toString(99));
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        Stream currentInstants = this.metaClient.getActiveTimeline().reload().getInstantsAsStream();
        Map<Object, List<HoodieInstant>> actionInstantMap = currentInstants.collect(Collectors.groupingBy(HoodieInstant::getAction));
        Assertions.assertTrue((boolean)actionInstantMap.containsKey("commit"), (String)"Commit Action key must be preset");
        Assertions.assertEquals((int)minInstantsToKeep, (int)actionInstantMap.get("commit").size(), (String)"Should have min instant");
        Assertions.assertTrue((boolean)actionInstantMap.containsKey("rollback"), (String)"Rollback Action key must be preset");
        Assertions.assertEquals((int)minInstantsToKeep, (int)actionInstantMap.get("rollback").size(), (String)"Should have min instant");
        this.metaClient.getArchivedTimeline().loadCompletedInstantDetailsInMemory();
        HoodieInstant firstInstant = (HoodieInstant)this.metaClient.reloadActiveTimeline().firstInstant().get();
        expectedArchivedInstants = expectedArchivedInstants.stream().filter(entry -> InstantComparison.compareTimestamps((String)entry.requestedTime(), (BiPredicate)InstantComparison.LESSER_THAN, (String)firstInstant.requestedTime())).collect(Collectors.toList());
        expectedArchivedInstants.forEach(entry -> Assertions.assertTrue((boolean)this.metaClient.getArchivedTimeline().containsInstant(entry)));
    }

    @Test
    public void testArchiveTableWithMetadataTableCompaction() throws Exception {
        String instant;
        int i;
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 4, 5, 7);
        ArrayList<String> instants = new ArrayList<String>();
        for (int i2 = 1; i2 < 7; ++i2) {
            String instant2 = this.metaClient.createNewInstantTime();
            instants.add(instant2);
            this.testTable.doWriteOperation(instant2, WriteOperationType.UPSERT, i2 == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        String instant7 = this.metaClient.createNewInstantTime();
        instants.add(instant7);
        this.testTable.doWriteOperation(instant7, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
        List originalCommits = (List)commitsList.getKey();
        List commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)3);
        this.verifyArchival(this.getAllArchivedCommitInstants(instants.subList(0, 3)), this.getActiveCommitInstants(instants.subList(3, 7)), commitsAfterArchival, false);
        for (i = 0; i < 3; ++i) {
            instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)3);
        this.verifyArchival(this.getAllArchivedCommitInstants(instants.subList(0, 6)), this.getActiveCommitInstants(instants.subList(6, 10)), commitsAfterArchival, false);
        for (i = 0; i < 2; ++i) {
            instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        }
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        this.verifyArchival(this.getAllArchivedCommitInstants(instants.subList(0, 6)), this.getActiveCommitInstants(instants.subList(6, 12)), commitsAfterArchival, false);
        String instant13 = this.metaClient.createNewInstantTime();
        instants.add(instant13);
        this.testTable.doWriteOperation(instant13, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        String instant14 = this.metaClient.createNewInstantTime();
        instants.add(instant14);
        this.testTable.doWriteOperation(instant14, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
        commitsList = this.archiveAndGetCommitsList(writeConfig);
        originalCommits = (List)commitsList.getKey();
        commitsAfterArchival = (List)commitsList.getValue();
        Assertions.assertEquals((int)(originalCommits.size() - commitsAfterArchival.size()), (int)4);
        this.verifyArchival(this.getAllArchivedCommitInstants(instants.subList(0, 10)), this.getActiveCommitInstants(instants.subList(10, 14)), commitsAfterArchival, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchivalWithMaxDeltaCommitsGuaranteeForCompaction(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 8, 1, HoodieTableType.MERGE_ON_READ);
        ArrayList<String> instants = new ArrayList<String>();
        for (int i = 1; i < 10; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)1, (int)(originalCommits.size() - commitsAfterArchival.size()));
            Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(0))));
            IntStream.range(2, 10).forEach(j -> Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
        }
        String compactionInstant = this.metaClient.createNewInstantTime();
        instants.add(compactionInstant);
        this.testTable.doCompaction(compactionInstant, Arrays.asList("p1", "p2"));
        for (int i = 1; i < 10; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            if (i <= 2) {
                IntStream.range(1, 8).forEach(j -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                Assertions.assertEquals((int)(i == 1 ? 6 : 0), (int)(originalCommits.size() - commitsAfterArchival.size()));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(7))));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(8))));
                Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", compactionInstant)));
                for (int j2 = 1; j2 <= i; ++j2) {
                    Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(9 + j2))));
                }
                continue;
            }
            IntStream.range(1, 10).forEach(j -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
            if (i == 3) {
                Assertions.assertEquals((int)2, (int)(originalCommits.size() - commitsAfterArchival.size()));
                continue;
            }
            if (i < 8) {
                Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
                continue;
            }
            Assertions.assertEquals((int)1, (int)(originalCommits.size() - commitsAfterArchival.size()));
            Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", compactionInstant)));
            if (i == 9) {
                Assertions.assertFalse((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(10))));
            }
            IntStream.range(i - 7, i + 1).forEach(j -> Assertions.assertTrue((boolean)commitsAfterArchival.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(9 + j)))));
        }
    }

    @Test
    public void testGetCommitInstantsToArchiveDuringInflightCommits() throws Exception {
        String instantTime;
        int i;
        HoodieWriteConfig cfg = this.initTestTableAndGetWriteConfig(false, 3, 4, 2);
        HashSet<String> expectedInstants = new HashSet<String>();
        for (int i2 = 0; i2 < 3; ++i2) {
            String instantTime2 = "100" + i2;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime2, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime2);
        }
        String replaceInstant = "1003";
        HoodieTestDataGenerator.createReplaceCommitRequestedFile((String)this.basePath, (String)replaceInstant, (StorageConfiguration)this.storageConf);
        expectedInstants.add(replaceInstant);
        for (i = 4; i < 7; ++i) {
            instantTime = "100" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime);
        }
        HoodieTestDataGenerator.createRequestedCommitFile((String)this.basePath, (String)"1007", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createPendingCommitFile((String)this.basePath, (String)"1007", (StorageConfiguration)this.storageConf);
        expectedInstants.add("1007");
        for (i = 0; i < 6; ++i) {
            instantTime = "101" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
            expectedInstants.add(instantTime);
        }
        HoodieTimeline timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"Loaded 14 commits and the count should match");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        expectedInstants.remove("1000");
        expectedInstants.remove("1001");
        timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        Assertions.assertEquals((int)12, (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        HoodieTimeline finalTimeline = timeline;
        Assertions.assertEquals((long)12L, (long)expectedInstants.stream().filter(instant -> finalTimeline.containsInstant(instant)).count());
        Assertions.assertEquals((Object)"1002", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).requestedTime());
        StoragePath replaceCommitRequestedPath = new StoragePath(this.basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedReplaceFileName(replaceInstant));
        this.metaClient.getStorage().deleteDirectory(replaceCommitRequestedPath);
        this.metaClient.reloadActiveTimeline();
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        timeline = this.metaClient.reloadActiveTimeline().getWriteTimeline();
        expectedInstants.removeAll(Arrays.asList("1002", "1003", "1004", "1005"));
        Assertions.assertEquals((int)8, (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        Assertions.assertEquals((int)expectedInstants.size(), (int)timeline.countInstants(), (String)"After archival only first 2 commits should be archived");
        HoodieTimeline refreshedTimeline = timeline;
        Assertions.assertEquals((long)8L, (long)expectedInstants.stream().filter(instant -> refreshedTimeline.containsInstant(instant)).count());
        Assertions.assertEquals((Object)"1006", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).requestedTime());
    }

    @Test
    public void testWithOldestReplaceCommit() throws Exception {
        HoodieWriteConfig cfg = this.initTestTableAndGetWriteConfig(false, 2, 3, 2);
        HoodieTestDataGenerator.createReplaceCommitRequestedFile((String)this.basePath, (String)"1001", (StorageConfiguration)this.storageConf);
        HoodieTestDataGenerator.createReplaceCommitInflightFile((String)this.basePath, (String)"1001", (StorageConfiguration)this.storageConf);
        for (int i = 2; i < 10; ++i) {
            String instantTime = "100" + i;
            HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)instantTime, (StorageConfiguration)this.storageConf);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(cfg, (HoodieTable)table);
        HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)9, (int)timeline.countInstants(), (String)"Loaded 9 commits and the count should match");
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        timeline = this.metaClient.reloadActiveTimeline();
        Assertions.assertEquals((int)9, (int)timeline.countInstants(), (String)"Since we have a pending replacecommit at 1001, we should never archive any commit after 1001");
        Assertions.assertEquals((Object)"1001", (Object)((HoodieInstant)timeline.getInstantsAsStream().findFirst().get()).requestedTime());
    }

    @Test
    public void testArchivalAndCompactionInMetadataTable() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 6).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(8).withMetadataIndexColumnStats(false).build()).forTable("test-trip-table").build();
        this.initWriteConfigAndMetatableWriter(writeConfig, true);
        HoodieTableMetaClient metadataTableMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath));
        ArrayList<String> instants = new ArrayList<String>();
        for (int i = 1; i <= 19; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            if (i != 2) {
                this.testTable.doWriteOperation(instant, WriteOperationType.UPSERT, i == 1 ? Arrays.asList("p1", "p2") : Collections.emptyList(), Arrays.asList("p1", "p2"), 2);
            } else {
                this.testTable.doRollback((String)instants.get(0), instant);
            }
            this.archiveAndGetCommitsList(writeConfig);
            metadataTableMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metadataTableMetaClient);
            List metadataTableInstants = metadataTableMetaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().getInstants();
            String mdtInitCommit = HoodieInstantTimeGenerator.instantTimePlusMillis((String)"00000000000000", (long)0L);
            if (i == 1) {
                Assertions.assertEquals((int)(i + 1), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", mdtInitCommit)));
                Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(0))));
                continue;
            }
            if (i == 2) {
                Assertions.assertEquals((int)(i - 1), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", mdtInitCommit)));
                Assertions.assertFalse((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(1))));
                continue;
            }
            if (i <= 9) {
                Assertions.assertEquals((int)(i - 1), (int)metadataTableInstants.size());
                Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", mdtInitCommit)));
                IntStream.range(3, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                continue;
            }
            if (i == 10) {
                Assertions.assertEquals((int)9, (int)metadataTableInstants.size());
                IntStream.range(3, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                continue;
            }
            if (i <= 13) {
                Assertions.assertEquals((int)(i - 5), (int)metadataTableInstants.size());
                Assertions.assertEquals((int)1, (int)metadataTableMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants());
                IntStream.range(7, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                continue;
            }
            if (i <= 17) {
                Assertions.assertEquals((int)(i - 8), (int)metadataTableInstants.size());
                Assertions.assertEquals((int)1, (int)metadataTableMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants());
                IntStream.range(10, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                continue;
            }
            if (i == 18) {
                Assertions.assertEquals((int)11, (int)metadataTableInstants.size());
                Assertions.assertEquals((int)2, (int)metadataTableMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants());
                IntStream.range(10, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
                continue;
            }
            Assertions.assertEquals((int)6, (int)metadataTableInstants.size());
            Assertions.assertTrue((boolean)this.metadata(writeConfig, (HoodieEngineContext)this.context).getLatestCompactionTime().isPresent());
            IntStream.range(15, i).forEach(j -> Assertions.assertTrue((boolean)metadataTableInstants.contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", (String)instants.get(j - 1)))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPendingClusteringAfterArchiveCommit(boolean enableMetadata) throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(enableMetadata, 4, 5, 2);
        HoodieTestDataGenerator.createPendingClusterFile((String)this.basePath, (String)"00000002", (StorageConfiguration)this.storageConf);
        for (int i = 1; i < 8; ++i) {
            if (i != 2) {
                this.testTable.doWriteOperation("0000000" + i, WriteOperationType.CLUSTER, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2);
            }
            Pair<List<HoodieInstant>, List<HoodieInstant>> commitsList = this.archiveAndGetCommitsList(writeConfig);
            List originalCommits = (List)commitsList.getKey();
            List commitsAfterArchival = (List)commitsList.getValue();
            Assertions.assertEquals((Object)originalCommits, (Object)commitsAfterArchival);
        }
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().reload().getCommitsTimeline().filterCompletedInstants();
        Assertions.assertEquals((int)6, (int)timeline.countInstants(), (String)"Since we have a pending clustering instant at 00000002, we should never archive any commit after 00000000");
    }

    @Test
    public void testRetryArchivalAfterPreviousFailedDeletion() throws Exception {
        HoodieWriteConfig writeConfig = this.initTestTableAndGetWriteConfig(true, 2, 4, 2);
        for (int i = 0; i <= 5; ++i) {
            this.testTable.doWriteOperation("10" + i, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), 1);
        }
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(writeConfig, (HoodieTable)table);
        HoodieTimeline timeline = this.metaClient.getActiveTimeline().getWriteTimeline();
        Assertions.assertEquals((int)6, (int)timeline.countInstants(), (String)"Loaded 6 commits and the count should match");
        Assertions.assertTrue((archiver.archiveIfRequired((HoodieEngineContext)this.context) > 0 ? 1 : 0) != 0);
        HoodieTestDataGenerator.createOnlyCompletedCommitFile((String)this.basePath, (String)"101_1001", (StorageConfiguration)this.storage.getConf());
        HoodieTestDataGenerator.createOnlyCompletedCommitFile((String)this.basePath, (String)"102_1021", (StorageConfiguration)this.storage.getConf());
        HoodieTestDataGenerator.createOnlyCompletedCommitFile((String)this.basePath, (String)"103_1031", (StorageConfiguration)this.storage.getConf());
        timeline = this.metaClient.getActiveTimeline().reload().getWriteTimeline();
        Assertions.assertEquals((int)5, (int)timeline.countInstants(), (String)"Due to simulating partial archival deletion, there shouldbe 5 instants (as instant times 101-103 .commit files should remain in timeline)");
        table.getMetaClient().reloadActiveTimeline();
        table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        archiver = new TimelineArchiverV2(writeConfig, (HoodieTable)table);
        Assertions.assertTrue((archiver.archiveIfRequired((HoodieEngineContext)this.context) > 0 ? 1 : 0) != 0);
        timeline = this.metaClient.getActiveTimeline().reload().getWriteTimeline();
        Assertions.assertEquals((int)2, (int)timeline.countInstants(), (String)"The instants from prior archival should be deleted now");
    }

    private Pair<List<HoodieInstant>, List<HoodieInstant>> archiveAndGetCommitsList(HoodieWriteConfig writeConfig) throws IOException {
        return this.archiveAndGetCommitsList(writeConfig, false);
    }

    private Pair<List<HoodieInstant>, List<HoodieInstant>> archiveAndGetCommitsList(HoodieWriteConfig writeConfig, boolean includeIncompleteInstants) throws IOException {
        this.metaClient.reloadActiveTimeline();
        HoodieTimeline timeline = includeIncompleteInstants ? this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline() : this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline().filterCompletedInstants();
        List originalCommits = timeline.getInstants();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        TimelineArchiverV2 archiver = new TimelineArchiverV2(writeConfig, (HoodieTable)table);
        archiver.archiveIfRequired((HoodieEngineContext)this.context);
        timeline = includeIncompleteInstants ? this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline() : this.metaClient.getActiveTimeline().reload().getAllCommitsTimeline().filterCompletedInstants();
        List commitsAfterArchival = timeline.getInstants();
        return Pair.of((Object)originalCommits, (Object)commitsAfterArchival);
    }

    private void verifyArchival(List<HoodieInstant> expectedArchivedInstants, List<HoodieInstant> expectedActiveInstants, List<HoodieInstant> commitsAfterArchival, boolean isArchivalBeyondSavepoint) {
        expectedActiveInstants.sort(Comparator.comparing(HoodieInstant::requestedTime));
        commitsAfterArchival.sort(Comparator.comparing(HoodieInstant::requestedTime));
        Assertions.assertEquals(expectedActiveInstants, commitsAfterArchival);
        expectedArchivedInstants.forEach(entry -> Assertions.assertFalse((boolean)commitsAfterArchival.contains(entry)));
        HoodieArchivedTimeline archivedTimeline = HoodieTestUtils.TIMELINE_FACTORY.createArchivedTimeline(this.metaClient);
        List actualArchivedInstants = archivedTimeline.getInstants();
        actualArchivedInstants.sort(Comparator.comparing(HoodieInstant::requestedTime));
        expectedArchivedInstants.sort(Comparator.comparing(HoodieInstant::requestedTime));
        Assertions.assertEquals((Object)actualArchivedInstants, expectedArchivedInstants);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        expectedArchivedInstants.forEach(arg_0 -> TestHoodieTimelineArchiver.lambda$verifyArchival$28(isArchivalBeyondSavepoint, (HoodieTimeline)timeline, arg_0));
    }

    private List<HoodieInstant> getAllArchivedCommitInstants(List<String> commitTimes) {
        return this.getAllArchivedCommitInstants(commitTimes, "commit");
    }

    private List<HoodieInstant> getAllArchivedCommitInstants(List<String> commitTimes, String action) {
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        commitTimes.forEach(commitTime -> allInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, action, commitTime)));
        return allInstants;
    }

    private List<HoodieInstant> getActiveCommitInstants(List<String> commitTimes) {
        return this.getActiveCommitInstants(commitTimes, "commit");
    }

    private List<HoodieInstant> getActiveSavepointedCommitInstants(List<String> commitTimes) {
        return this.getActiveCommitInstants(commitTimes, "savepoint");
    }

    private List<HoodieInstant> getActiveCommitInstants(List<String> commitTimes, String action) {
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        commitTimes.forEach(entry -> allInstants.add(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, action, entry)));
        return allInstants;
    }

    private void createCommitAndRollbackFile(String commitToRollback, String rollbackTIme, boolean isRollbackInflight) throws IOException {
        this.createCommitAndRollbackFile(commitToRollback, rollbackTIme, isRollbackInflight, false);
    }

    private void createCommitAndRollbackFile(String commitToRollback, String rollbackTIme, boolean isRollbackInflight, boolean isEmpty) throws IOException {
        HoodieTestDataGenerator.createCommitFile((String)this.basePath, (String)commitToRollback, (StorageConfiguration)this.storageConf);
        this.createRollbackMetadata(rollbackTIme, commitToRollback, isRollbackInflight, isEmpty);
    }

    private HoodieInstant createRollbackMetadata(String rollbackTime, String commitToRollback, boolean inflight, boolean isEmpty) throws IOException {
        if (inflight) {
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightRollback(rollbackTime);
        } else {
            HoodieRollbackMetadata hoodieRollbackMetadata = HoodieRollbackMetadata.newBuilder().setVersion(Integer.valueOf(1)).setStartRollbackTime(rollbackTime).setTotalFilesDeleted(1).setTimeTakenInMillis(1000L).setCommitsRollback(Collections.singletonList(commitToRollback)).setPartitionMetadata(Collections.emptyMap()).setInstantsRollback(Collections.emptyList()).build();
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollback(rollbackTime, hoodieRollbackMetadata, isEmpty, null);
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRollbackCompleted(rollbackTime, hoodieRollbackMetadata, isEmpty);
        }
        return HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(inflight ? HoodieInstant.State.INFLIGHT : HoodieInstant.State.COMPLETED, "rollback", rollbackTime);
    }

    private void assertInstantListEquals(List<HoodieInstant> expected, List<HoodieInstant> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            HoodieInstant expectedInstant = expected.get(i);
            HoodieInstant actualInstant = actual.get(i);
            Assertions.assertEquals((Object)expectedInstant.requestedTime(), (Object)actualInstant.requestedTime());
            Assertions.assertEquals((Object)expectedInstant.getAction(), (Object)actualInstant.getAction());
            Assertions.assertEquals((Object)expectedInstant.getState(), (Object)actualInstant.getState());
        }
    }

    private static /* synthetic */ void lambda$verifyArchival$28(boolean isArchivalBeyondSavepoint, HoodieTimeline timeline, HoodieInstant entry) {
        if (!entry.getAction().equals("rollback") && !isArchivalBeyondSavepoint) {
            Assertions.assertTrue((boolean)timeline.containsOrBeforeTimelineStarts(entry.requestedTime()), (String)"Archived commits should always be safe");
        }
    }
}

