/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSliceInfo;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.timeline.versioning.v2.TimelineArchiverV2;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataMigrator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanMigrator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV1MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieCleanerTestBase;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Tuple3;

public class TestCleaner
extends HoodieCleanerTestBase {
    private static final int BIG_BATCH_INSERT_SIZE = 500;
    private static final int PARALLELISM = 10;

    public static Pair<String, JavaRDD<WriteStatus>> insertFirstBigBatchForClientCleanerTest(HoodieSparkEngineContext context, HoodieTableMetaClient metaClient, SparkRDDWriteClient client, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> insertFn) throws Exception {
        String newCommitTime = client.startCommit();
        List records = (List)recordGenFunction.apply((Object)newCommitTime, (Object)500);
        JavaRDD writeRecords = context.getJavaSparkContext().parallelize(records, 10);
        JavaRDD statuses = (JavaRDD)insertFn.apply((Object)client, (Object)writeRecords, (Object)newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        HoodieTimeline timeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(metaClient).getCommitAndReplaceTimeline();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.findInstantsAfter("000", Integer.MAX_VALUE).countInstants(), (String)"Expecting a single commit.");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)context, (HoodieTableMetaClient)metaClient);
        if (client.getConfig().shouldAutoCommit().booleanValue()) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)table.getCompletedCommitsTimeline().empty());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)table.getCompletedCleanTimeline().empty());
        if (client.getConfig().shouldAutoCommit().booleanValue()) {
            HoodieIndex index = SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)client.getConfig());
            List taggedRecords = TestCleaner.tagLocation(index, (HoodieEngineContext)context, (JavaRDD<HoodieRecord>)context.getJavaSparkContext().parallelize(records, 10), (HoodieTable)table).collect();
            TestCleaner.checkTaggedRecords(taggedRecords, newCommitTime);
        }
        return Pair.of((Object)newCommitTime, (Object)statuses);
    }

    public static Pair<String, JavaRDD<WriteStatus>> insertFirstFailedBigBatchForClientCleanerTest(HoodieSparkEngineContext context, SparkRDDWriteClient client, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> insertFn) throws Exception {
        String newCommitTime = client.startCommit();
        List records = (List)recordGenFunction.apply((Object)newCommitTime, (Object)500);
        JavaRDD writeRecords = context.getJavaSparkContext().parallelize(records, 5);
        JavaRDD statuses = (JavaRDD)insertFn.apply((Object)client, (Object)writeRecords, (Object)newCommitTime);
        Assertions.assertNoWriteErrors((List)statuses.collect());
        client.getHeartbeatClient().stop(newCommitTime);
        return Pair.of((Object)newCommitTime, (Object)statuses);
    }

    @Test
    public void testInsertAndCleanFailedWritesByVersions() throws Exception {
        this.testInsertAndCleanFailedWritesByVersions((HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false);
    }

    private void testInsertAndCleanFailedWritesByVersions(HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> insertFn, boolean isPreppedAPI) throws Exception {
        int maxVersions = 3;
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withHeartbeatIntervalInMs(Integer.valueOf(3000)).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(maxVersions).build()).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordInsertGenWrappedFunction = this.generateWrapRecordsFn(isPreppedAPI, cfg, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)));
            Pair<String, JavaRDD<WriteStatus>> result = TestCleaner.insertFirstBigBatchForClientCleanerTest(this.context, this.metaClient, client, recordInsertGenWrappedFunction, insertFn);
            client.commit((String)result.getLeft(), result.getRight());
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)table.getCompletedCleanTimeline().empty());
            TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
            TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
            Pair<String, JavaRDD<WriteStatus>> ret = TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> client.getHeartbeatClient().isHeartbeatExpired((String)ret.getLeft()));
            List<HoodieCleanStat> cleanStats = this.runCleaner(cfg);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cleanStats.size(), (String)"Must not clean any files");
            HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertTrue((timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).filterCompletedInstants().countInstants() == 3 ? 1 : 0) != 0);
            Option rollBackInstantForFailedCommit = timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).filterCompletedInstants().lastInstant();
            HoodieRollbackMetadata rollbackMetadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)rollBackInstantForFailedCommit.get()).get()), HoodieRollbackMetadata.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)rollbackMetadata.getTotalFilesDeleted());
        }
    }

    @Test
    public void testEarliestInstantToRetainForPendingCompaction() throws IOException {
        HoodieWriteConfig writeConfig = this.getConfigBuilder().withPath(this.basePath).withFileSystemViewConfig(new FileSystemViewStorageConfig.Builder().withEnableBackupForRemoteFileSystemView(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withAutoClean(Boolean.valueOf(false)).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).compactionSmallFileSize(0x40000000L).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().withAutoArchive(Boolean.valueOf(false)).archiveCommitsWith(2, 3).build()).withEmbeddedTimelineServerEnabled(false).build();
        HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, writeConfig);){
            String partition1 = "2023/06/01";
            String partition2 = "2023/06/02";
            String instantTime = "";
            String earliestInstantToRetain = "";
            for (int idx = 0; idx < 3; ++idx) {
                instantTime = client.createNewInstantTime();
                if (idx == 2) {
                    earliestInstantToRetain = instantTime;
                }
                List records = this.dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(1), "2023/06/01");
                client.startCommitWithTime(instantTime);
                client.insert(this.jsc.parallelize(records, 1), instantTime).collect();
            }
            instantTime = client.createNewInstantTime();
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
            Option cleanPlan = table.scheduleCleaning((HoodieEngineContext)this.context, instantTime, Option.empty());
            org.junit.jupiter.api.Assertions.assertEquals((int)((List)((HoodieCleanerPlan)cleanPlan.get()).getFilePathsToBeDeletedPerPartition().get("2023/06/01")).size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)earliestInstantToRetain, (Object)((HoodieCleanerPlan)cleanPlan.get()).getEarliestInstantToRetain().getTimestamp(), (String)("clean until " + earliestInstantToRetain));
            table.getMetaClient().reloadActiveTimeline();
            table.clean((HoodieEngineContext)this.context, instantTime);
            instantTime = client.createNewInstantTime();
            List records = this.dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(1), "2023/06/01");
            client.startCommitWithTime(instantTime);
            JavaRDD recordsRDD = this.jsc.parallelize(records, 1);
            client.insert(recordsRDD, instantTime).collect();
            earliestInstantToRetain = instantTime = client.createNewInstantTime();
            List updatedRecords = this.dataGen.generateUpdates(instantTime, records);
            JavaRDD updatedRecordsRDD = this.jsc.parallelize(updatedRecords, 1);
            SparkRDDReadClient readClient = new SparkRDDReadClient(this.context, writeConfig);
            JavaRDD updatedTaggedRecordsRDD = readClient.tagLocation(updatedRecordsRDD);
            client.startCommitWithTime(instantTime);
            client.upsertPreppedRecords(updatedTaggedRecordsRDD, instantTime).collect();
            table.getMetaClient().reloadActiveTimeline();
            String compactionInstantTime = client.scheduleCompaction(Option.empty()).get().toString();
            for (int idx = 0; idx < 3; ++idx) {
                instantTime = client.createNewInstantTime();
                records = this.dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(1), "2023/06/02");
                client.startCommitWithTime(instantTime);
                client.insert(this.jsc.parallelize(records, 1), instantTime).collect();
            }
            instantTime = client.createNewInstantTime();
            cleanPlan = table.scheduleCleaning((HoodieEngineContext)this.context, instantTime, Option.empty());
            org.junit.jupiter.api.Assertions.assertEquals((Object)earliestInstantToRetain, (Object)((HoodieCleanerPlan)cleanPlan.get()).getEarliestInstantToRetain().getTimestamp());
        }
    }

    @Test
    public void testCleanNonPartitionedTable() throws IOException {
        HoodieWriteConfig writeConfig = this.getConfigBuilder().withPath(this.basePath).withFileSystemViewConfig(new FileSystemViewStorageConfig.Builder().withEnableBackupForRemoteFileSystemView(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withAutoClean(Boolean.valueOf(false)).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build()).withEmbeddedTimelineServerEnabled(false).build();
        this.initTestDataGenerator(new String[]{""});
        HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (HoodieFileFormat)HoodieFileFormat.PARQUET, (boolean)true, (String)"org.apache.hudi.keygen.NonpartitionedKeyGenerator", (boolean)true);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, writeConfig);){
            String instantTime;
            for (int idx = 0; idx < 3; ++idx) {
                instantTime = client.createNewInstantTime();
                List records = this.dataGen.generateInserts(instantTime, Integer.valueOf(1));
                client.startCommitWithTime(instantTime);
                client.insert(this.jsc.parallelize(records, 1), instantTime).collect();
            }
            instantTime = client.createNewInstantTime();
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
            Option cleanPlan = table.scheduleCleaning((HoodieEngineContext)this.context, instantTime, Option.empty());
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanerPlan)cleanPlan.get()).getPartitionsToBeDeleted().size(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)((List)((HoodieCleanerPlan)cleanPlan.get()).getFilePathsToBeDeletedPerPartition().get("")).size(), (int)1);
            table.getMetaClient().reloadActiveTimeline();
            String filePathToClean = ((HoodieCleanFileInfo)((List)((HoodieCleanerPlan)cleanPlan.get()).getFilePathsToBeDeletedPerPartition().get("")).get(0)).getFilePath();
            HoodieCleanMetadata cleanMetadata = table.clean((HoodieEngineContext)this.context, instantTime);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("")).getSuccessDeleteFiles().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)filePathToClean.contains((CharSequence)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("")).getSuccessDeleteFiles().get(0)));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FSUtils.isTableExists((String)this.basePath, (HoodieStorage)this.storage));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)table.getFileSystemView().getAllFileGroups("").findAny().isPresent());
        }
    }

    @Test
    public void testMultiClean() {
        int index;
        HoodieWriteConfig writeConfig = this.getConfigBuilder().withFileSystemViewConfig(new FileSystemViewStorageConfig.Builder().withEnableBackupForRemoteFileSystemView(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).allowMultipleCleans(false).withAutoClean(Boolean.valueOf(false)).retainCommits(1).retainFileVersions(1).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withEmbeddedTimelineServerEnabled(false).build();
        String partition = "2015/03/16";
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, writeConfig);){
            for (index = 0; index < 3; ++index) {
                String newCommitTime = "00" + index;
                List records = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(1), "2015/03/16");
                client.startCommitWithTime(newCommitTime);
                client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            }
        }
        String cleanInstantTime = "00" + index++;
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);
        Option cleanPlan = table.scheduleCleaning((HoodieEngineContext)this.context, cleanInstantTime, Option.empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)((List)((HoodieCleanerPlan)cleanPlan.get()).getFilePathsToBeDeletedPerPartition().get("2015/03/16")).size(), (int)1);
        org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().countInstants(), (int)1);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, writeConfig);){
            String newCommitTime = "00" + index++;
            List records = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(1), "2015/03/16");
            client.startCommitWithTime(newCommitTime);
            client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            String newCleanInstantTime = "00" + index++;
            HoodieCleanMetadata cleanMetadata = client.clean(newCleanInstantTime);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cleanMetadata);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterCompletedInstants().containsInstant(cleanInstantTime));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getActiveTimeline().getCleanerTimeline().containsInstant(newCleanInstantTime));
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getSuccessDeleteFiles().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getFailedDeleteFiles().size(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getDeletePathPatterns().size(), (int)1);
            cleanMetadata = client.clean(newCleanInstantTime);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cleanMetadata);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.reloadActiveTimeline().getCleanerTimeline().containsInstant(newCleanInstantTime));
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getSuccessDeleteFiles().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getFailedDeleteFiles().size(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getDeletePathPatterns().size(), (int)1);
        }
    }

    @Test
    public void testFailedInsertAndCleanByCommits() throws Exception {
        this.testFailedInsertAndCleanByCommits((HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String>)((HoodieWriterClientTestHarness.Function3)SparkRDDWriteClient::insert), false);
    }

    private void testFailedInsertAndCleanByCommits(HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> insertFn, boolean isPreppedAPI) throws Exception {
        int maxCommits = 3;
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withHeartbeatIntervalInMs(Integer.valueOf(3000)).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(maxCommits).build()).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordInsertGenWrappedFunction = this.generateWrapRecordsFn(isPreppedAPI, cfg, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)));
        Pair<String, JavaRDD<WriteStatus>> result = TestCleaner.insertFirstBigBatchForClientCleanerTest(this.context, this.metaClient, client, recordInsertGenWrappedFunction, insertFn);
        client.commit((String)result.getLeft(), result.getRight());
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)table.getCompletedCleanTimeline().empty());
        TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
        TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
        Pair<String, JavaRDD<WriteStatus>> ret = TestCleaner.insertFirstFailedBigBatchForClientCleanerTest(this.context, client, recordInsertGenWrappedFunction, insertFn);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> client.getHeartbeatClient().isHeartbeatExpired((String)ret.getLeft()));
        List<HoodieCleanStat> cleanStats = this.runCleaner(cfg);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cleanStats.size(), (String)"Must not clean any files");
        HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertTrue((timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).filterCompletedInstants().countInstants() == 3 ? 1 : 0) != 0);
        Option rollBackInstantForFailedCommit = timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).filterCompletedInstants().lastInstant();
        HoodieRollbackMetadata rollbackMetadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)rollBackInstantForFailedCommit.get()).get()), HoodieRollbackMetadata.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)rollbackMetadata.getTotalFilesDeleted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanEmptyInstants() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).build()).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        int commitCount = 20;
        int cleanCount = 20;
        int startInstant = 1;
        int i = 0;
        while (i < cleanCount) {
            String commitTime = HoodieTestTable.makeNewCommitTime((int)startInstant, (String)"%09d");
            this.createEmptyCleanMetadata(commitTime + "", false);
            ++i;
            ++startInstant;
        }
        int instantClean = startInstant;
        try (HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);){
            int i2 = 0;
            while (i2 < commitCount) {
                String commitTime = HoodieTestTable.makeNewCommitTime((int)startInstant, (String)"%09d");
                this.commitWithMdt(commitTime, Collections.emptyMap(), testTable, config);
                ++i2;
                ++startInstant;
            }
            List<HoodieCleanStat> cleanStats = this.runCleaner(config);
            HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cleanStats.size(), (String)"Must not clean any files");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflightsAndRequested().countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflights().countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)(--cleanCount), (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterCompletedInstants().countInstants());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflightsAndRequested().containsInstant(HoodieTestTable.makeNewCommitTime((int)(--instantClean), (String)"%09d")));
            cleanStats = this.runCleaner(config);
            timeline = this.metaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cleanStats.size(), (String)"Must not clean any files");
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflightsAndRequested().countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflights().countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)cleanCount, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterCompletedInstants().countInstants());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).filterInflightsAndRequested().containsInstant(HoodieTestTable.makeNewCommitTime((int)(--instantClean), (String)"%09d")));
        }
    }

    @Test
    public void testCleanWithReplaceCommits() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(2).build()).build();
        HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));
        final String p0 = "2020/01/01";
        final String p1 = "2020/01/02";
        final String file1P0C0 = UUID.randomUUID().toString();
        final String file1P1C0 = UUID.randomUUID().toString();
        Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
            }
        });
        this.commitWithMdt("00000000000001", part1ToFileId, testTable, config, true, true);
        testTable = this.tearDownTestTableAndReinit(testTable, config);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleanerWithInstantFormat(config, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)hoodieCleanStatsOne.size(), (String)"Must not scan any partitions and clean any files");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        Map partitionAndFileId002 = testTable.forReplaceCommit("00000000000002").getFileIdsWithBaseFilesInPartitions(new String[]{p0});
        String file2P0C1 = (String)partitionAndFileId002.get(p0);
        Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> replaceMetadata = this.generateReplaceCommitMetadata("00000000000002", p0, file1P0C0, file2P0C1);
        testTable.addCluster("00000000000002", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
        List<HoodieCleanStat> hoodieCleanStatsTwo = this.runCleanerWithInstantFormat(config, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)hoodieCleanStatsTwo.size(), (String)"Must not scan any partitions and clean any files");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000002", file2P0C1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        Map partitionAndFileId003 = testTable.forReplaceCommit("00000000000003").getFileIdsWithBaseFilesInPartitions(new String[]{p1});
        String file3P1C2 = (String)partitionAndFileId003.get(p1);
        replaceMetadata = this.generateReplaceCommitMetadata("00000000000003", p1, file1P1C0, file3P1C2);
        testTable.addCluster("00000000000003", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
        List<HoodieCleanStat> hoodieCleanStatsThree = this.runCleanerWithInstantFormat(config, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)hoodieCleanStatsThree.size(), (String)"Must not scan any partitions and clean any files");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000002", file2P0C1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000003", file3P1C2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        Map partitionAndFileId004 = testTable.forReplaceCommit("00000000000004").getFileIdsWithBaseFilesInPartitions(new String[]{p0});
        String file4P0C3 = (String)partitionAndFileId004.get(p0);
        replaceMetadata = this.generateReplaceCommitMetadata("00000000000004", p0, file2P0C1, file4P0C3);
        testTable.addCluster("00000000000004", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
        List<HoodieCleanStat> hoodieCleanStatsFour = this.runCleaner(config, 5, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000004", file4P0C3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000002", file2P0C1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000003", file3P1C2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        Map partitionAndFileId005 = testTable.forReplaceCommit("00000000000006").getFileIdsWithBaseFilesInPartitions(new String[]{p1});
        String file4P1C4 = (String)partitionAndFileId005.get(p1);
        replaceMetadata = this.generateReplaceCommitMetadata("00000000000006", p0, file3P1C2, file4P1C4);
        testTable.addCluster("00000000000006", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
        List<HoodieCleanStat> hoodieCleanStatsFive = this.runCleaner(config, 7, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000004", file4P0C3));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000002", file2P0C1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000003", file3P1C2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
    }

    private Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> generateReplaceCommitMetadata(String instantTime, String partition, String replacedFileId, String newFileId) {
        HoodieRequestedReplaceMetadata requestedReplaceMetadata = new HoodieRequestedReplaceMetadata();
        requestedReplaceMetadata.setOperationType(WriteOperationType.CLUSTER.toString());
        requestedReplaceMetadata.setVersion(Integer.valueOf(1));
        HoodieSliceInfo sliceInfo = HoodieSliceInfo.newBuilder().setFileId(replacedFileId).build();
        ArrayList<HoodieClusteringGroup> clusteringGroups = new ArrayList<HoodieClusteringGroup>();
        clusteringGroups.add(HoodieClusteringGroup.newBuilder().setVersion(Integer.valueOf(1)).setNumOutputFileGroups(Integer.valueOf(1)).setMetrics(Collections.emptyMap()).setSlices(Collections.singletonList(sliceInfo)).build());
        requestedReplaceMetadata.setExtraMetadata(Collections.emptyMap());
        requestedReplaceMetadata.setClusteringPlan(HoodieClusteringPlan.newBuilder().setVersion(Integer.valueOf(1)).setExtraMetadata(Collections.emptyMap()).setStrategy(HoodieClusteringStrategy.newBuilder().setStrategyClassName("").setVersion(Integer.valueOf(1)).build()).setInputGroups(clusteringGroups).build());
        HoodieReplaceCommitMetadata replaceMetadata = new HoodieReplaceCommitMetadata();
        replaceMetadata.addReplaceFileId(partition, replacedFileId);
        replaceMetadata.setOperationType(WriteOperationType.CLUSTER);
        if (!StringUtils.isNullOrEmpty((String)newFileId)) {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partition);
            writeStat.setPath(partition + "/" + HoodieTestCommitGenerator.getBaseFilename((String)instantTime, (String)newFileId));
            writeStat.setFileId(newFileId);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            replaceMetadata.addWriteStat(partition, writeStat);
        }
        return Pair.of((Object)requestedReplaceMetadata, (Object)replaceMetadata);
    }

    @Test
    public void testCleanMetadataUpgradeDowngrade() {
        String instantTime = "000";
        String partition1 = HoodieTestUtils.DEFAULT_PARTITION_PATHS[0];
        String partition2 = HoodieTestUtils.DEFAULT_PARTITION_PATHS[1];
        String extension = this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        String fileName1 = "data1_1_000" + extension;
        String fileName2 = "data2_1_000" + extension;
        String filePath1 = this.metaClient.getBasePath() + "/" + partition1 + "/" + fileName1;
        String filePath2 = this.metaClient.getBasePath() + "/" + partition1 + "/" + fileName2;
        List<String> deletePathPatterns1 = Arrays.asList(filePath1, filePath2);
        List<String> successDeleteFiles1 = Collections.singletonList(filePath1);
        List<String> failedDeleteFiles1 = Collections.singletonList(filePath2);
        HoodieCleanStat cleanStat1 = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, partition1, deletePathPatterns1, successDeleteFiles1, failedDeleteFiles1, instantTime, "");
        ArrayList deletePathPatterns2 = new ArrayList();
        ArrayList successDeleteFiles2 = new ArrayList();
        ArrayList failedDeleteFiles2 = new ArrayList();
        HoodieCleanStat cleanStat2 = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_COMMITS, partition2, deletePathPatterns2, successDeleteFiles2, failedDeleteFiles2, instantTime, "");
        HashMap<String, Tuple3> oldExpected = new HashMap<String, Tuple3>();
        oldExpected.put(partition1, new Tuple3(deletePathPatterns1, successDeleteFiles1, failedDeleteFiles1));
        oldExpected.put(partition2, new Tuple3(deletePathPatterns2, successDeleteFiles2, failedDeleteFiles2));
        HashMap<String, Tuple3> newExpected = new HashMap<String, Tuple3>();
        newExpected.put(partition1, new Tuple3(Arrays.asList(fileName1, fileName2), Collections.singletonList(fileName1), Collections.singletonList(fileName2)));
        newExpected.put(partition2, new Tuple3(deletePathPatterns2, successDeleteFiles2, failedDeleteFiles2));
        HoodieCleanMetadata metadata = CleanerUtils.convertCleanMetadata((String)instantTime, (Option)Option.of((Object)0L), Arrays.asList(cleanStat1, cleanStat2), (Map)Collections.EMPTY_MAP);
        metadata.setVersion(CleanerUtils.CLEAN_METADATA_VERSION_1);
        CleanMetadataMigrator metadataMigrator = new CleanMetadataMigrator(this.metaClient);
        metadata = (HoodieCleanMetadata)metadataMigrator.upgradeToLatest((Object)metadata, metadata.getVersion().intValue());
        TestCleaner.assertCleanMetadataPathEquals(newExpected, metadata);
        CleanMetadataMigrator migrator = new CleanMetadataMigrator(this.metaClient);
        HoodieCleanMetadata oldMetadata = (HoodieCleanMetadata)migrator.migrateToVersion((Object)metadata, metadata.getVersion().intValue(), CleanerUtils.CLEAN_METADATA_VERSION_1.intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Integer)CleanerUtils.CLEAN_METADATA_VERSION_1, (Integer)oldMetadata.getVersion());
        TestCleaner.assertCleanMetadataEquals(metadata, oldMetadata);
        TestCleaner.assertCleanMetadataPathEquals(oldExpected, oldMetadata);
        HoodieCleanMetadata newMetadata = (HoodieCleanMetadata)migrator.upgradeToLatest((Object)oldMetadata, oldMetadata.getVersion().intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Integer)CleanerUtils.LATEST_CLEAN_METADATA_VERSION, (Integer)newMetadata.getVersion());
        TestCleaner.assertCleanMetadataEquals(oldMetadata, newMetadata);
        TestCleaner.assertCleanMetadataPathEquals(newExpected, newMetadata);
        TestCleaner.assertCleanMetadataPathEquals(oldExpected, oldMetadata);
    }

    private static void assertCleanMetadataEquals(HoodieCleanMetadata expected, HoodieCleanMetadata actual) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.getEarliestCommitToRetain(), (Object)actual.getEarliestCommitToRetain());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected.getStartCleanTime(), (Object)actual.getStartCleanTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)expected.getTimeTakenInMillis(), (long)actual.getTimeTakenInMillis());
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.getTotalFilesDeleted(), (int)actual.getTotalFilesDeleted());
        Map map1 = expected.getPartitionMetadata();
        Map map2 = actual.getPartitionMetadata();
        org.junit.jupiter.api.Assertions.assertEquals(map1.keySet(), map2.keySet());
        List partitions1 = map1.values().stream().map(HoodieCleanPartitionMetadata::getPartitionPath).collect(Collectors.toList());
        List partitions2 = map2.values().stream().map(HoodieCleanPartitionMetadata::getPartitionPath).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(partitions1, partitions2);
        List policies1 = map1.values().stream().map(HoodieCleanPartitionMetadata::getPolicy).collect(Collectors.toList());
        List policies2 = map2.values().stream().map(HoodieCleanPartitionMetadata::getPolicy).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(policies1, policies2);
    }

    @Test
    public void testCleanPlanUpgradeDowngrade() {
        String instantTime = "000";
        String partition1 = HoodieTestUtils.DEFAULT_PARTITION_PATHS[0];
        String partition2 = HoodieTestUtils.DEFAULT_PARTITION_PATHS[1];
        String extension = this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        String fileName1 = "data1_1_000" + extension;
        String fileName2 = "data2_1_000" + extension;
        HashMap<String, List<String>> filesToBeCleanedPerPartition = new HashMap<String, List<String>>();
        filesToBeCleanedPerPartition.put(partition1, Arrays.asList(fileName1));
        filesToBeCleanedPerPartition.put(partition2, Arrays.asList(fileName2));
        HoodieCleanerPlan version1Plan = HoodieCleanerPlan.newBuilder().setEarliestInstantToRetain(HoodieActionInstant.newBuilder().setAction("commit").setTimestamp(instantTime).setState(HoodieInstant.State.COMPLETED.name()).build()).setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setFilesToBeDeletedPerPartition(filesToBeCleanedPerPartition).setVersion(CleanPlanV1MigrationHandler.VERSION).build();
        HoodieCleanerPlan version2Plan = (HoodieCleanerPlan)new CleanPlanMigrator(this.metaClient).upgradeToLatest((Object)version1Plan, version1Plan.getVersion().intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)version1Plan.getEarliestInstantToRetain(), (Object)version2Plan.getEarliestInstantToRetain());
        org.junit.jupiter.api.Assertions.assertEquals((Object)version1Plan.getPolicy(), (Object)version2Plan.getPolicy());
        org.junit.jupiter.api.Assertions.assertEquals((Integer)CleanPlanner.LATEST_CLEAN_PLAN_VERSION, (Integer)version2Plan.getVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)version2Plan.getFilesToBeDeletedPerPartition().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)version1Plan.getFilesToBeDeletedPerPartition().size(), (int)version2Plan.getFilePathsToBeDeletedPerPartition().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition1)).size(), (int)((List)version2Plan.getFilePathsToBeDeletedPerPartition().get(partition1)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition2)).size(), (int)((List)version2Plan.getFilePathsToBeDeletedPerPartition().get(partition2)).size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StoragePath(FSUtils.constructAbsolutePath((StoragePath)this.metaClient.getBasePath(), (String)partition1), fileName1).toString(), (Object)((HoodieCleanFileInfo)((List)version2Plan.getFilePathsToBeDeletedPerPartition().get(partition1)).get(0)).getFilePath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new StoragePath(FSUtils.constructAbsolutePath((StoragePath)this.metaClient.getBasePath(), (String)partition2), fileName2).toString(), (Object)((HoodieCleanFileInfo)((List)version2Plan.getFilePathsToBeDeletedPerPartition().get(partition2)).get(0)).getFilePath());
        HoodieCleanerPlan gotVersion1Plan = (HoodieCleanerPlan)new CleanPlanMigrator(this.metaClient).migrateToVersion((Object)version2Plan, version2Plan.getVersion().intValue(), version1Plan.getVersion().intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)version1Plan.getEarliestInstantToRetain(), (Object)gotVersion1Plan.getEarliestInstantToRetain());
        org.junit.jupiter.api.Assertions.assertEquals((Object)version1Plan.getPolicy(), (Object)version2Plan.getPolicy());
        org.junit.jupiter.api.Assertions.assertEquals((Integer)version1Plan.getVersion(), (Integer)gotVersion1Plan.getVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)version1Plan.getFilesToBeDeletedPerPartition().size(), (int)gotVersion1Plan.getFilesToBeDeletedPerPartition().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition1)).size(), (int)((List)gotVersion1Plan.getFilesToBeDeletedPerPartition().get(partition1)).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition2)).size(), (int)((List)gotVersion1Plan.getFilesToBeDeletedPerPartition().get(partition2)).size());
        org.junit.jupiter.api.Assertions.assertEquals(((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition1)).get(0), ((List)gotVersion1Plan.getFilesToBeDeletedPerPartition().get(partition1)).get(0));
        org.junit.jupiter.api.Assertions.assertEquals(((List)version1Plan.getFilesToBeDeletedPerPartition().get(partition2)).get(0), ((List)gotVersion1Plan.getFilesToBeDeletedPerPartition().get(partition2)).get(0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)gotVersion1Plan.getFilePathsToBeDeletedPerPartition().isEmpty());
        org.junit.jupiter.api.Assertions.assertNull((Object)version1Plan.getFilePathsToBeDeletedPerPartition());
    }

    private static void assertCleanMetadataPathEquals(Map<String, Tuple3> expected, HoodieCleanMetadata actual) {
        Map partitionMetadataMap = actual.getPartitionMetadata();
        for (Map.Entry entry : partitionMetadataMap.entrySet()) {
            String partitionPath = (String)entry.getKey();
            HoodieCleanPartitionMetadata partitionMetadata = (HoodieCleanPartitionMetadata)entry.getValue();
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.get(partitionPath)._1(), (Object)partitionMetadata.getDeletePathPatterns());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.get(partitionPath)._2(), (Object)partitionMetadata.getSuccessDeleteFiles());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.get(partitionPath)._3(), (Object)partitionMetadata.getFailedDeleteFiles());
        }
    }

    @Test
    public void testCleanMarkerDataFilesOnRollback() throws Exception {
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addRequestedCommit("001").withMarkerFiles("default", 10, IOType.MERGE);
        int numTempFilesBefore = testTable.listAllFilesInTempFolder().length;
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)numTempFilesBefore, (String)"Some marker files are created.");
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withPath(this.basePath).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        table.getActiveTimeline().transitionRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "001"), Option.empty());
        this.metaClient.reloadActiveTimeline();
        HoodieInstant rollbackInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "001");
        table.scheduleRollback((HoodieEngineContext)this.context, "002", rollbackInstant, false, config.shouldRollbackUsingMarkers(), false);
        table.rollback((HoodieEngineContext)this.context, "002", rollbackInstant, true, false);
        int numTempFilesAfter = testTable.listAllFilesInTempFolder().length;
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)numTempFilesAfter, (String)"All temp files are deleted.");
    }

    @Test
    public void testCleaningWithZeroPartitionPaths() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(2).build()).build();
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context));
            testTable.doWriteOperation("001", WriteOperationType.INSERT, Collections.emptyList(), 1);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            List<HoodieCleanStat> hoodieCleanStatsOne = this.runCleaner(config);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)hoodieCleanStatsOne.isEmpty(), (String)"HoodieCleanStats should be empty for a table with empty partitionPaths");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testKeepLatestCommitsWithPendingCompactions(boolean isAsync) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).withAsyncClean(Boolean.valueOf(isAsync)).retainCommits(2).build()).build();
        this.testPendingCompactions(config, 15, 9, false);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testKeepLatestVersionsWithPendingCompactions(boolean retryFailure) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(2).build()).build();
        this.testPendingCompactions(config, 36, 9, retryFailure);
    }

    @Test
    public void testCleanPreviousCorruptedCleanFiles() throws IOException {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(1).build()).build();
        String commitTime = HoodieTestTable.makeNewCommitTime((int)1, (String)"%09d");
        List<String> cleanerFileNames = Arrays.asList(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedCleanerFileName(commitTime), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightCleanerFileName(commitTime));
        for (String f : cleanerFileNames) {
            StoragePath commitFile = new StoragePath(Paths.get(this.metaClient.getBasePath().toString(), ".hoodie", f).toString());
            OutputStream os = this.metaClient.getStorage().create(commitFile, true);
            Throwable throwable = null;
            try {
                os.write(new byte[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                os.close();
            }
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        List<HoodieCleanStat> cleanStats = this.runCleaner(config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)cleanStats.size(), (String)"Must not clean any files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRerunFailedClean(boolean simulateMetadataFailure) throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(2).build()).build();
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            final String p0 = "2020/01/01";
            final String p1 = "2020/01/02";
            final String file1P0C0 = UUID.randomUUID().toString();
            final String file1P1C0 = UUID.randomUUID().toString();
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
                }
            });
            this.commitWithMdt("00000000000001", part1ToFileId, testTable, config, true, true);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            Map partitionAndFileId002 = testTable.forReplaceCommit("00000000000002").getFileIdsWithBaseFilesInPartitions(new String[]{p0});
            String file2P0C1 = (String)partitionAndFileId002.get(p0);
            Pair<HoodieRequestedReplaceMetadata, HoodieReplaceCommitMetadata> replaceMetadata = this.generateReplaceCommitMetadata("00000000000002", p0, file1P0C0, file2P0C1);
            testTable.addCluster("00000000000002", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
            Map partitionAndFileId003 = testTable.forReplaceCommit("00000000000003").getFileIdsWithBaseFilesInPartitions(new String[]{p1});
            String file3P1C2 = (String)partitionAndFileId003.get(p1);
            replaceMetadata = this.generateReplaceCommitMetadata("00000000000003", p1, file1P1C0, file3P1C2);
            testTable.addCluster("00000000000003", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
            Map partitionAndFileId004 = testTable.forReplaceCommit("00000000000004").getFileIdsWithBaseFilesInPartitions(new String[]{p0});
            String file4P0C3 = (String)partitionAndFileId004.get(p0);
            replaceMetadata = this.generateReplaceCommitMetadata("00000000000004", p0, file2P0C1, file4P0C3);
            testTable.addCluster("00000000000004", (HoodieRequestedReplaceMetadata)replaceMetadata.getKey(), Option.empty(), (HoodieReplaceCommitMetadata)replaceMetadata.getValue());
            List<HoodieCleanStat> hoodieCleanStats = this.runCleaner(config, true, simulateMetadataFailure, 5, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000004", file4P0C3));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p0, "00000000000002", file2P0C1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000003", file3P1C2));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p0, "00000000000001", file1P0C0));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "00000000000001", file1P1C0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalFallbackToFullClean() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).withIncrementalCleaningMode(Boolean.valueOf(true)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).withMarkersType(MarkerType.DIRECT.name()).withPath(this.basePath).build();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        try (HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));){
            final String p1 = "part_1";
            final String p2 = "part_2";
            testTable.withPartitionMetaFiles(new String[]{p1, p2});
            final String file1P1 = UUID.randomUUID().toString();
            final String file2P1 = UUID.randomUUID().toString();
            Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1, file2P1}));
                }
            });
            this.commitWithMdt("10", part1ToFileId, testTable, config);
            testTable.addClean("15");
            this.commitWithMdt("20", part1ToFileId, testTable, config);
            HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.emptyMap());
            HoodieCleanMetadata cleanMeta = new HoodieCleanMetadata("", Long.valueOf(0L), Integer.valueOf(0), "20", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), Collections.emptyMap());
            testTable.addClean("30", cleanerPlan, cleanMeta);
            final String file3P2 = UUID.randomUUID().toString();
            final String file4P2 = UUID.randomUUID().toString();
            Map<String, List<String>> part2ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p2, CollectionUtils.createImmutableList((Object[])new String[]{file3P2, file4P2}));
                }
            });
            this.commitWithMdt("30", part2ToFileId, testTable, config);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.commitWithMdt("40", part2ToFileId, testTable, config);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            final String file5P2 = UUID.randomUUID().toString();
            final String file6P2 = UUID.randomUUID().toString();
            part2ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
                {
                    this.put(p2, CollectionUtils.createImmutableList((Object[])new String[]{file5P2, file6P2}));
                }
            });
            this.commitWithMdt("50", part2ToFileId, testTable, config);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            this.commitWithMdt("60", part2ToFileId, testTable, config);
            testTable = this.tearDownTestTableAndReinit(testTable, config);
            new TimelineArchiverV2(config, (HoodieTable)HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient)).archiveIfRequired((HoodieEngineContext)this.context, false);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getActiveTimeline().containsInstant("10"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getActiveTimeline().containsInstant("20"));
            this.runCleaner(config);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p1, "10", file1P1), (String)"Clean old FileSlice in p1 by fallback to full clean");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p1, "10", file2P1), (String)"Clean old FileSlice in p1 by fallback to full clean");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p2, "30", file3P2), (String)"Clean old FileSlice in p2");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFileExists(p2, "30", file4P2), (String)"Clean old FileSlice in p2");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "20", file1P1), (String)"Latest FileSlice exists");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p1, "20", file2P1), (String)"Latest FileSlice exists");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p2, "40", file3P2), (String)"Latest FileSlice exists");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFileExists(p2, "40", file4P2), (String)"Latest FileSlice exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPendingCompactions(HoodieWriteConfig config, int expNumFilesDeleted, int expNumFilesUnderCompactionDeleted, boolean retryFailure) throws Exception {
        HoodieTableMetaClient metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        String partition = "2016/03/15";
        final String timePrefix = "00000000000";
        HashMap<String, String> expFileIdToPendingCompaction = new HashMap<String, String>(){
            {
                this.put("fileId2", timePrefix + "004");
                this.put("fileId3", timePrefix + "006");
                this.put("fileId4", timePrefix + "008");
                this.put("fileId5", timePrefix + "010");
            }
        };
        HashMap<String, String> fileIdToLatestInstantBeforeCompaction = new HashMap<String, String>(){
            {
                this.put("fileId1", timePrefix + "000");
                this.put("fileId2", timePrefix + "000");
                this.put("fileId3", timePrefix + "001");
                this.put("fileId4", timePrefix + "003");
                this.put("fileId5", timePrefix + "005");
                this.put("fileId6", timePrefix + "009");
                this.put("fileId7", timePrefix + "013");
            }
        };
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        try (HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)metaClient);){
            testTable.withPartitionMetaFiles(new String[]{"2016/03/15"});
            String file1P1 = "fileId1";
            String file2P1 = "fileId2";
            String file3P1 = "fileId3";
            String file4P1 = "fileId4";
            String file5P1 = "fileId5";
            String file6P1 = "fileId6";
            String file7P1 = "fileId7";
            HashMap<String, List<String>> part1ToFileId = new HashMap<String, List<String>>();
            part1ToFileId.put("2016/03/15", Arrays.asList(file1P1, file2P1, file3P1, file4P1, file5P1, file6P1, file7P1));
            this.commitWithMdt(timePrefix + "000", part1ToFileId, testTable, config, true, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file3P1, file4P1, file5P1, file6P1, file7P1));
            this.commitWithMdt(timePrefix + "001", part1ToFileId, testTable, config, true, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file4P1, file5P1, file6P1, file7P1));
            this.commitWithMdt(timePrefix + "003", part1ToFileId, testTable, config, true, true);
            testTable.addRequestedCompaction(timePrefix + "004", new FileSlice[]{new FileSlice("2016/03/15", timePrefix + "000", file2P1)});
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file2P1));
            this.commitWithMdt(timePrefix + "005", part1ToFileId, testTable, config, false, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file5P1, file6P1, file7P1));
            this.commitWithMdt(timePrefix + "0055", part1ToFileId, testTable, config, true, true);
            testTable.addRequestedCompaction(timePrefix + "006", new FileSlice[]{new FileSlice("2016/03/15", timePrefix + "001", file3P1)});
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file3P1));
            this.commitWithMdt(timePrefix + "007", part1ToFileId, testTable, config, false, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file6P1, file7P1));
            this.commitWithMdt(timePrefix + "0075", part1ToFileId, testTable, config, true, true);
            testTable.addRequestedCompaction(timePrefix + "008", new FileSlice[]{new FileSlice("2016/03/15", timePrefix + "003", file4P1)});
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file4P1));
            this.commitWithMdt(timePrefix + "009", part1ToFileId, testTable, config, false, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file6P1, file7P1));
            this.commitWithMdt(timePrefix + "0095", part1ToFileId, testTable, config, true, true);
            testTable.addRequestedCompaction(timePrefix + "010", new FileSlice[]{new FileSlice("2016/03/15", timePrefix + "005", file5P1)});
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file5P1));
            this.commitWithMdt(timePrefix + "011", part1ToFileId, testTable, config, false, true);
            part1ToFileId = new HashMap();
            part1ToFileId.put("2016/03/15", Arrays.asList(file7P1));
            this.commitWithMdt(timePrefix + "013", part1ToFileId, testTable, config, true, true);
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            List<HoodieCleanStat> hoodieCleanStats = this.runCleaner(config, 14, true);
            HoodieTableMetaClient newMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metaClient);
            expFileIdToPendingCompaction.forEach((arg_0, arg_1) -> TestCleaner.lambda$testPendingCompactions$3(fileIdToLatestInstantBeforeCompaction, (HoodieTable)hoodieTable, arg_0, arg_1));
            long numFilesUnderCompactionDeleted = hoodieCleanStats.stream().flatMap(cleanStat -> this.convertPathToFileIdWithCommitTime(newMetaClient, cleanStat.getDeletePathPatterns()).map(fileIdWithCommitTime -> {
                if (expFileIdToPendingCompaction.containsKey(fileIdWithCommitTime.getKey())) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)InstantComparison.compareTimestamps((String)((String)fileIdToLatestInstantBeforeCompaction.get(fileIdWithCommitTime.getKey())), (BiPredicate)InstantComparison.GREATER_THAN, (String)((String)fileIdWithCommitTime.getValue())), (String)"Deleted instant time must be less than pending compaction");
                    return true;
                }
                return false;
            })).filter(x -> x).count();
            long numDeleted = hoodieCleanStats.stream().mapToLong(cleanStat -> cleanStat.getDeletePathPatterns().size()).sum();
            org.junit.jupiter.api.Assertions.assertEquals((long)expNumFilesDeleted, (long)numDeleted, (String)"Correct number of files deleted");
            org.junit.jupiter.api.Assertions.assertEquals((long)expNumFilesUnderCompactionDeleted, (long)numFilesUnderCompactionDeleted, (String)"Correct number of files under compaction deleted");
        }
    }

    private Stream<Pair<String, String>> convertPathToFileIdWithCommitTime(HoodieTableMetaClient metaClient, List<String> paths) {
        Predicate<String> roFilePredicate = path -> path.contains(metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
        Predicate<String> rtFilePredicate = path -> path.contains(metaClient.getTableConfig().getLogFileFormat().getFileExtension());
        Stream<Pair> stream1 = paths.stream().filter(roFilePredicate).map(fullPath -> {
            String fileName = Paths.get(fullPath, new String[0]).getFileName().toString();
            return Pair.of((Object)FSUtils.getFileId((String)fileName), (Object)FSUtils.getCommitTime((String)fileName));
        });
        Stream<Pair> stream2 = paths.stream().filter(rtFilePredicate).map(path -> Pair.of((Object)HadoopFSUtils.getFileIdFromLogPath((Path)new Path(path)), (Object)FSUtils.getDeltaCommitTimeFromLogPath((StoragePath)new StoragePath(path))));
        return Stream.concat(stream1, stream2);
    }

    private static /* synthetic */ void lambda$testPendingCompactions$3(Map fileIdToLatestInstantBeforeCompaction, HoodieTable hoodieTable, String fileId, String value) {
        String baseInstantForCompaction = (String)fileIdToLatestInstantBeforeCompaction.get(fileId);
        Option fileSliceForCompaction = Option.fromJavaOptional(hoodieTable.getSliceView().getLatestFileSlicesBeforeOrOn("2016/03/15", baseInstantForCompaction, true).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileSliceForCompaction.isPresent(), (String)"Base Instant for Compaction must be preserved");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((FileSlice)fileSliceForCompaction.get()).getBaseFile().isPresent(), (String)"FileSlice has data-file");
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((FileSlice)fileSliceForCompaction.get()).getLogFiles().count(), (String)"FileSlice has log-files");
    }
}

