/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantFileNameGeneratorV2;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantGeneratorV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.inline.InLineFileSystem;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.table.SparkBroadcastManager;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestSparkBroadcastManager {
    TestSparkBroadcastManager() {
    }

    @Test
    void testGetStorageConfiguration() {
        Configuration config = new Configuration(false);
        Configuration createdConfig = SparkBroadcastManager.getHadoopConfiguration((Configuration)config);
        Assertions.assertFalse((boolean)createdConfig.getBoolean(SQLConf.NESTED_SCHEMA_PRUNING_ENABLED().key(), true));
        Assertions.assertFalse((boolean)createdConfig.getBoolean(SQLConf.CASE_SENSITIVE().key(), true));
        Assertions.assertFalse((boolean)createdConfig.getBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), true));
        Assertions.assertTrue((boolean)createdConfig.getBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), false));
        Assertions.assertFalse((boolean)createdConfig.getBoolean("spark.sql.legacy.parquet.nanosAsLong", true));
        if (HoodieSparkUtils.gteqSpark3_4()) {
            Assertions.assertFalse((boolean)createdConfig.getBoolean("spark.sql.parquet.inferTimestampNTZ.enabled", true));
        }
        String inlineClassName = createdConfig.get("fs.inlinefs.impl");
        Assertions.assertEquals((Object)InLineFileSystem.class.getName(), (Object)inlineClassName);
    }

    @Test
    void testExtraConfigsAdded() {
        HashMap<String, String> extraConfigs = new HashMap<String, String>();
        extraConfigs.put("K1", "V1");
        Configuration configs = new Configuration(false);
        SparkBroadcastManager.addSchemaEvolutionConfigs((Configuration)configs, extraConfigs);
        Assertions.assertEquals((Object)"V1", (Object)configs.get("K1"));
    }

    @Test
    void testGetSchemaEvolutionConfigurations() {
        TableSchemaResolver schemaResolver = (TableSchemaResolver)Mockito.mock(TableSchemaResolver.class);
        HoodieTimeline timeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        InstantFileNameGeneratorV2 fileNameGenerator = new InstantFileNameGeneratorV2();
        String basePath = "any_table_path";
        Mockito.when((Object)schemaResolver.getTableInternalSchemaFromCommitMetadata()).thenReturn((Object)Option.empty());
        Map schemaEvolutionConfigs = SparkBroadcastManager.getSchemaEvolutionConfigs((TableSchemaResolver)schemaResolver, (HoodieTimeline)timeline, (InstantFileNameGenerator)fileNameGenerator, (String)basePath);
        Assertions.assertTrue((boolean)schemaEvolutionConfigs.isEmpty());
        InstantGeneratorV2 instantGen = new InstantGeneratorV2();
        Types.RecordType record = Types.RecordType.get(Collections.singletonList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get())));
        List<HoodieInstant> instants = Arrays.asList(instantGen.createNewInstant(HoodieInstant.State.COMPLETED, ActionType.deltacommit.name(), "0001", "0005"), instantGen.createNewInstant(HoodieInstant.State.COMPLETED, ActionType.deltacommit.name(), "0002", "0006"), instantGen.createNewInstant(HoodieInstant.State.COMPLETED, ActionType.compaction.name(), "0003", "0007"));
        InternalSchema internalSchema = new InternalSchema(record);
        Mockito.when((Object)schemaResolver.getTableInternalSchemaFromCommitMetadata()).thenReturn((Object)Option.of((Object)internalSchema));
        Mockito.when((Object)timeline.getInstants()).thenReturn(instants);
        schemaEvolutionConfigs = SparkBroadcastManager.getSchemaEvolutionConfigs((TableSchemaResolver)schemaResolver, (HoodieTimeline)timeline, (InstantFileNameGenerator)fileNameGenerator, (String)basePath);
        Assertions.assertFalse((boolean)schemaEvolutionConfigs.isEmpty());
        Assertions.assertEquals((Object)"0001_0005.deltacommit,0002_0006.deltacommit,0003_0007.commit", schemaEvolutionConfigs.get("hoodie.valid.commits.list"));
        Assertions.assertEquals((Object)"any_table_path", schemaEvolutionConfigs.get("hoodie.tablePath"));
    }
}

