/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.action.bootstrap.BootstrapUtils;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBootstrapUtils
extends HoodieClientTestBase {
    @Test
    public void testAllLeafFoldersWithFiles() throws IOException {
        List<String> folders = Arrays.asList("2016/04/15", "2016/05/16", "2016/05/17");
        folders.forEach(f -> {
            try {
                this.metaClient.getStorage().createDirectory(new StoragePath(this.basePath, f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        List<String> files = Stream.of("2016/04/15/1_1-0-1_20190528120000", "2016/04/15/2_1-0-1_20190528120000", "2016/05/16/3_1-0-1_20190528120000", "2016/05/16/4_1-0-1_20190528120000", "2016/04/17/5_1-0-1_20190528120000", "2016/04/17/6_1-0-1_20190528120000").map(file -> file + this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension()).collect(Collectors.toList());
        files.forEach(f -> {
            try {
                this.metaClient.getStorage().create(new StoragePath(this.basePath, f));
            }
            catch (IOException e) {
                throw new HoodieException((Throwable)e);
            }
        });
        List collected = BootstrapUtils.getAllLeafFoldersWithFiles((HoodieFileFormat)this.metaClient.getTableConfig().getBaseFileFormat(), (HoodieStorage)this.metaClient.getStorage(), (String)this.basePath, (HoodieEngineContext)this.context);
        Assertions.assertEquals((int)3, (int)collected.size());
        collected.forEach(k -> Assertions.assertEquals((int)2, (int)((List)k.getRight()).size()));
        collected = BootstrapUtils.getAllLeafFoldersWithFiles((HoodieFileFormat)this.metaClient.getTableConfig().getBaseFileFormat(), (HoodieStorage)this.metaClient.getStorage(), (String)(this.basePath + "/" + folders.get(0)), (HoodieEngineContext)this.context);
        Assertions.assertEquals((int)1, (int)collected.size());
        collected.forEach(k -> Assertions.assertEquals((int)2, (int)((List)k.getRight()).size()));
    }
}

