/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaRDD;

public class CompactionTestBase
extends HoodieClientTestBase {
    protected HoodieWriteConfig.Builder getConfigBuilder(Boolean autoCommit) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withAutoCommit(autoCommit.booleanValue()).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x40000000L).parquetMaxFileSize(0x40000000L).orcMaxFileSize(0x40000000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withProps(Collections.singletonMap(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name())).withEmbeddedTimelineServerEnabled(true);
    }

    protected void validateDeltaCommit(String latestDeltaCommit, Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> fgIdToCompactionOperation, HoodieWriteConfig cfg) {
        HoodieTableMetaClient metaClient = this.createMetaClient(cfg.getBasePath());
        HoodieSparkTable table = this.getHoodieTable(metaClient, cfg);
        List<FileSlice> fileSliceList = this.getCurrentLatestFileSlices((HoodieTable)table);
        fileSliceList.forEach(fileSlice -> {
            Pair opPair = (Pair)fgIdToCompactionOperation.get(fileSlice.getFileGroupId());
            if (opPair != null) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)fileSlice.getBaseInstantTime(), (Object)opPair.getKey(), (String)"Expect baseInstant to match compaction Instant");
                org.junit.jupiter.api.Assertions.assertTrue((fileSlice.getLogFiles().count() > 0L ? 1 : 0) != 0, (String)"Expect atleast one log file to be present where the latest delta commit was written");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSlice.getBaseFile().isPresent(), (String)"Expect no data-file to be present");
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((fileSlice.getBaseInstantTime().compareTo(latestDeltaCommit) <= 0 ? 1 : 0) != 0, (String)"Expect baseInstant to be less than or equal to latestDeltaCommit");
            }
        });
    }

    protected List<HoodieRecord> runNextDeltaCommits(SparkRDDWriteClient client, SparkRDDReadClient readClient, List<String> deltaInstants, List<HoodieRecord> records, HoodieWriteConfig cfg, boolean insertFirst, List<String> expPendingCompactionInstants) throws Exception {
        HoodieTableMetaClient metaClient = this.createMetaClient(cfg.getBasePath());
        List pendingCompactions = readClient.getPendingCompactions();
        List gotPendingCompactionInstants = pendingCompactions.stream().map(pc -> (String)pc.getKey()).sorted().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(expPendingCompactionInstants, gotPendingCompactionInstants);
        Map fgIdToCompactionOperation = CompactionUtils.getAllPendingCompactionOperations((HoodieTableMetaClient)metaClient);
        if (insertFirst) {
            String firstInstant = deltaInstants.get(0);
            deltaInstants = deltaInstants.subList(1, deltaInstants.size());
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            client.startCommitWithTime(firstInstant);
            JavaRDD statuses = client.upsert(writeRecords, firstInstant);
            List statusList = statuses.collect();
            if (!cfg.shouldAutoCommit().booleanValue()) {
                client.commit(firstInstant, (Object)statuses);
            }
            Assertions.assertNoWriteErrors((List)statusList);
            metaClient = this.createMetaClient(cfg.getBasePath());
            HoodieSparkTable hoodieTable = this.getHoodieTable(metaClient, cfg);
            List<HoodieBaseFile> dataFilesToRead = this.getCurrentLatestBaseFiles((HoodieTable)hoodieTable);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFilesToRead.stream().findAny().isPresent(), (String)"should list the base files we wrote in the delta commit");
            this.validateDeltaCommit(firstInstant, fgIdToCompactionOperation, cfg);
        }
        int numRecords = records.size();
        for (String instantTime : deltaInstants) {
            records = this.dataGen.generateUpdates(instantTime, Integer.valueOf(numRecords));
            metaClient = this.createMetaClient(cfg.getBasePath());
            this.createNextDeltaCommit(instantTime, records, client, metaClient, cfg, false);
            this.validateDeltaCommit(instantTime, fgIdToCompactionOperation, cfg);
        }
        return records;
    }

    protected void moveCompactionFromRequestedToInflight(String compactionInstantTime, HoodieWriteConfig cfg) {
        HoodieTableMetaClient metaClient = this.createMetaClient(cfg.getBasePath());
        HoodieInstant compactionInstant = HoodieTestUtils.INSTANT_GENERATOR.getCompactionRequestedInstant(compactionInstantTime);
        metaClient.getActiveTimeline().transitionCompactionRequestedToInflight(compactionInstant);
        HoodieInstant instant = metaClient.getActiveTimeline().reload().filterPendingCompactionTimeline().getInstantsAsStream().filter(in -> in.requestedTime().equals(compactionInstantTime)).findAny().get();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)instant.isInflight(), (String)"Instant must be marked inflight");
    }

    protected void scheduleCompaction(String compactionInstantTime, SparkRDDWriteClient client, HoodieWriteConfig cfg) {
        client.scheduleCompactionAtInstant(compactionInstantTime, Option.empty());
        HoodieTableMetaClient metaClient = this.createMetaClient(cfg.getBasePath());
        HoodieInstant instant = (HoodieInstant)metaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant().get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)compactionInstantTime, (Object)instant.requestedTime(), (String)"Last compaction instant must be the one set");
    }

    protected String tryScheduleCompaction(String compactionInstantTime, SparkRDDWriteClient client, HoodieWriteConfig cfg) {
        client.scheduleCompactionAtInstant(compactionInstantTime, Option.empty());
        HoodieTableMetaClient metaClient = this.createMetaClient(cfg.getBasePath());
        return (String)metaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant().map(HoodieInstant::requestedTime).orElse(null);
    }

    protected void scheduleAndExecuteCompaction(String compactionInstantTime, SparkRDDWriteClient client, HoodieTable table, HoodieWriteConfig cfg, int expectedNumRecs, boolean hasDeltaCommitAfterPendingCompaction) throws IOException {
        this.scheduleCompaction(compactionInstantTime, client, cfg);
        this.executeCompaction(compactionInstantTime, client, table, cfg, expectedNumRecs, hasDeltaCommitAfterPendingCompaction);
    }

    protected void executeCompaction(String compactionInstantTime, SparkRDDWriteClient client, HoodieTable table, HoodieWriteConfig cfg, int expectedNumRecs, boolean hasDeltaCommitAfterPendingCompaction) throws IOException {
        HoodieWriteMetadata compactionMetadata = client.compact(compactionInstantTime);
        if (!cfg.shouldAutoCommit().booleanValue() && compactionMetadata.getCommitMetadata().isPresent()) {
            client.commitCompaction(compactionInstantTime, (HoodieCommitMetadata)compactionMetadata.getCommitMetadata().get(), Option.empty());
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)WriteMarkersFactory.get((MarkerType)cfg.getMarkersType(), (HoodieTable)table, (String)compactionInstantTime).doesMarkerDirExist());
        List<FileSlice> fileSliceList = this.getCurrentLatestFileSlices(table);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileSliceList.stream().findAny().isPresent(), (String)"Ensure latest file-slices are not empty");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSliceList.stream().anyMatch(fs -> !fs.getBaseInstantTime().equals(compactionInstantTime)), (String)"Verify all file-slices have base-instant same as compaction instant");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSliceList.stream().anyMatch(fs -> !fs.getBaseFile().isPresent()), (String)"Verify all file-slices have data-files");
        if (hasDeltaCommitAfterPendingCompaction) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSliceList.stream().anyMatch(fs -> fs.getLogFiles().count() == 0L), (String)"Verify all file-slices have atleast one log-file");
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSliceList.stream().anyMatch(fs -> fs.getLogFiles().count() > 0L), (String)"Verify all file-slices have no log-files");
        }
        table = this.getHoodieTable(this.createMetaClient(cfg.getBasePath()), cfg);
        HoodieTimeline timeline = table.getMetaClient().getCommitTimeline().filterCompletedInstants();
        String latestCompactionCommitTime = ((HoodieInstant)timeline.lastInstant().get()).requestedTime();
        org.junit.jupiter.api.Assertions.assertEquals((Object)latestCompactionCommitTime, (Object)compactionInstantTime, (String)"Expect compaction instant time to be the latest commit time");
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedNumRecs, (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc, this.basePath, this.sqlContext, timeline, (Option<String>)Option.of((Object)"000")), (String)"Must contain expected records");
    }

    protected void executeCompactionWithReplacedFiles(String compactionInstantTime, SparkRDDWriteClient client, HoodieTable table, HoodieWriteConfig cfg, String[] partitions, Set<HoodieFileGroupId> replacedFileIds) throws IOException {
        client.compact(compactionInstantTime);
        List<FileSlice> fileSliceList = this.getCurrentLatestFileSlices(table);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileSliceList.stream().findAny().isPresent(), (String)"Ensure latest file-slices are not empty");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)fileSliceList.stream().anyMatch(fs -> replacedFileIds.contains(fs.getFileGroupId())), (String)"Compacted files should not show up in latest slices");
        table = this.getHoodieTable(this.createMetaClient(cfg.getBasePath()), cfg);
        HoodieTimeline timeline = table.getMetaClient().getCommitTimeline().filterCompletedInstants();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.filterCompletedInstants().getInstantsAsStream().filter(instant -> compactionInstantTime.equals(instant.requestedTime())).findFirst().isPresent());
        for (String partition : partitions) {
            table.getSliceView().getLatestFileSlicesBeforeOrOn(partition, compactionInstantTime, true).forEach(fs -> {
                org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)fs.getLogFiles().count());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.getBaseFile().isPresent());
            });
        }
    }

    protected List<WriteStatus> createNextDeltaCommit(String instantTime, List<HoodieRecord> records, SparkRDDWriteClient client, HoodieTableMetaClient metaClient, HoodieWriteConfig cfg, boolean skipCommit) {
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        client.startCommitWithTime(instantTime);
        JavaRDD statuses = client.upsert(writeRecords, instantTime);
        List statusList = statuses.collect();
        Assertions.assertNoWriteErrors((List)statusList);
        if (!cfg.shouldAutoCommit().booleanValue() && !skipCommit) {
            client.commit(instantTime, (Object)statuses);
        }
        Option deltaCommit = metaClient.getActiveTimeline().reload().getDeltaCommitTimeline().filterCompletedInstants().lastInstant();
        if (skipCommit && !cfg.shouldAutoCommit().booleanValue()) {
            org.junit.jupiter.api.Assertions.assertTrue((((HoodieInstant)deltaCommit.get()).requestedTime().compareTo(instantTime) < 0 ? 1 : 0) != 0, (String)"Delta commit should not be latest instant");
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)deltaCommit.isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)instantTime, (Object)((HoodieInstant)deltaCommit.get()).requestedTime(), (String)"Delta commit should be latest instant");
        }
        return statusList;
    }

    protected List<HoodieBaseFile> getCurrentLatestBaseFiles(HoodieTable table) throws IOException {
        List allBaseFiles = HoodieTestTable.of((HoodieTableMetaClient)table.getMetaClient()).listAllBaseFiles();
        HoodieTableFileSystemView view = this.getHoodieTableFileSystemView(table.getMetaClient(), table.getCompletedCommitsTimeline(), allBaseFiles);
        return view.getLatestBaseFiles().collect(Collectors.toList());
    }

    protected List<FileSlice> getCurrentLatestFileSlices(HoodieTable table) {
        HoodieTableFileSystemView view = new HoodieTableFileSystemView(table.getMetaClient(), table.getMetaClient().reloadActiveTimeline().getWriteTimeline());
        return Arrays.stream(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS).flatMap(arg_0 -> ((HoodieTableFileSystemView)view).getLatestFileSlices(arg_0)).collect(Collectors.toList());
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

