/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.BoundedPartitionAwareCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.DayBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileNumBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.LogFileSizeBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.PartitionRegexBasedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedPartitionAwareCompactionStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieCompactionStrategy {
    private static final long MB = 0x100000L;
    private static final Random RANDOM = new Random();
    private String[] partitionPaths = new String[]{"2017/01/01", "2017/01/02", "2017/01/03"};

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUnBounded(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        UnBoundedCompactionStrategy strategy = new UnBoundedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).build()).build();
        List operations = (List)this.createCompactionOperations(writeConfig, sizesMap).getLeft();
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        Assertions.assertEquals((Object)operations, (Object)returned, (String)"UnBounded should not re-order or filter");
        Assertions.assertEquals((int)missingPartitions.size(), (int)0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBoundedIOSimple(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        BoundedIOCompactionStrategy strategy = new BoundedIOCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetIOPerCompactionInMB(400L).build()).build();
        List operations = (List)this.createCompactionOperations(writeConfig, sizesMap).getLeft();
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Assertions.assertTrue((missingPartitions.stream().distinct().count() > 0L ? 1 : 0) != 0);
        }
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"BoundedIOCompaction should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"BoundedIOCompaction should have resulted in 2 compactions being chosen");
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)610L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 610 MB");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLogFileSizeCompactionSimple(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        LogFileSizeBasedCompactionStrategy strategy = new LogFileSizeBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetIOPerCompactionInMB(1205L).withLogFileSizeThresholdBasedCompaction(0x6400000L).build()).build();
        Pair<List<HoodieCompactionOperation>, Map<Long, String>> operationAndPartition = this.createCompactionOperations(writeConfig, sizesMap);
        List operations = (List)operationAndPartition.getLeft();
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            String missedPart1 = (String)((Map)operationAndPartition.getRight()).get(0x6E00000L);
            String missedPart2 = (String)((Map)operationAndPartition.getRight()).get(0x6400000L);
            Assertions.assertTrue((boolean)missingPartitions.contains(missedPart1));
            Assertions.assertTrue((boolean)missingPartitions.contains(missedPart2));
        }
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"LogFileSizeBasedCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"LogFileSizeBasedCompactionStrategy should have resulted in 2 compaction");
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)1594L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 1594 MB");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDayBasedCompactionSimple(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6E00000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6400000L, TestHoodieCompactionStrategy.this.partitionPaths[1]);
                this.put(0x5A00000L, TestHoodieCompactionStrategy.this.partitionPaths[0]);
            }
        });
        DayBasedCompactionStrategy strategy = new DayBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetPartitionsPerDayBasedCompaction(1).build()).build();
        Pair resPair = writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, Arrays.asList(this.partitionPaths));
        List filterPartitions = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Assertions.assertTrue((boolean)missingPartitions.isEmpty());
        }
        Assertions.assertEquals((int)1, (int)filterPartitions.size(), (String)"DayBasedCompactionStrategy should have resulted in fewer partitions");
        List<HoodieCompactionOperation> operations = this.createCompactionOperationsForPartition(writeConfig, sizesMap, keyToPartitionMap, filterPartitions);
        Assertions.assertEquals((int)2, (int)operations.size(), (String)"DayBasedCompactionStrategy should generate 2 HoodieCompactionOperation for partition 2017/01/03");
        List operationPartitions = operations.stream().collect(Collectors.groupingBy(HoodieCompactionOperation::getPartitionPath)).entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        Assertions.assertTrue((operationPartitions.size() == filterPartitions.size() ? 1 : 0) != 0, (String)"DayBasedCompactionStrategy should have resulted same partitions");
        int comparison = strategy.getComparator().compare(operations.get(operations.size() - 1).getPartitionPath(), operations.get(0).getPartitionPath());
        Assertions.assertTrue((comparison >= 0 ? 1 : 0) != 0, (String)"DayBasedCompactionStrategy should sort partitions in descending order");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDayBasedCompactionWithIOBounded(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6E00000L, TestHoodieCompactionStrategy.this.partitionPaths[2]);
                this.put(0x6400000L, TestHoodieCompactionStrategy.this.partitionPaths[1]);
                this.put(0x5A00000L, TestHoodieCompactionStrategy.this.partitionPaths[0]);
            }
        });
        DayBasedCompactionStrategy strategy = new DayBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetPartitionsPerDayBasedCompaction(1).withTargetIOPerCompactionInMB(200L).build()).build();
        List filterPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, Arrays.asList(this.partitionPaths)).getLeft();
        Assertions.assertEquals((int)1, (int)filterPartitions.size(), (String)"DayBasedCompactionStrategy should have resulted in fewer partitions");
        List<HoodieCompactionOperation> operations = this.createCompactionOperationsForPartition(writeConfig, sizesMap, keyToPartitionMap, filterPartitions);
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Assertions.assertEquals((int)1, (int)missingPartitions.size());
            Assertions.assertTrue((boolean)missingPartitions.contains(this.partitionPaths[2]));
        }
        Assertions.assertEquals((int)1, (int)returned.size(), (String)"DayBasedAndBoundedIOCompactionStrategy should have resulted in fewer compactions");
        int comparison = strategy.getComparator().compare(((HoodieCompactionOperation)returned.get(returned.size() - 1)).getPartitionPath(), ((HoodieCompactionOperation)returned.get(0)).getPartitionPath());
        Assertions.assertTrue((comparison >= 0 ? 1 : 0) != 0, (String)"DayBasedAndBoundedIOCompactionStrategy should sort partitions in descending order");
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)390L, (long)returnedSize, (String)"Should chose the first and the third compactions which should result in a total IO of 591 MB");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBoundedPartitionAwareCompactionSimple(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x4600000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5000000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date today = new Date();
        final String currentDay = format.format(today);
        final String currentDayMinus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-1));
        final String currentDayMinus2 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-2));
        final String currentDayMinus3 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-3));
        final String currentDayPlus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)1));
        final String currentDayPlus5 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)5));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, currentDay);
                this.put(0x6E00000L, currentDayMinus1);
                this.put(0x6400000L, currentDayMinus2);
                this.put(0x5000000L, currentDayMinus3);
                this.put(0x5A00000L, currentDayPlus1);
                this.put(0x4600000L, currentDayPlus5);
            }
        });
        BoundedPartitionAwareCompactionStrategy strategy = new BoundedPartitionAwareCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetPartitionsPerDayBasedCompaction(2).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap, keyToPartitionMap);
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Assertions.assertTrue((boolean)missingPartitions.isEmpty());
        }
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"BoundedPartitionAwareCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)5, (int)returned.size(), (String)"BoundedPartitionAwareCompactionStrategy should have resulted in fewer compactions");
        int comparison = strategy.getComparator().compare(((HoodieCompactionOperation)returned.get(returned.size() - 1)).getPartitionPath(), ((HoodieCompactionOperation)returned.get(0)).getPartitionPath());
        Assertions.assertTrue((comparison >= 0 ? 1 : 0) != 0, (String)"BoundedPartitionAwareCompactionStrategy should sort partitions in descending order");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUnboundedPartitionAwareCompactionSimple(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5000000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x4600000L, Collections.singletonList(0x100000L));
        sizesMap.put(0x5A00000L, Collections.singletonList(0x40000000L));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date today = new Date();
        final String currentDay = format.format(today);
        final String currentDayMinus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-1));
        final String currentDayMinus2 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-2));
        final String currentDayMinus3 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)-3));
        final String currentDayPlus1 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)1));
        final String currentDayPlus5 = format.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday((int)5));
        Map<Long, String> keyToPartitionMap = Collections.unmodifiableMap(new HashMap<Long, String>(){
            {
                this.put(0x7800000L, currentDay);
                this.put(0x6E00000L, currentDayMinus1);
                this.put(0x6400000L, currentDayMinus2);
                this.put(0x5000000L, currentDayMinus3);
                this.put(0x5A00000L, currentDayPlus1);
                this.put(0x4600000L, currentDayPlus5);
            }
        });
        UnBoundedPartitionAwareCompactionStrategy strategy = new UnBoundedPartitionAwareCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withIncrementalTableServiceEnabled(enableIncrTableService).withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetPartitionsPerDayBasedCompaction(2).build()).build();
        List<HoodieCompactionOperation> operations = this.createCompactionOperations(writeConfig, sizesMap, keyToPartitionMap);
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Assertions.assertTrue((boolean)missingPartitions.isEmpty());
        }
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)("UnBoundedPartitionAwareCompactionStrategy should not include last " + writeConfig.getTargetPartitionsPerDayBasedCompaction() + " partitions or later partitions from today"));
        Assertions.assertEquals((int)1, (int)returned.size(), (String)"BoundedPartitionAwareCompactionStrategy should have resulted in 1 compaction");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLogFileLengthBasedCompactionStrategy(boolean enableIncrTableService) {
        HashMap<Long, List<Long>> sizesMap = new HashMap<Long, List<Long>>();
        sizesMap.put(0x7800000L, Arrays.asList(0x3C00000L, 0xA00000L, 0x5000000L));
        sizesMap.put(0x6E00000L, new ArrayList());
        sizesMap.put(0x6400000L, Collections.singletonList(0x80000000L));
        sizesMap.put(0x5A00000L, Arrays.asList(0x20000000L, 0x20000000L));
        LogFileNumBasedCompactionStrategy strategy = new LogFileNumBasedCompactionStrategy();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{strategy}).withTargetIOPerCompactionInMB(1024L).withCompactionLogFileNumThreshold(2).build()).build();
        Pair<List<HoodieCompactionOperation>, Map<Long, String>> operationAndPartition = this.createCompactionOperations(writeConfig, sizesMap);
        List operations = (List)operationAndPartition.getLeft();
        Pair resPair = writeConfig.getCompactionStrategy().orderAndFilter(writeConfig, operations, new ArrayList());
        List returned = (List)resPair.getLeft();
        List missingPartitions = (List)resPair.getRight();
        if (enableIncrTableService) {
            Map partition = (Map)operationAndPartition.getRight();
            Assertions.assertTrue((boolean)missingPartitions.contains(partition.get(0x6E00000L)));
            Assertions.assertTrue((boolean)missingPartitions.contains(partition.get(0x6400000L)));
        }
        Assertions.assertTrue((returned.size() < operations.size() ? 1 : 0) != 0, (String)"LogFileLengthBasedCompactionStrategy should have resulted in fewer compactions");
        Assertions.assertEquals((int)2, (int)returned.size(), (String)"LogFileLengthBasedCompactionStrategy should have resulted in 2 compaction");
        Integer allFileLength = returned.stream().map(s -> s.getDeltaFilePaths().size()).reduce(Integer::sum).orElse(0);
        Assertions.assertEquals((int)5, (Integer)allFileLength);
        Assertions.assertEquals((int)3, (int)((HoodieCompactionOperation)returned.get(0)).getDeltaFilePaths().size());
        Assertions.assertEquals((int)2, (int)((HoodieCompactionOperation)returned.get(1)).getDeltaFilePaths().size());
        Long returnedSize = returned.stream().map(s -> (Double)s.getMetrics().get("TOTAL_IO_MB")).map(Double::longValue).reduce(Long::sum).orElse(0L);
        Assertions.assertEquals((long)1594L, (long)returnedSize, (String)"Should chose the first 2 compactions which should result in a total IO of 1594 MB");
    }

    @Test
    public void testCompositeCompactionStrategy() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{new NumStrategy(), new PrefixStrategy()}).withTargetIOPerCompactionInMB(1024L).withCompactionLogFileNumThreshold(2).build()).build();
        List<String> allPartitionPaths = Arrays.asList("2017/01/01", "2018/01/02", "2017/02/01");
        List returned = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, allPartitionPaths).getLeft();
        Assertions.assertEquals((int)1, (int)returned.size());
        Assertions.assertEquals((Object)"2017/01/01", returned.get(0));
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{new PrefixStrategy(), new NumStrategy()}).withTargetIOPerCompactionInMB(1024L).withCompactionLogFileNumThreshold(2).build()).build();
        returned = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, allPartitionPaths).getLeft();
        Assertions.assertEquals((int)2, (int)returned.size());
        Assertions.assertEquals((Object)"2017/01/01", returned.get(0));
        Assertions.assertEquals((Object)"2017/02/01", returned.get(1));
    }

    @Test
    public void testPartitionRegexBasedCompactionStrategy() {
        List<String> partitions = Arrays.asList("2020/01/01", "2020/01/02", "2020/01/03", "2020/02/01", "2021/01/01");
        HoodieWriteConfig writeConfig = this.updateRegex(".*");
        List filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)5, (int)filteredPartitions.size());
        writeConfig = this.updateRegex("2020/01/01");
        filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)1, (int)filteredPartitions.size());
        Assertions.assertEquals((Object)"2020/01/01", filteredPartitions.get(0));
        writeConfig = this.updateRegex("2020/01/0[1-2]");
        filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)2, (int)filteredPartitions.size());
        Assertions.assertEquals((Object)"2020/01/01", filteredPartitions.get(0));
        Assertions.assertEquals((Object)"2020/01/02", filteredPartitions.get(1));
        writeConfig = this.updateRegex("2020/01/0[1-2]|2020/02/01");
        filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)3, (int)filteredPartitions.size());
        Assertions.assertEquals((Object)"2020/01/01", filteredPartitions.get(0));
        Assertions.assertEquals((Object)"2020/01/02", filteredPartitions.get(1));
        Assertions.assertEquals((Object)"2020/02/01", filteredPartitions.get(2));
        writeConfig = this.updateRegex("2020/.*/01");
        filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)2, (int)filteredPartitions.size());
        Assertions.assertEquals((Object)"2020/01/01", filteredPartitions.get(0));
        Assertions.assertEquals((Object)"2020/02/01", filteredPartitions.get(1));
        writeConfig = this.updateRegex(".*/01/.*");
        filteredPartitions = (List)writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitions).getLeft();
        Assertions.assertEquals((int)4, (int)filteredPartitions.size());
        Assertions.assertEquals((Object)"2020/01/01", filteredPartitions.get(0));
        Assertions.assertEquals((Object)"2020/01/02", filteredPartitions.get(1));
        Assertions.assertEquals((Object)"2020/01/03", filteredPartitions.get(2));
        Assertions.assertEquals((Object)"2021/01/01", filteredPartitions.get(3));
    }

    private HoodieWriteConfig updateRegex(String regex) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCompactionConfig(HoodieCompactionConfig.newBuilder().withCompactionStrategy(new CompactionStrategy[]{new PartitionRegexBasedCompactionStrategy()}).withCompactionSpecifyPartitionPathRegex(regex).build()).build();
        return writeConfig;
    }

    private Pair<List<HoodieCompactionOperation>, Map<Long, String>> createCompactionOperations(HoodieWriteConfig config, Map<Long, List<Long>> sizesMap) {
        Map<Long, String> keyToPartitionMap = sizesMap.keySet().stream().map(e -> Pair.of((Object)e, (Object)this.partitionPaths[RANDOM.nextInt(this.partitionPaths.length - 1)])).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return Pair.of(this.createCompactionOperations(config, sizesMap, keyToPartitionMap), keyToPartitionMap);
    }

    private List<HoodieCompactionOperation> createCompactionOperations(HoodieWriteConfig config, Map<Long, List<Long>> sizesMap, Map<Long, String> keyToPartitionMap) {
        ArrayList<HoodieCompactionOperation> operations = new ArrayList<HoodieCompactionOperation>(sizesMap.size());
        sizesMap.forEach((k, v) -> {
            HoodieBaseFile df = TestHoodieBaseFile.newDataFile(k);
            String partitionPath = (String)keyToPartitionMap.get(k);
            List logFiles = v.stream().map(TestHoodieLogFile::newLogFile).collect(Collectors.toList());
            FileSlice slice = new FileSlice(new HoodieFileGroupId(partitionPath, df.getFileId()), df.getCommitTime());
            slice.setBaseFile(df);
            logFiles.stream().forEach(f -> slice.addLogFile(f));
            operations.add(new HoodieCompactionOperation(df.getCommitTime(), logFiles.stream().map(s -> s.getPath().toString()).collect(Collectors.toList()), df.getPath(), df.getFileId(), partitionPath, config.getCompactionStrategy().captureMetrics(config, slice), (String)df.getBootstrapBaseFile().map(BaseFile::getPath).orElse(null)));
        });
        return operations;
    }

    private List<HoodieCompactionOperation> createCompactionOperationsForPartition(HoodieWriteConfig config, Map<Long, List<Long>> sizesMap, Map<Long, String> keyToPartitionMap, List<String> filterPartitions) {
        ArrayList<HoodieCompactionOperation> operations = new ArrayList<HoodieCompactionOperation>(sizesMap.size());
        sizesMap.forEach((k, v) -> {
            HoodieBaseFile df = TestHoodieBaseFile.newDataFile(k);
            String partitionPath = (String)keyToPartitionMap.get(k);
            if (filterPartitions.contains(partitionPath)) {
                List logFiles = v.stream().map(TestHoodieLogFile::newLogFile).collect(Collectors.toList());
                FileSlice slice = new FileSlice(new HoodieFileGroupId(partitionPath, df.getFileId()), df.getCommitTime());
                slice.setBaseFile(df);
                logFiles.stream().forEach(f -> slice.addLogFile(f));
                operations.add(new HoodieCompactionOperation(df.getCommitTime(), logFiles.stream().map(s -> s.getPath().toString()).collect(Collectors.toList()), df.getPath(), df.getFileId(), partitionPath, config.getCompactionStrategy().captureMetrics(config, slice), (String)df.getBootstrapBaseFile().map(BaseFile::getPath).orElse(null)));
            }
        });
        return operations;
    }

    public static class TestHoodieLogFile
    extends HoodieLogFile {
        private static int version = 0;
        private final long size;

        public TestHoodieLogFile(long size) {
            super("/tmp/.ce481ee7-9e53-4a2e-999-f9e295fa79c0_20180919184844.log." + version++);
            this.size = size;
        }

        public static HoodieLogFile newLogFile(long size) {
            return new TestHoodieLogFile(size);
        }

        public long getFileSize() {
            return this.size;
        }
    }

    public static class TestHoodieBaseFile
    extends HoodieBaseFile {
        private final long size;

        public TestHoodieBaseFile(long size) {
            super("/tmp/XYXYXYXYXYYX_11_20180918020003" + ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
            this.size = size;
        }

        public static HoodieBaseFile newDataFile(long size) {
            return new TestHoodieBaseFile(size);
        }

        public String getPath() {
            return "/tmp/test";
        }

        public String getFileId() {
            return UUID.randomUUID().toString();
        }

        public String getCommitTime() {
            return "100";
        }

        public long getFileSize() {
            return this.size;
        }
    }

    public static class PrefixStrategy
    extends CompactionStrategy {
        public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
            ArrayList partitionsToProcess = new ArrayList();
            ArrayList missingPartitions = new ArrayList();
            allPartitionPaths.forEach(partition -> {
                if (partition.startsWith("2017")) {
                    partitionsToProcess.add(partition);
                } else {
                    missingPartitions.add(partition);
                }
            });
            return Pair.of(partitionsToProcess, missingPartitions);
        }
    }

    public static class NumStrategy
    extends CompactionStrategy {
        public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
            List partitionToProcess = allPartitionPaths.stream().limit(2L).collect(Collectors.toList());
            List missingPartitions = allPartitionPaths.stream().skip(2L).collect(Collectors.toList());
            return Pair.of(partitionToProcess, missingPartitions);
        }
    }
}

