/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.TestWriteMarkersBase;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class TestDirectWriteMarkers
extends TestWriteMarkersBase {
    @BeforeEach
    public void setup() throws IOException {
        this.initPath();
        this.initMetaClient();
        this.jsc = new JavaSparkContext(HoodieClientTestUtils.getSparkConfForTest(TestDirectWriteMarkers.class.getName()));
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.storage = this.metaClient.getStorage();
        this.markerFolderPath = new StoragePath(Paths.get(this.metaClient.getMarkerFolderPath("000"), new String[0]).toUri());
        this.writeMarkers = new DirectWriteMarkers(this.storage, this.metaClient.getBasePath().toString(), this.markerFolderPath.toString(), "000");
    }

    @AfterEach
    public void cleanup() {
        this.jsc.stop();
        this.context = null;
    }

    @Override
    void verifyMarkersInFileSystem(boolean isTablePartitioned) throws IOException {
        List markerFiles = HoodieTestTable.listRecursive((HoodieStorage)this.storage, (StoragePath)this.markerFolderPath).stream().filter(status -> status.getPath().getName().contains(".marker")).sorted().collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)markerFiles.size());
        Assertions.assertIterableEquals((Iterable)CollectionUtils.createImmutableList((Object[])new String[]{this.markerFolderPath.toString() + (isTablePartitioned ? "/2020/06/01" : "") + "/file1.marker.MERGE", this.markerFolderPath.toString() + (isTablePartitioned ? "/2020/06/02" : "") + "/file2.marker.APPEND", this.markerFolderPath.toString() + (isTablePartitioned ? "/2020/06/03" : "") + "/file3.marker.CREATE"}), (Iterable)markerFiles.stream().map(m -> m.getPath().toString()).collect(Collectors.toList()));
    }
}

