/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.testutils.providers.DFSProvider;
import org.apache.hudi.testutils.providers.HoodieMetaClientProvider;
import org.apache.hudi.testutils.providers.HoodieWriteClientProvider;
import org.apache.hudi.testutils.providers.SparkProvider;
import org.apache.spark.HoodieSparkKryoRegistrar$;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public class FunctionalTestHarness
implements SparkProvider,
DFSProvider,
HoodieMetaClientProvider,
HoodieWriteClientProvider {
    protected static transient SparkSession spark;
    private static transient SQLContext sqlContext;
    private static transient JavaSparkContext jsc;
    protected static transient HoodieSparkEngineContext context;
    private static transient HdfsTestService hdfsTestService;
    private static transient MiniDFSCluster dfsCluster;
    private static transient HoodieStorage storage;
    protected boolean initialized = false;
    @TempDir
    protected java.nio.file.Path tempDir;

    public String basePath() {
        return this.tempDir.toAbsolutePath().toString();
    }

    @Override
    public SparkSession spark() {
        return spark;
    }

    @Override
    public SQLContext sqlContext() {
        return sqlContext;
    }

    @Override
    public JavaSparkContext jsc() {
        return jsc;
    }

    public MiniDFSCluster dfsCluster() {
        return dfsCluster;
    }

    public HoodieStorage hoodieStorage() {
        return storage;
    }

    public Path dfsBasePath() {
        return new Path("/tmp");
    }

    public HoodieEngineContext context() {
        return context;
    }

    public HoodieTableMetaClient getHoodieMetaClient(StorageConfiguration<?> storageConf, String basePath) throws IOException {
        return this.getHoodieMetaClient(storageConf, basePath, new Properties());
    }

    public HoodieTableMetaClient getHoodieMetaClient(StorageConfiguration<?> storageConf, String basePath, Properties props, HoodieTableType tableType) throws IOException {
        return HoodieTableMetaClient.newTableBuilder().setTableName("raw_trips").setTableType(tableType).setPayloadClass(HoodieAvroPayload.class).fromProperties(props).initTable(storageConf.newInstance(), basePath);
    }

    public HoodieTableMetaClient getHoodieMetaClient(StorageConfiguration<?> storageConf, String basePath, Properties props) throws IOException {
        return this.getHoodieMetaClient(storageConf, basePath, props, HoodieTableType.COPY_ON_WRITE);
    }

    public SparkRDDWriteClient getHoodieWriteClient(HoodieWriteConfig cfg) throws IOException {
        return new SparkRDDWriteClient(this.context(), cfg);
    }

    @BeforeEach
    public synchronized void runBeforeEach() throws Exception {
        boolean bl = this.initialized = spark != null && hdfsTestService != null;
        if (!this.initialized) {
            SparkConf sparkConf = this.conf();
            HoodieSparkKryoRegistrar$.MODULE$.register(sparkConf);
            SparkRDDReadClient.addHoodieSupport((SparkConf)sparkConf);
            spark = SparkSession.builder().config(sparkConf).getOrCreate();
            sqlContext = spark.sqlContext();
            jsc = new JavaSparkContext(spark.sparkContext());
            context = new HoodieSparkEngineContext(jsc);
            hdfsTestService = new HdfsTestService();
            dfsCluster = hdfsTestService.start(true);
            storage = new HoodieHadoopStorage((FileSystem)dfsCluster.getFileSystem());
            storage.createDirectory(new StoragePath("/tmp"));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                hdfsTestService.stop();
                hdfsTestService = null;
                jsc.close();
                jsc = null;
                spark.stop();
                spark = null;
            }));
        }
    }

    @AfterEach
    public synchronized void tearDown() throws Exception {
        if (spark != null) {
            spark.stop();
            spark = null;
        }
    }

    @AfterAll
    public static synchronized void cleanUpAfterAll() throws IOException {
        StoragePath workDir = new StoragePath("/tmp");
        HoodieHadoopStorage storage = new HoodieHadoopStorage(workDir, HadoopFSUtils.getStorageConf((Configuration)hdfsTestService.getHadoopConf()));
        List pathInfoList = storage.listDirectEntries(workDir);
        for (StoragePathInfo f : pathInfoList) {
            if (f.isDirectory()) {
                storage.deleteDirectory(f.getPath());
                continue;
            }
            storage.deleteFile(f.getPath());
        }
        if (hdfsTestService != null) {
            hdfsTestService.stop();
            hdfsTestService = null;
        }
        if (spark != null) {
            spark.stop();
            spark = null;
        }
        if (jsc != null) {
            jsc.close();
            jsc = null;
        }
        sqlContext = null;
        context = null;
    }
}

