/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hudi.HoodieConversionUtils;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.util.JFunction;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class HoodieSparkClientTestHarness
extends HoodieWriterClientTestHarness {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkClientTestHarness.class);
    protected JavaSparkContext jsc;
    protected HoodieSparkEngineContext context;
    protected SparkSession sparkSession;
    protected SQLContext sqlContext;
    protected ExecutorService executorService;
    protected SparkRDDWriteClient writeClient;
    protected SparkRDDReadClient readClient;
    protected HoodieTableFileSystemView tableView;
    protected Map<String, String> extraConf = new HashMap<String, String>();
    protected TimelineService timelineService;
    protected final SparkTaskContextSupplier supplier = new SparkTaskContextSupplier();
    private String testMethodName;

    @AfterAll
    public static void tearDownAll() throws IOException {
        FileSystem.closeAll();
    }

    @BeforeEach
    public void setTestMethodName(TestInfo testInfo) {
        this.testMethodName = testInfo.getTestMethod().isPresent() ? ((Method)testInfo.getTestMethod().get()).getName() : "Unknown";
    }

    public void initResources() throws IOException {
        this.initPath();
        this.initSparkContexts();
        this.initTestDataGenerator();
        this.initHoodieStorage();
        this.initMetaClient();
        this.initTimelineService();
    }

    public void cleanupResources() throws IOException {
        this.cleanupTimelineService();
        this.cleanupClients();
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        this.cleanupExecutorService();
        System.gc();
    }

    protected Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return Option.empty();
    }

    protected void initSparkContexts(String appName) {
        Option<Consumer<SparkSessionExtensions>> sparkSessionExtensionsInjector = this.getSparkSessionExtensionsInjector();
        if (sparkSessionExtensionsInjector.isPresent()) {
            HoodieConversionUtils.toJavaOption((scala.Option)SparkSession.getActiveSession()).ifPresent(SparkSession::stop);
        }
        SparkConf sc = HoodieClientTestUtils.getSparkConfForTest(appName + "#" + this.testMethodName);
        this.extraConf.forEach((arg_0, arg_1) -> ((SparkConf)sc).set(arg_0, arg_1));
        SparkContext sparkContext = new SparkContext(sc);
        HoodieClientTestUtils.overrideSparkHadoopConfiguration(sparkContext);
        this.jsc = new JavaSparkContext(sparkContext);
        this.jsc.setLogLevel("ERROR");
        this.storageConf = HadoopFSUtils.getStorageConf((Configuration)this.jsc.hadoopConfiguration());
        this.sparkSession = SparkSession.builder().withExtensions(JFunction.toScala(sparkSessionExtensions -> {
            sparkSessionExtensionsInjector.ifPresent(injector -> injector.accept(sparkSessionExtensions));
            return null;
        })).config(this.jsc.getConf()).getOrCreate();
        this.sqlContext = new SQLContext(this.sparkSession);
        this.context = new HoodieSparkEngineContext(this.jsc, this.sqlContext);
        System.setProperty("spark.testing", "true");
    }

    protected void initSparkContexts() {
        this.initSparkContexts(((Object)((Object)this)).getClass().getSimpleName());
    }

    protected void initQueryIndexConf() {
        this.extraConf.put("hoodie.fileIndex.dataSkippingFailureMode", "strict");
    }

    protected void cleanupSparkContexts() {
        if (this.sqlContext != null) {
            LOG.info("Clearing sql context cache of spark-session used in previous test-case");
            this.sqlContext.clearCache();
            this.sqlContext = null;
            this.sparkSession = null;
        }
        if (this.jsc != null) {
            LOG.info("Closing spark context used in previous test-case");
            this.jsc.stop();
            this.jsc = null;
        }
        if (this.context != null) {
            LOG.info("Closing spark engine context used in previous test-case");
            this.context = null;
        }
    }

    protected void initHoodieStorage() {
        if (this.jsc == null) {
            throw new IllegalStateException("The Spark context has not been initialized.");
        }
        this.initFileSystemWithConfiguration(this.storageConf);
    }

    protected void initFileSystemWithDefaultConfiguration() {
        this.initFileSystemWithConfiguration(HoodieTestUtils.getDefaultStorageConf());
    }

    protected void cleanupFileSystem() throws IOException {
        if (this.storage != null) {
            LOG.warn("Closing file-system instance used in previous test-run");
            this.storage.close();
            this.storage = null;
        }
    }

    protected void initMetaClient() throws IOException {
        this.initMetaClient(this.getTableType());
    }

    protected void initMetaClient(Properties properties) throws IOException {
        this.initMetaClient(this.getTableType(), properties);
    }

    protected void initMetaClient(HoodieTableType tableType) throws IOException {
        this.initMetaClient(tableType, new Properties());
    }

    protected void initMetaClient(HoodieTableType tableType, Properties properties) throws IOException {
        if (this.basePath == null) {
            throw new IllegalStateException("The base path has not been initialized.");
        }
        if (this.jsc == null) {
            throw new IllegalStateException("The Spark context has not been initialized.");
        }
        if (this.tableName != null && !this.tableName.isEmpty()) {
            properties.put(HoodieTableConfig.NAME.key(), this.tableName);
        }
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)tableType, (Properties)properties);
    }

    protected void initTimelineService() {
        this.timelineService = HoodieClientTestUtils.initTimelineService((HoodieEngineContext)this.context, this.basePath, this.incrementTimelineServicePortToUse());
        timelineServicePort = this.timelineService.getServerPort();
    }

    protected void cleanupTimelineService() {
        if (this.timelineService != null) {
            this.timelineService.close();
        }
    }

    protected int incrementTimelineServicePortToUse() {
        timelineServicePort = (timelineServicePort + 1 - 1024) % 64512 + 1024;
        return timelineServicePort;
    }

    protected void cleanupClients() throws IOException {
        if (this.metaClient != null) {
            this.metaClient = null;
        }
        if (this.readClient != null) {
            this.readClient = null;
        }
        if (this.writeClient != null) {
            this.writeClient.close();
            this.writeClient = null;
        }
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    protected void initExecutorServiceWithFixedThreadPool(int threadNum) {
        this.executorService = Executors.newFixedThreadPool(threadNum);
    }

    protected void cleanupExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void initFileSystemWithConfiguration(StorageConfiguration<?> configuration) {
        if (this.basePath == null) {
            throw new IllegalStateException("The base path has not been initialized.");
        }
        this.storage = HoodieStorageUtils.getStorage((String)this.basePath, configuration);
        FileSystem fs = (FileSystem)this.storage.getFileSystem();
        if (fs instanceof LocalFileSystem) {
            ((LocalFileSystem)fs).setVerifyChecksum(true);
        }
    }

    public SparkRDDReadClient getHoodieReadClient(String basePath) {
        this.readClient = new SparkRDDReadClient(this.context, basePath, SQLContext.getOrCreate((SparkContext)this.jsc.sc()));
        return this.readClient;
    }

    public SparkRDDWriteClient getHoodieWriteClient(HoodieWriteConfig cfg) {
        if (null != this.writeClient) {
            this.writeClient.close();
            this.writeClient = null;
        }
        this.writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context, cfg);
        return this.writeClient;
    }

    public HoodieTableMetaClient getHoodieMetaClient(StorageConfiguration<?> conf, String basePath) {
        this.metaClient = HoodieTestUtils.createMetaClient(conf, (String)basePath);
        return this.metaClient;
    }

    public HoodieTableFileSystemView getHoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, List<StoragePathInfo> pathInfoList) {
        if (this.tableView == null) {
            this.tableView = new HoodieTableFileSystemView(metaClient, visibleActiveTimeline, pathInfoList);
        } else {
            this.tableView.init(metaClient, visibleActiveTimeline, pathInfoList);
        }
        return this.tableView;
    }

    @Deprecated
    public JavaRDD<HoodieRecord> tagLocation(HoodieIndex index, JavaRDD<HoodieRecord> records, HoodieTable table) {
        return HoodieJavaRDD.getJavaRDD((HoodieData)index.tagLocation((HoodieData)HoodieJavaRDD.of(records), (HoodieEngineContext)this.context, table));
    }

    public static JavaRDD<HoodieRecord> tagLocation(HoodieIndex index, HoodieEngineContext context, JavaRDD<HoodieRecord> records, HoodieTable table) {
        return HoodieJavaRDD.getJavaRDD((HoodieData)index.tagLocation((HoodieData)HoodieJavaRDD.of(records), context, table));
    }

    public static Pair<HashMap<String, WorkloadStat>, WorkloadStat> buildProfile(JavaRDD<HoodieRecord> inputRecordsRDD) {
        HashMap<String, WorkloadStat> partitionPathStatMap = new HashMap<String, WorkloadStat>();
        WorkloadStat globalStat = new WorkloadStat();
        Map partitionLocationCounts = inputRecordsRDD.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)new Tuple2((Object)record.getPartitionPath(), (Object)Option.ofNullable((Object)record.getCurrentLocation())), record)).countByKey();
        for (Map.Entry e : partitionLocationCounts.entrySet()) {
            String partitionPath = (String)((Tuple2)e.getKey())._1();
            Long count = (Long)e.getValue();
            Option locOption = (Option)((Tuple2)e.getKey())._2();
            if (!partitionPathStatMap.containsKey(partitionPath)) {
                partitionPathStatMap.put(partitionPath, new WorkloadStat());
            }
            if (locOption.isPresent()) {
                ((WorkloadStat)partitionPathStatMap.get(partitionPath)).addUpdates((HoodieRecordLocation)locOption.get(), count.longValue());
                globalStat.addUpdates((HoodieRecordLocation)locOption.get(), count.longValue());
                continue;
            }
            ((WorkloadStat)partitionPathStatMap.get(partitionPath)).addInserts(count.longValue());
            globalStat.addInserts(count.longValue());
        }
        return Pair.of(partitionPathStatMap, (Object)globalStat);
    }

    protected List<WriteStatus> writeAndVerifyBatch(BaseHoodieWriteClient client, List<HoodieRecord> inserts, String commitTime, boolean populateMetaFields, boolean autoCommitOff) {
        client.startCommitWithTime(commitTime);
        JavaRDD insertRecordsRDD1 = this.jsc.parallelize(inserts, 2);
        JavaRDD statusRDD = ((SparkRDDWriteClient)client).upsert(insertRecordsRDD1, commitTime);
        if (autoCommitOff) {
            client.commit(commitTime, (Object)statusRDD);
        }
        List statuses = statusRDD.collect();
        Assertions.assertNoWriteErrors((List)statuses);
        this.verifyRecordsWritten(commitTime, populateMetaFields, inserts, statuses, client.getConfig(), HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)client.getConfig().getProps()));
        return statuses;
    }

    public void validateMetadata(HoodieTestTable testTable, List<String> inflightCommits, HoodieWriteConfig writeConfig, String metadataTableBasePath, boolean doFullValidation) throws IOException {
        HoodieTableMetadata tableMetadata = this.metadata(writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)tableMetadata, (String)"MetadataReader should have been initialized");
        if (!writeConfig.isMetadataTableEnabled()) {
            return;
        }
        if (tableMetadata instanceof FileSystemBackedTableMetadata || !tableMetadata.getSyncedInstantTime().isPresent()) {
            throw new IllegalStateException("Metadata should have synced some commits or tableMetadata should not be an instance of FileSystemBackedTableMetadata");
        }
        org.junit.jupiter.api.Assertions.assertEquals(inflightCommits, (Object)testTable.inflightCommits());
        HoodieTimer timer = HoodieTimer.start();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        List fsPartitionPaths = testTable.getAllPartitionPaths();
        ArrayList<String> fsPartitions = new ArrayList<String>();
        fsPartitionPaths.forEach(entry -> fsPartitions.add(entry.getFileName().toString()));
        if (fsPartitions.isEmpty() && testTable.isNonPartitioned()) {
            fsPartitions.add("");
        }
        List metadataPartitions = tableMetadata.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsPartitions.size(), (int)metadataPartitions.size(), (String)"Partitions should match");
        org.junit.jupiter.api.Assertions.assertEquals(fsPartitions, (Object)metadataPartitions, (String)"Partitions should match");
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)engineContext);
        SyncableFileSystemView tableView = table.getHoodieView();
        List fullPartitionPaths = fsPartitions.stream().map(partition -> this.basePath + "/" + partition).collect(Collectors.toList());
        Map partitionToFilesMap = tableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsPartitions.size(), (int)partitionToFilesMap.size());
        fsPartitions.forEach(arg_0 -> this.lambda$validateMetadata$4(testTable, tableMetadata, (TableFileSystemView)tableView, partitionToFilesMap, arg_0));
        if (doFullValidation) {
            this.runFullValidation(table.getConfig().getMetadataConfig(), writeConfig, metadataTableBasePath, engineContext);
        }
        LOG.info("Validation time=" + timer.endTimer());
    }

    public void syncTableMetadata(HoodieWriteConfig writeConfig) {
        if (!writeConfig.getMetadataConfig().isEnabled()) {
            return;
        }
        try (HoodieTableMetadataWriter writer = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context);){
            LOG.info("Successfully synced to metadata table");
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Error syncing to metadata table.", e);
        }
    }

    public HoodieBackedTableMetadataWriter metadataWriter(HoodieWriteConfig clientConfig) {
        return (HoodieBackedTableMetadataWriter)SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)clientConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc));
    }

    public HoodieTableMetadata metadata(HoodieWriteConfig clientConfig, HoodieEngineContext hoodieEngineContext) {
        return HoodieTableMetadata.create((HoodieEngineContext)hoodieEngineContext, (HoodieStorage)this.storage, (HoodieMetadataConfig)clientConfig.getMetadataConfig(), (String)clientConfig.getBasePath());
    }

    protected void validateFilesPerPartition(HoodieTestTable testTable, HoodieTableMetadata tableMetadata, TableFileSystemView tableView, Map<String, List<StoragePathInfo>> partitionToFilesMap, String partition) throws IOException {
        StoragePath partitionPath = partition.equals("") ? new StoragePath(this.basePath) : new StoragePath(this.basePath, partition);
        FileStatus[] fsStatuses = testTable.listAllFilesInPartition(partition);
        List metaFilesList = tableMetadata.getAllFilesInPartition(partitionPath);
        List fsFileNames = Arrays.stream(fsStatuses).map(s -> s.getPath().getName()).collect(Collectors.toList());
        List metadataFilenames = metaFilesList.stream().map(s -> s.getPath().getName()).collect(Collectors.toList());
        Collections.sort(fsFileNames);
        Collections.sort(metadataFilenames);
        org.junit.jupiter.api.Assertions.assertLinesMatch(fsFileNames, metadataFilenames);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsStatuses.length, (int)partitionToFilesMap.get(partitionPath.toString()).size());
        metaFilesList.forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((s.getBlockSize() > 0L ? 1 : 0) != 0));
        List fsBlockSizes = Arrays.stream(fsStatuses).map(FileStatus::getBlockSize).sorted().collect(Collectors.toList());
        List metadataBlockSizes = metaFilesList.stream().map(StoragePathInfo::getBlockSize).sorted().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(fsBlockSizes, metadataBlockSizes);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsFileNames.size(), (int)metadataFilenames.size(), (String)("Files within partition " + partition + " should match"));
        org.junit.jupiter.api.Assertions.assertEquals(fsFileNames, metadataFilenames, (String)("Files within partition " + partition + " should match"));
        List<HoodieFileGroup> fileGroups = tableView.getAllFileGroups(partition).collect(Collectors.toList());
        fileGroups.addAll(tableView.getAllReplacedFileGroups(partition).collect(Collectors.toList()));
        fileGroups.forEach(g -> LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info(g.toString()));
        fileGroups.forEach(g -> g.getAllBaseFiles().forEach(b -> LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info(b.toString())));
        fileGroups.forEach(g -> g.getAllFileSlices().forEach(s -> LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info(s.toString())));
        long numFiles = fileGroups.stream().mapToLong(g -> g.getAllBaseFiles().count() + g.getAllFileSlices().mapToLong(s -> s.getLogFiles().count()).sum()).sum();
        org.junit.jupiter.api.Assertions.assertEquals((long)metadataFilenames.size(), (long)numFiles);
    }

    private void runFullValidation(HoodieMetadataConfig metadataConfig, HoodieWriteConfig writeConfig, String metadataTableBasePath, HoodieSparkEngineContext engineContext) {
        HoodieBackedTableMetadataWriter metadataWriter = this.metadataWriter(writeConfig);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)metadataWriter, (String)"MetadataWriter should have been initialized");
        HoodieWriteConfig metadataWriteConfig = metadataWriter.getWriteConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataWriteConfig.isMetadataTableEnabled(), (String)"No metadata table for metadata table");
        HoodieTableMetaClient metadataMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (String)metadataTableBasePath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataMetaClient.getTableType(), (Object)HoodieTableType.MERGE_ON_READ, (String)"Metadata Table should be MOR");
        List metadataTablePartitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)this.storage, (String)HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath), (boolean)false);
        int numFileVersions = metadataWriteConfig.getCleanerFileVersionsRetained() + 1;
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadataMetaClient, (HoodieTimeline)metadataMetaClient.getActiveTimeline());
        metadataTablePartitions.forEach(partition -> {
            List latestSlices = fsView.getLatestFileSlices(partition).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertTrue((latestSlices.stream().map(FileSlice::getBaseFile).filter(Objects::nonNull).count() > 0L ? 1 : 0) != 0, (String)"Should have a single latest base file");
            org.junit.jupiter.api.Assertions.assertTrue((latestSlices.size() > 0 ? 1 : 0) != 0, (String)"Should have a single latest file slice");
            org.junit.jupiter.api.Assertions.assertTrue((latestSlices.size() <= numFileVersions ? 1 : 0) != 0, (String)("Should limit file slice to " + numFileVersions + " but was " + latestSlices.size()));
        });
    }

    public HoodieInstant createCleanMetadata(String instantTime, boolean inflightOnly) throws IOException {
        return this.createCleanMetadata(instantTime, inflightOnly, false, false);
    }

    public HoodieInstant createEmptyCleanMetadata(String instantTime, boolean inflightOnly) throws IOException {
        return this.createCleanMetadata(instantTime, inflightOnly, true, true);
    }

    public HoodieInstant createCleanMetadata(String instantTime, boolean inflightOnly, boolean isEmptyForAll, boolean isEmptyCompleted) throws IOException {
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.EMPTY_MAP);
        if (inflightOnly) {
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightClean(instantTime, cleanerPlan);
        } else {
            HoodieCleanStat cleanStats = new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, HoodieTestUtils.DEFAULT_PARTITION_PATHS[new Random().nextInt(HoodieTestUtils.DEFAULT_PARTITION_PATHS.length)], Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), instantTime, "");
            HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)instantTime, (Option)Option.of((Object)0L), Collections.singletonList(cleanStats), (Map)Collections.EMPTY_MAP);
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addClean(instantTime, cleanerPlan, cleanMetadata, isEmptyForAll, isEmptyCompleted);
        }
        return HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(inflightOnly ? HoodieInstant.State.INFLIGHT : HoodieInstant.State.COMPLETED, "clean", instantTime);
    }

    protected HoodieTableMetaClient createMetaClient(SparkSession spark, String basePath) {
        return HoodieClientTestUtils.createMetaClient(spark, basePath);
    }

    protected HoodieTableMetaClient createMetaClient(JavaSparkContext context, String basePath) {
        return HoodieClientTestUtils.createMetaClient(context, basePath);
    }

    private /* synthetic */ void lambda$validateMetadata$4(HoodieTestTable testTable, HoodieTableMetadata tableMetadata, TableFileSystemView tableView, Map partitionToFilesMap, String partition) {
        try {
            this.validateFilesPerPartition(testTable, tableMetadata, tableView, partitionToFilesMap, partition);
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception should not be raised: " + e));
        }
    }
}

