/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils.providers;

import java.util.Collections;
import java.util.Map;
import org.apache.hudi.testutils.providers.HoodieEngineContextProvider;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;

public interface SparkProvider
extends HoodieEngineContextProvider {
    public SparkSession spark();

    public SQLContext sqlContext();

    public JavaSparkContext jsc();

    default public SparkConf conf(Map<String, String> overwritingConfigs) {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.app.name", this.getClass().getName());
        sparkConf.set("spark.master", "local[8]");
        sparkConf.set("spark.default.parallelism", "4");
        sparkConf.set("spark.sql.shuffle.partitions", "4");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar");
        overwritingConfigs.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
        return sparkConf;
    }

    default public SparkConf conf() {
        return this.conf(Collections.emptyMap());
    }
}

