/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.SparkPartitionUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.ClusteringGroupInfo;
import org.apache.hudi.common.model.ClusteringOperation;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieSparkIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.cluster.strategy.ClusteringExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleSparkJobExecutionStrategy<T>
extends ClusteringExecutionStrategy<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleSparkJobExecutionStrategy.class);

    public SingleSparkJobExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public HoodieWriteMetadata<HoodieData<WriteStatus>> performClustering(HoodieClusteringPlan clusteringPlan, Schema schema, String instantTime) {
        TaskContextSupplier taskContextSupplier = this.getEngineContext().getTaskContextSupplier();
        SerializableSchema serializableSchema = new SerializableSchema(schema);
        List clusteringGroupInfos = clusteringPlan.getInputGroups().stream().map(ClusteringGroupInfo::create).collect(Collectors.toList());
        HoodieData writeStatus = this.getEngineContext().parallelize(clusteringGroupInfos).map((SerializableFunction & Serializable)group -> this.performClusteringForGroup((ClusteringGroupInfo)group, clusteringPlan.getStrategy().getStrategyParams(), (Boolean)Option.ofNullable((Object)clusteringPlan.getPreserveHoodieMetadata()).orElse((Object)false), serializableSchema, taskContextSupplier, instantTime)).flatMap(List::iterator);
        HoodieWriteMetadata writeMetadata = new HoodieWriteMetadata();
        writeMetadata.setWriteStatuses((Object)writeStatus);
        return writeMetadata;
    }

    protected abstract List<WriteStatus> performClusteringForGroup(ClusteringGroupInfo var1, Map<String, String> var2, boolean var3, SerializableSchema var4, TaskContextSupplier var5, String var6);

    protected Option<HoodieFileReader> getBaseOrBootstrapFileReader(ClusteringOperation clusteringOp) {
        HoodieStorage storage = this.getHoodieTable().getStorage();
        StorageConfiguration storageConf = this.getHoodieTable().getStorageConf();
        HoodieTableConfig tableConfig = this.getHoodieTable().getMetaClient().getTableConfig();
        String bootstrapBasePath = (String)tableConfig.getBootstrapBasePath().orElse(null);
        Option partitionFields = tableConfig.getPartitionFields();
        Option baseFileReaderOpt = ClusteringUtils.getBaseFileReader((HoodieStorage)storage, (HoodieRecord.HoodieRecordType)this.recordType, (HoodieConfig)this.writeConfig, (String)clusteringOp.getDataFilePath());
        if (baseFileReaderOpt.isEmpty()) {
            return Option.empty();
        }
        try {
            HoodieFileReader baseFileReader = (HoodieFileReader)baseFileReaderOpt.get();
            if (StringUtils.nonEmpty((String)clusteringOp.getBootstrapFilePath()) && StringUtils.nonEmpty((String)bootstrapBasePath)) {
                String bootstrapFilePath = clusteringOp.getBootstrapFilePath();
                Object[] partitionValues = new Object[]{};
                if (partitionFields.isPresent()) {
                    int startOfPartitionPath = bootstrapFilePath.indexOf(bootstrapBasePath) + bootstrapBasePath.length() + 1;
                    String partitionFilePath = bootstrapFilePath.substring(startOfPartitionPath, bootstrapFilePath.lastIndexOf("/"));
                    partitionValues = SparkPartitionUtils.getPartitionFieldVals((Option<String[]>)partitionFields, partitionFilePath, bootstrapBasePath, baseFileReader.getSchema(), (Configuration)storageConf.unwrapAs(Configuration.class));
                }
                return Option.of((Object)HoodieSparkIOFactory.getHoodieSparkIOFactory(storage).getReaderFactory(this.recordType).newBootstrapFileReader(baseFileReader, HoodieSparkIOFactory.getHoodieSparkIOFactory(storage).getReaderFactory(this.recordType).getFileReader((HoodieConfig)this.writeConfig, new StoragePath(bootstrapFilePath)), partitionFields, partitionValues));
            }
            return baseFileReaderOpt;
        }
        catch (IOException e) {
            throw new HoodieClusteringException("Error reading base file", (Throwable)e);
        }
    }
}

