/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.strategy.UpdateStrategy;
import org.apache.hudi.table.action.cluster.util.ConsistentHashingUpdateStrategyUtils;

public class SparkConsistentBucketDuplicateUpdateStrategy<T extends HoodieRecordPayload<T>>
extends UpdateStrategy<T, HoodieData<HoodieRecord<T>>> {
    public SparkConsistentBucketDuplicateUpdateStrategy(HoodieEngineContext engineContext, HoodieTable table, Set<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, table, fileGroupsInPendingClustering);
    }

    public Pair<HoodieData<HoodieRecord<T>>, Set<HoodieFileGroupId>> handleUpdate(HoodieData<HoodieRecord<T>> taggedRecordsRDD) {
        if (this.fileGroupsInPendingClustering.isEmpty()) {
            return Pair.of(taggedRecordsRDD, Collections.emptySet());
        }
        HoodieData filteredRecordsRDD = taggedRecordsRDD.filter((SerializableFunction & Serializable)r -> {
            ValidationUtils.checkState((r.getCurrentLocation() != null ? 1 : 0) != 0);
            return this.fileGroupsInPendingClustering.contains(new HoodieFileGroupId(r.getPartitionPath(), r.getCurrentLocation().getFileId()));
        });
        if (filteredRecordsRDD.count() == 0L) {
            return Pair.of(taggedRecordsRDD, Collections.emptySet());
        }
        HashSet partitions = new HashSet(filteredRecordsRDD.map(HoodieRecord::getPartitionPath).distinct().collectAsList());
        Map partitionToIdentifier = ConsistentHashingUpdateStrategyUtils.constructPartitionToIdentifier(partitions, (HoodieTable)this.table);
        List<String> indexKeyFields = Arrays.asList(this.table.getConfig().getBucketIndexHashField().split(","));
        HoodieData redirectedRecordsRDD = filteredRecordsRDD.map((SerializableFunction & Serializable)r -> {
            Pair identifierPair = (Pair)partitionToIdentifier.get(r.getPartitionPath());
            ConsistentHashingNode node = ((ConsistentBucketIdentifier)identifierPair.getValue()).getBucket(r.getKey(), indexKeyFields);
            return HoodieIndexUtils.tagAsNewRecordIfNeeded((HoodieRecord)new HoodieAvroRecord(r.getKey(), (HoodieRecordPayload)r.getData(), r.getOperation()), (Option)Option.ofNullable((Object)new HoodieRecordLocation((String)identifierPair.getKey(), FSUtils.createNewFileId((String)node.getFileIdPrefix(), (int)0))));
        });
        return Pair.of((Object)taggedRecordsRDD.union(redirectedRecordsRDD), Collections.emptySet());
    }
}

