/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class RDDPartitionSortPartitioner<T>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final boolean shouldPopulateMetaFields;

    public RDDPartitionSortPartitioner(HoodieWriteConfig config) {
        this.shouldPopulateMetaFields = config.populateMetaFields();
    }

    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        if (!this.shouldPopulateMetaFields) {
            throw new HoodieException(BulkInsertSortMode.PARTITION_SORT.name() + " mode requires meta-fields to be enabled");
        }
        return records.coalesce(outputSparkPartitions).mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)(record.getPartitionPath() + "+" + record.getRecordKey()), record)).mapPartitions((FlatMapFunction & Serializable)partition -> {
            ArrayList recordList = new ArrayList();
            while (partition.hasNext()) {
                recordList.add(partition.next());
            }
            Collections.sort(recordList, (o1, o2) -> ((String)o1._1).compareTo((String)o2._1));
            return recordList.stream().map(e -> (HoodieRecord)e._2).iterator();
        });
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

