/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkMetadataTableRecordIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMetadataTableRecordIndex.class);
    private static final HoodieIndex.IndexType FALLBACK_INDEX_TYPE = HoodieIndex.IndexType.GLOBAL_SIMPLE;

    public SparkMetadataTableRecordIndex(HoodieWriteConfig config) {
        super(config);
    }

    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        JavaRDD partitionedKeyRDD;
        int fileGroupSize;
        try {
            ValidationUtils.checkState((boolean)hoodieTable.getMetaClient().getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX));
            fileGroupSize = hoodieTable.getMetadataTable().getNumFileGroupsForPartition(MetadataPartitionType.RECORD_INDEX);
            ValidationUtils.checkState((fileGroupSize > 0 ? 1 : 0) != 0, (String)"Record index should have at least one file group");
        }
        catch (IllegalStateException | TableNotFoundException e) {
            LOG.warn(String.format("Record index not initialized so falling back to %s for tagging records", FALLBACK_INDEX_TYPE.name()));
            HoodieWriteConfig otherConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)this.config.getProps()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(FALLBACK_INDEX_TYPE).build()).build();
            HoodieIndex fallbackIndex = SparkHoodieIndexFactory.createIndex(otherConfig);
            return fallbackIndex.tagLocation(records, context, hoodieTable);
        }
        int numFileGroups = fileGroupSize;
        if (this.config.getRecordIndexUseCaching()) {
            records.persist(new HoodieConfig(this.config.getProps()).getString(HoodieIndexConfig.RECORD_INDEX_INPUT_STORAGE_LEVEL_VALUE));
        }
        ValidationUtils.checkState(((partitionedKeyRDD = HoodieJavaRDD.getJavaRDD(records).map(HoodieRecord::getRecordKey).keyBy((Function & Serializable)k -> HoodieTableMetadataUtil.mapRecordKeyToFileGroupIndex((String)k, (int)numFileGroups)).partitionBy((Partitioner)new PartitionIdPassthrough(numFileGroups)).map((Function & Serializable)t -> (String)t._2)).getNumPartitions() <= numFileGroups ? 1 : 0) != 0);
        HoodieJavaPairRDD keyAndExistingLocations = HoodieJavaPairRDD.of(partitionedKeyRDD.mapPartitionsToPair((PairFlatMapFunction)new RecordIndexFileGroupLookupFunction(hoodieTable)));
        boolean shouldUpdatePartitionPath = this.config.getRecordIndexUpdatePartitionPath() && hoodieTable.isPartitioned();
        HoodieData taggedRecords = HoodieIndexUtils.tagGlobalLocationBackToRecords(records, keyAndExistingLocations, (boolean)false, (boolean)shouldUpdatePartitionPath, (HoodieWriteConfig)this.config, (HoodieTable)hoodieTable);
        if (this.config.getRecordIndexUseCaching()) {
            records.unpersist();
        }
        return taggedRecords;
    }

    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatuses;
    }

    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    public boolean isGlobal() {
        return true;
    }

    public boolean canIndexLogFiles() {
        return false;
    }

    public boolean isImplicitWithStorage() {
        return false;
    }

    private class PartitionIdPassthrough
    extends Partitioner {
        private final int numPartitions;

        public PartitionIdPassthrough(int numPartitions) {
            this.numPartitions = numPartitions;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public int getPartition(Object key) {
            return (Integer)key;
        }
    }

    private static class RecordIndexFileGroupLookupFunction
    implements PairFlatMapFunction<Iterator<String>, String, HoodieRecordGlobalLocation> {
        private final HoodieTable hoodieTable;

        public RecordIndexFileGroupLookupFunction(HoodieTable hoodieTable) {
            this.hoodieTable = hoodieTable;
        }

        public Iterator<Tuple2<String, HoodieRecordGlobalLocation>> call(Iterator<String> recordKeyIterator) {
            ArrayList keysToLookup = new ArrayList();
            recordKeyIterator.forEachRemaining(keysToLookup::add);
            Map recordIndexInfo = this.hoodieTable.getMetadataTable().readRecordIndex(keysToLookup);
            return recordIndexInfo.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(loc -> new Tuple2(e.getKey(), loc))).iterator();
        }
    }
}

