/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.expression;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.index.expression.ExpressionIndexSparkFunctions;
import org.apache.hudi.index.expression.HoodieExpressionIndex;
import org.apache.spark.sql.Column;

public class HoodieSparkExpressionIndex
implements HoodieExpressionIndex<Column, Column>,
Serializable {
    private String indexName;
    private String indexFunction;
    private List<String> orderedSourceFields;
    private Map<String, String> options;
    private ExpressionIndexSparkFunctions.SparkFunction sparkFunction;

    public HoodieSparkExpressionIndex() {
    }

    public HoodieSparkExpressionIndex(String indexName, String indexFunction, List<String> orderedSourceFields, Map<String, String> options) {
        this.indexName = indexName;
        this.indexFunction = indexFunction;
        this.orderedSourceFields = orderedSourceFields;
        this.options = options;
        this.sparkFunction = ExpressionIndexSparkFunctions.SparkFunction.getSparkFunction(indexFunction);
        if (this.sparkFunction == null) {
            throw new IllegalArgumentException("Unsupported Spark function: " + indexFunction);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexFunction() {
        return this.indexFunction;
    }

    public List<String> getOrderedSourceFields() {
        return this.orderedSourceFields;
    }

    public Column apply(List<Column> orderedSourceValues) {
        if (orderedSourceValues.size() != this.orderedSourceFields.size()) {
            throw new IllegalArgumentException("Mismatch in number of source values and fields in the expression");
        }
        this.sparkFunction.validateOptions(this.options);
        return this.sparkFunction.apply(orderedSourceValues, this.options);
    }

    public static class ExpressionIndexComputationMetadata {
        HoodieData<HoodieRecord> expressionIndexRecords;
        Option<HoodieData<HoodieRecord>> partitionStatRecordsOpt;

        public ExpressionIndexComputationMetadata(HoodieData<HoodieRecord> expressionIndexRecords, Option<HoodieData<HoodieRecord>> partitionStatRecordsOpt) {
            this.expressionIndexRecords = expressionIndexRecords;
            this.partitionStatRecordsOpt = partitionStatRecordsOpt;
        }

        public ExpressionIndexComputationMetadata(HoodieData<HoodieRecord> expressionIndexRecords) {
            this.expressionIndexRecords = expressionIndexRecords;
            this.partitionStatRecordsOpt = Option.empty();
        }

        public HoodieData<HoodieRecord> getExpressionIndexRecords() {
            return this.expressionIndexRecords;
        }

        public Option<HoodieData<HoodieRecord>> getPartitionStatRecordsOption() {
            return this.partitionStatRecordsOpt;
        }
    }
}

