/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HoodieSparkFileGroupReaderBasedMergeHandle<T, I, K, O>
extends HoodieMergeHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkFileGroupReaderBasedMergeHandle.class);
    protected HoodieReaderContext readerContext;
    protected FileSlice fileSlice;
    protected Configuration conf;
    protected HoodieReadStats readStats;

    public HoodieSparkFileGroupReaderBasedMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, CompactionOperation operation, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt, HoodieReaderContext readerContext, Configuration conf) {
        super(config, instantTime, operation.getPartitionPath(), operation.getFileId(), hoodieTable, taskContextSupplier);
        this.keyToNewRecords = Collections.emptyMap();
        this.readerContext = readerContext;
        this.conf = conf;
        Option baseFileOpt = operation.getBaseFile(config.getBasePath(), operation.getPartitionPath());
        List logFiles = operation.getDeltaFileNames().stream().map(p -> new HoodieLogFile(new StoragePath(FSUtils.constructAbsolutePath((String)config.getBasePath(), (String)operation.getPartitionPath()), p))).collect(Collectors.toList());
        this.fileSlice = new FileSlice(operation.getFileGroupId(), operation.getBaseInstantTime(), baseFileOpt.isPresent() ? (HoodieBaseFile)baseFileOpt.get() : null, logFiles);
        this.preserveMetadata = true;
        this.init(operation, this.partitionPath, (Option<HoodieBaseFile>)baseFileOpt);
        this.validateAndSetAndKeyGenProps(keyGeneratorOpt, config.populateMetaFields());
    }

    private void validateAndSetAndKeyGenProps(Option<BaseKeyGenerator> keyGeneratorOpt, boolean populateMetaFields) {
        ValidationUtils.checkArgument((populateMetaFields == !keyGeneratorOpt.isPresent() ? 1 : 0) != 0);
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    private void init(CompactionOperation operation, String partitionPath, Option<HoodieBaseFile> baseFileToMerge) {
        LOG.info("partitionPath:" + partitionPath + ", fileId to be merged:" + this.fileId);
        this.baseFileToMerge = (HoodieBaseFile)baseFileToMerge.orElse(null);
        this.writtenRecordKeys = new HashSet();
        this.writeStatus.setStat(new HoodieWriteStat());
        this.writeStatus.getStat().setTotalLogSizeCompacted(((Double)operation.getMetrics().get("TOTAL_LOG_FILES_SIZE")).longValue());
        try {
            Option latestValidFilePath = Option.empty();
            if (baseFileToMerge.isPresent()) {
                latestValidFilePath = Option.of((Object)((HoodieBaseFile)baseFileToMerge.get()).getFileName());
                this.writeStatus.getStat().setPrevCommit(((HoodieBaseFile)baseFileToMerge.get()).getCommitTime());
                this.writeStatus.getStat().setPrevBaseFile((String)latestValidFilePath.get());
            } else {
                this.writeStatus.getStat().setPrevCommit("null");
            }
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.storage, this.instantTime, new StoragePath(this.config.getBasePath()), FSUtils.constructAbsolutePath((String)this.config.getBasePath(), (String)partitionPath), this.hoodieTable.getPartitionMetafileFormat());
            partitionMetadata.trySave();
            String newFileName = FSUtils.makeBaseFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
            this.makeOldAndNewFilePaths(partitionPath, latestValidFilePath.isPresent() ? (String)latestValidFilePath.get() : null, newFileName);
            LOG.info(String.format("Merging data from file group %s, to a new base file %s", this.fileId, this.newFilePath.toString()));
            this.writeStatus.setFileId(this.fileId);
            this.writeStatus.setPartitionPath(partitionPath);
            this.writeStatus.getStat().setPartitionPath(partitionPath);
            this.writeStatus.getStat().setFileId(this.fileId);
            this.setWriteStatusPath();
            this.createMarkerFile(partitionPath, this.newFilePath.getName());
            this.fileWriter = HoodieFileWriterFactory.getFileWriter((String)this.instantTime, (StoragePath)this.newFilePath, (HoodieStorage)this.hoodieTable.getStorage(), (HoodieConfig)this.config, (Schema)this.writeSchemaWithMetaFields, (TaskContextSupplier)this.taskContextSupplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.SPARK);
        }
        catch (IOException io) {
            LOG.error("Error in update task at commit " + this.instantTime, (Throwable)io);
            this.writeStatus.setGlobalError((Throwable)io);
            throw new HoodieUpsertException("Failed to initialize HoodieUpdateHandle for FileId: " + this.fileId + " on commit " + this.instantTime + " on path " + this.hoodieTable.getMetaClient().getBasePath(), (Throwable)io);
        }
    }

    public void write() {
        boolean usePosition = this.config.getBooleanOrDefault(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS);
        Option internalSchemaOption = Option.empty();
        if (!StringUtils.isNullOrEmpty((String)this.config.getInternalSchema())) {
            internalSchemaOption = SerDeHelper.fromJson((String)this.config.getInternalSchema());
        }
        try (HoodieFileGroupReader fileGroupReader = new HoodieFileGroupReader(this.readerContext, this.storage.newInstance(this.hoodieTable.getMetaClient().getBasePath(), (StorageConfiguration)new HadoopStorageConfiguration(this.conf)), this.hoodieTable.getMetaClient().getBasePath().toString(), this.instantTime, this.fileSlice, this.writeSchemaWithMetaFields, this.writeSchemaWithMetaFields, internalSchemaOption, this.hoodieTable.getMetaClient(), this.hoodieTable.getMetaClient().getTableConfig().getProps(), 0L, Long.MAX_VALUE, usePosition);){
            fileGroupReader.initRecordIterators();
            try (HoodieFileGroupReader.HoodieFileGroupReaderIterator recordIterator = fileGroupReader.getClosableIterator();){
                StructType sparkSchema = AvroConversionUtils.convertAvroSchemaToStructType(this.writeSchemaWithMetaFields);
                while (recordIterator.hasNext()) {
                    InternalRow row = (InternalRow)recordIterator.next();
                    HoodieKey recordKey = new HoodieKey(row.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD), row.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD));
                    HoodieSparkRecord record = new HoodieSparkRecord(recordKey, row, sparkSchema, false);
                    Option<Map<String, String>> recordMetadata = record.getMetadata();
                    if (!this.partitionPath.equals(record.getPartitionPath())) {
                        HoodieUpsertException failureEx = new HoodieUpsertException("mismatched partition path, record partition: " + record.getPartitionPath() + " but trying to insert into partition: " + this.partitionPath);
                        this.writeStatus.markFailure((HoodieRecord)record, (Throwable)failureEx, recordMetadata);
                        continue;
                    }
                    try {
                        this.writeToFile(recordKey, record, this.writeSchemaWithMetaFields, (Properties)this.config.getPayloadConfig().getProps(), this.preserveMetadata);
                        this.writeStatus.markSuccess((HoodieRecord)record, recordMetadata);
                    }
                    catch (Exception e) {
                        LOG.error("Error writing record  " + (Object)((Object)record), (Throwable)e);
                        this.writeStatus.markFailure((HoodieRecord)record, (Throwable)e, recordMetadata);
                    }
                }
                this.readStats = fileGroupReader.getStats();
                this.insertRecordsWritten = this.readStats.getNumInserts();
                this.updatedRecordsWritten = this.readStats.getNumUpdates();
                this.recordsDeleted = this.readStats.getNumDeletes();
                this.recordsWritten = this.readStats.getNumInserts() + this.readStats.getNumUpdates();
            }
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to compact file slice: " + this.fileSlice, (Throwable)e);
        }
    }

    protected void writeToFile(HoodieKey key, HoodieSparkRecord record, Schema schema, Properties prop, boolean shouldPreserveRecordMetadata) throws IOException {
        MetadataValues metadataValues = new MetadataValues().setFileName(this.newFilePath.getName());
        HoodieRecord populatedRecord = record.prependMetaFields(schema, this.writeSchemaWithMetaFields, metadataValues, prop);
        if (shouldPreserveRecordMetadata) {
            this.fileWriter.write(key.getRecordKey(), populatedRecord, this.writeSchemaWithMetaFields);
        } else {
            this.fileWriter.writeWithMetadata(key, populatedRecord, this.writeSchemaWithMetaFields);
        }
    }

    protected void writeIncomingRecords() {
    }

    public List<WriteStatus> close() {
        try {
            super.close();
            this.writeStatus.getStat().setTotalLogReadTimeMs(this.readStats.getTotalLogReadTimeMs());
            this.writeStatus.getStat().setTotalUpdatedRecordsCompacted(this.readStats.getTotalUpdatedRecordsCompacted());
            this.writeStatus.getStat().setTotalLogFilesCompacted(this.readStats.getTotalLogFilesCompacted());
            this.writeStatus.getStat().setTotalLogRecords(this.readStats.getTotalLogRecords());
            this.writeStatus.getStat().setTotalLogBlocks(this.readStats.getTotalLogBlocks());
            this.writeStatus.getStat().setTotalCorruptLogBlock(this.readStats.getTotalCorruptLogBlock());
            this.writeStatus.getStat().setTotalRollbackBlocks(this.readStats.getTotalRollbackBlocks());
            if (this.writeStatus.getStat().getRuntimeStats() != null) {
                this.writeStatus.getStat().getRuntimeStats().setTotalScanTime(this.readStats.getTotalLogReadTimeMs());
            }
            return Collections.singletonList(this.writeStatus);
        }
        catch (Exception e) {
            throw new HoodieUpsertException("Failed to close HoodieSparkFileGroupReaderBasedMergeHandle", (Throwable)e);
        }
    }
}

