/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.io.storage.HoodieSparkFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkBasicSchemaEvolution;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkParquetReader
implements HoodieSparkFileReader {
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils parquetUtils;
    private List<ClosableIterator> readerIterators = new ArrayList<ClosableIterator>();
    private Option<StructType> structTypeOption = Option.empty();
    private Option<Schema> schemaOption = Option.empty();

    public HoodieSparkParquetReader(HoodieStorage storage, StoragePath path) {
        this.path = path;
        this.storage = storage.newInstance(path, storage.getConf().newInstance());
        this.storage.getConf().set("parquet.avro.add-list-element-records", "false");
        this.parquetUtils = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getFileFormatUtils(HoodieFileFormat.PARQUET);
    }

    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    public Set<Pair<String, Long>> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    public ClosableIterator<HoodieRecord<InternalRow>> getRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getRecordIterator(requestedSchema);
    }

    public ClosableIterator<HoodieRecord<InternalRow>> getRecordIterator(Schema schema) throws IOException {
        ClosableIterator<UnsafeRow> iterator = this.getUnsafeRowIterator(schema);
        return new CloseableMappingIterator(iterator, data -> (HoodieRecord)TypeUtils.unsafeCast((Object)((Object)new HoodieSparkRecord((UnsafeRow)data))));
    }

    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        Schema schema = HoodieAvroUtils.getRecordKeySchema();
        ClosableIterator<UnsafeRow> iterator = this.getUnsafeRowIterator(schema);
        return new CloseableMappingIterator(iterator, data -> {
            HoodieSparkRecord record = (HoodieSparkRecord)((Object)((Object)TypeUtils.unsafeCast((Object)((Object)new HoodieSparkRecord((UnsafeRow)data)))));
            return record.getRecordKey();
        });
    }

    public ClosableIterator<UnsafeRow> getUnsafeRowIterator(Schema requestedSchema) throws IOException {
        return this.getUnsafeRowIterator(HoodieInternalRowUtils.getCachedSchema(requestedSchema));
    }

    public ClosableIterator<UnsafeRow> getUnsafeRowIterator(StructType requestedSchema) throws IOException {
        SparkBasicSchemaEvolution evolution = new SparkBasicSchemaEvolution(this.getStructSchema(), requestedSchema, SQLConf.get().sessionLocalTimeZone());
        String readSchemaJson = evolution.getRequestSchema().json();
        this.storage.getConf().set("parquet.read.schema", readSchemaJson);
        this.storage.getConf().set(ParquetReadSupport.SPARK_ROW_REQUESTED_SCHEMA(), readSchemaJson);
        this.storage.getConf().set(SQLConf.PARQUET_BINARY_AS_STRING().key(), SQLConf.get().getConf(SQLConf.PARQUET_BINARY_AS_STRING()).toString());
        this.storage.getConf().set(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), SQLConf.get().getConf(SQLConf.PARQUET_INT96_AS_TIMESTAMP()).toString());
        ParquetReader reader = ParquetReader.builder((ReadSupport)new ParquetReadSupport(), (Path)new Path(this.path.toUri())).withConf((Configuration)this.storage.getConf().unwrapAs(Configuration.class)).build();
        UnsafeProjection projection = evolution.generateUnsafeProjection();
        ParquetReaderIterator parquetReaderIterator = new ParquetReaderIterator(reader);
        CloseableMappingIterator projectedIterator = new CloseableMappingIterator((ClosableIterator)parquetReaderIterator, arg_0 -> ((UnsafeProjection)projection).apply(arg_0));
        this.readerIterators.add((ClosableIterator)projectedIterator);
        return projectedIterator;
    }

    public Schema getSchema() {
        if (this.schemaOption.isEmpty()) {
            MessageType messageType = ((ParquetUtils)this.parquetUtils).readSchema(this.storage, this.path);
            StructType structType = new ParquetToSparkSchemaConverter((Configuration)this.storage.getConf().unwrapAs(Configuration.class)).convert(messageType);
            this.structTypeOption = Option.of((Object)structType);
            this.schemaOption = Option.of((Object)SparkAdapterSupport$.MODULE$.sparkAdapter().getAvroSchemaConverters().toAvroType((DataType)structType, true, messageType.getName(), ""));
        }
        return (Schema)this.schemaOption.get();
    }

    protected StructType getStructSchema() {
        if (this.structTypeOption.isEmpty()) {
            this.getSchema();
        }
        return (StructType)this.structTypeOption.get();
    }

    public void close() {
        this.readerIterators.forEach(ClosableIterator::close);
    }

    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.storage, this.path);
    }
}

