/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class CustomKeyGenerator
extends BuiltinKeyGenerator {
    private final CustomAvroKeyGenerator customAvroKeyGenerator;
    private final List<BuiltinKeyGenerator> partitionKeyGenerators;
    private final BuiltinKeyGenerator recordKeyGenerator;

    public CustomKeyGenerator(TypedProperties props) {
        super(CustomKeyGenerator.stripPartitionPathConfig(props));
        this.recordKeyFields = (List)Option.ofNullable((Object)props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(",")).map(String::trim).collect(Collectors.toList())).orElse(Collections.emptyList());
        String partitionPathFields = props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        this.partitionPathFields = partitionPathFields == null ? Collections.emptyList() : Arrays.stream(partitionPathFields.split(",")).map(String::trim).collect(Collectors.toList());
        this.customAvroKeyGenerator = new CustomAvroKeyGenerator(props);
        this.recordKeyGenerator = this.getRecordKeyFieldNames().size() == 1 ? new SimpleKeyGenerator(this.config, (Option<String>)Option.ofNullable((Object)this.config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key())), null) : new ComplexKeyGenerator(this.config);
        this.partitionKeyGenerators = CustomKeyGenerator.getPartitionKeyGenerators(this.partitionPathFields, this.config);
    }

    private static List<BuiltinKeyGenerator> getPartitionKeyGenerators(List<String> partitionPathFields, TypedProperties config) {
        if (partitionPathFields.size() == 1 && partitionPathFields.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        return partitionPathFields.stream().map(field -> {
            String[] fieldWithType = field.split(":");
            if (fieldWithType.length != 2) {
                throw CustomAvroKeyGenerator.getPartitionPathFormatException();
            }
            String partitionPathField = fieldWithType[0];
            CustomAvroKeyGenerator.PartitionKeyType keyType = CustomAvroKeyGenerator.PartitionKeyType.valueOf((String)fieldWithType[1].toUpperCase());
            switch (keyType) {
                case SIMPLE: {
                    return new SimpleKeyGenerator(config, partitionPathField);
                }
                case TIMESTAMP: {
                    try {
                        return new TimestampBasedKeyGenerator(config, partitionPathField);
                    }
                    catch (IOException ioe) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", (Throwable)ioe);
                    }
                }
            }
            throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + keyType);
        }).collect(Collectors.toList());
    }

    public String getRecordKey(GenericRecord record) {
        return this.customAvroKeyGenerator.getRecordKey(record);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.customAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        return this.recordKeyGenerator.getRecordKey(row);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.getPartitionPath((Option<GenericRecord>)Option.empty(), (Option<Row>)Option.of((Object)row), (Option<Pair<InternalRow, StructType>>)Option.empty());
    }

    @Override
    public UTF8String getPartitionPath(InternalRow row, StructType schema) {
        return UTF8String.fromString((String)this.getPartitionPath((Option<GenericRecord>)Option.empty(), (Option<Row>)Option.empty(), (Option<Pair<InternalRow, StructType>>)Option.of((Object)Pair.of((Object)row, (Object)schema))));
    }

    public String getPartitionPath(Option<GenericRecord> record, Option<Row> row, Option<Pair<InternalRow, StructType>> internalRowStructTypePair) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        if (this.partitionKeyGenerators.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < this.partitionKeyGenerators.size(); ++i) {
            BuiltinKeyGenerator keyGenerator = this.partitionKeyGenerators.get(i);
            if (record.isPresent()) {
                partitionPath.append(keyGenerator.getPartitionPath((GenericRecord)record.get()));
            } else if (row.isPresent()) {
                partitionPath.append(keyGenerator.getPartitionPath((Row)row.get()));
            } else {
                partitionPath.append(keyGenerator.getPartitionPath((InternalRow)((Pair)internalRowStructTypePair.get()).getKey(), (StructType)((Pair)internalRowStructTypePair.get()).getValue()));
            }
            if (i == this.partitionKeyGenerators.size() - 1) continue;
            partitionPath.append(this.customAvroKeyGenerator.getDefaultPartitionPathSeparator());
        }
        return partitionPath.toString();
    }

    private static TypedProperties stripPartitionPathConfig(TypedProperties props) {
        TypedProperties filtered = new TypedProperties((Properties)props);
        filtered.put((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (Object)"");
        return filtered;
    }
}

