/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageRecordSizeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AverageRecordSizeUtils.class);

    static long averageBytesPerRecord(HoodieTimeline commitTimeline, HoodieWriteConfig hoodieWriteConfig, CommitMetadataSerDe commitMetadataSerDe) {
        long avgSize = hoodieWriteConfig.getCopyOnWriteRecordSizeEstimate();
        long fileSizeThreshold = (long)(hoodieWriteConfig.getRecordSizeEstimationThreshold() * (double)hoodieWriteConfig.getParquetSmallFileLimit());
        if (!commitTimeline.empty()) {
            Iterator instants = commitTimeline.getReverseOrderedInstants().iterator();
            while (instants.hasNext()) {
                HoodieInstant instant = (HoodieInstant)instants.next();
                try {
                    HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)commitMetadataSerDe.deserialize(instant, (byte[])commitTimeline.getInstantDetails(instant).get(), HoodieCommitMetadata.class);
                    if (instant.getAction().equals("commit") || instant.getAction().equals("replacecommit")) {
                        long totalBytesWritten = commitMetadata.fetchTotalBytesWritten();
                        long totalRecordsWritten = commitMetadata.fetchTotalRecordsWritten();
                        if (totalBytesWritten <= fileSizeThreshold || totalRecordsWritten <= 0L) continue;
                        avgSize = (long)Math.ceil(1.0 * (double)totalBytesWritten / (double)totalRecordsWritten);
                        break;
                    }
                    if (!instant.getAction().equals("deltacommit")) continue;
                    AtomicLong totalBytesWritten = new AtomicLong(0L);
                    AtomicLong totalRecordsWritten = new AtomicLong(0L);
                    commitMetadata.getWriteStats().stream().filter(hoodieWriteStat -> FSUtils.isBaseFile((StoragePath)new StoragePath(hoodieWriteStat.getPath()))).forEach(hoodieWriteStat -> {
                        totalBytesWritten.addAndGet(hoodieWriteStat.getTotalWriteBytes());
                        totalRecordsWritten.addAndGet(hoodieWriteStat.getNumWrites());
                    });
                    if (totalBytesWritten.get() <= fileSizeThreshold || totalRecordsWritten.get() <= 0L) continue;
                    avgSize = (long)Math.ceil(1.0 * (double)totalBytesWritten.get() / (double)totalRecordsWritten.get());
                    break;
                }
                catch (Throwable t) {
                    LOG.error("Error trying to compute average bytes/record ", t);
                }
            }
        }
        return avgSize;
    }
}

