/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestClientRollback
extends HoodieClientTestBase {
    private static Stream<Arguments> testSavepointAndRollbackParams() {
        return Arrays.stream(new Boolean[][]{{false, false}, {true, true}, {true, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"testSavepointAndRollbackParams"})
    public void testSavepointAndRollback(Boolean testFailedRestore, Boolean failedRestoreInflight) throws Exception {
        block25: {
            HoodieWriteConfig cfg = this.getConfigBuilder().withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build()).build();
            try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
                HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS, (String)this.basePath);
                String newCommitTime = "001";
                client.startCommitWithTime(newCommitTime);
                List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
                JavaRDD writeRecords = this.jsc.parallelize(records, 1);
                List statuses = client.upsert(writeRecords, newCommitTime).collect();
                Assertions.assertNoWriteErrors((List)statuses);
                newCommitTime = "002";
                client.startCommitWithTime(newCommitTime);
                records = this.dataGen.generateUpdates(newCommitTime, records);
                statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
                Assertions.assertNoWriteErrors((List)statuses);
                client.savepoint("hoodie-unit-test", "test");
                newCommitTime = "003";
                client.startCommitWithTime(newCommitTime);
                records = this.dataGen.generateUpdates(newCommitTime, records);
                statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
                Assertions.assertNoWriteErrors((List)statuses);
                HoodieWriteConfig config = this.getConfig();
                List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)config.getMetadataConfig(), (String)cfg.getBasePath());
                this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
                HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
                TableFileSystemView.BaseFileOnlyView view1 = table.getBaseFileOnlyView();
                List dataFiles = partitionPaths.stream().flatMap(s -> view1.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("003"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 003 should be present");
                dataFiles = partitionPaths.stream().flatMap(s -> view1.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("002"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 002 should be present");
                newCommitTime = "004";
                client.startCommitWithTime(newCommitTime);
                records = this.dataGen.generateUpdates(newCommitTime, records);
                statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
                Assertions.assertNoWriteErrors((List)statuses);
                this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
                table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
                TableFileSystemView.BaseFileOnlyView view2 = table.getBaseFileOnlyView();
                dataFiles = partitionPaths.stream().flatMap(s -> view2.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("004"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 004 should be present");
                org.junit.jupiter.api.Assertions.assertThrows(HoodieRollbackException.class, () -> client.restoreToSavepoint("001"), (String)"Rolling back to non-existent savepoint should not be allowed");
                HoodieInstant savepoint = (HoodieInstant)table.getCompletedSavepointTimeline().getInstantsAsStream().findFirst().get();
                client.restoreToSavepoint(savepoint.requestedTime());
                this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
                table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
                TableFileSystemView.BaseFileOnlyView view3 = table.getBaseFileOnlyView();
                dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("002"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 002 be available");
                dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("003"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"The data files for commit 003 should be rolled back");
                dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("004"))).collect(Collectors.toList());
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"The data files for commit 004 should be rolled back");
                if (!testFailedRestore.booleanValue()) break block25;
                HoodieInstant inst = (HoodieInstant)table.getActiveTimeline().getRestoreTimeline().getInstants().get(0);
                String restoreFileName = table.getMetaClient().getBasePath() + "/.hoodie/timeline/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(inst);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)new File(restoreFileName).delete());
                if (!failedRestoreInflight.booleanValue()) {
                    HoodieInstant inflightInst = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, inst.getAction(), inst.requestedTime());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)new File(table.getMetaClient().getBasePath() + "/.hoodie/timeline/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(inflightInst)).delete());
                }
                try (SparkRDDWriteClient newClient = this.getHoodieWriteClient(cfg);){
                    newClient.restoreToSavepoint(savepoint.requestedTime());
                    this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
                    table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
                    List restoreInstants = table.getActiveTimeline().getRestoreTimeline().getInstants();
                    org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)restoreInstants.size());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)((HoodieInstant)restoreInstants.get(0)).getState());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)inst.requestedTime(), (Object)((HoodieInstant)restoreInstants.get(0)).requestedTime());
                }
            }
        }
    }

    private List<HoodieRecord> updateRecords(SparkRDDWriteClient client, List<HoodieRecord> records, String newCommitTime) throws IOException {
        client.startCommitWithTime(newCommitTime);
        List recs = this.dataGen.generateUpdates(newCommitTime, records);
        List statuses = client.upsert(this.jsc.parallelize(recs, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)statuses);
        return recs;
    }

    @Test
    public void testGetSavepointOldSchema() throws Exception {
        HoodieWriteConfig cfg = this.getConfigBuilder().withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(1).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS, (String)this.basePath);
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List<HoodieRecord> records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
            JavaRDD writeRecords = this.jsc.parallelize((List)records, 1);
            List statuses = client.upsert(writeRecords, newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            records = this.updateRecords(client, records, "002");
            client.savepoint("hoodie-unit-test", "test");
            records = this.updateRecords(client, records, "003");
            this.updateRecords(client, records, "004");
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            HoodieInstant savepoint = (HoodieInstant)table.getCompletedSavepointTimeline().lastInstant().get();
            client.restoreToSavepoint(savepoint.requestedTime());
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            HoodieRestorePlan plan = RestoreUtils.getRestorePlan((HoodieTableMetaClient)this.metaClient, (HoodieInstant)((HoodieInstant)table.getActiveTimeline().getRestoreTimeline().lastInstant().get()));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"002", (Object)RestoreUtils.getSavepointToRestoreTimestampV1Schema((HoodieTable)table, (HoodieRestorePlan)plan));
        }
    }

    @Test
    public void testSavepointAndRollbackWithKeepLatestFileVersionPolicy() throws Exception {
        HoodieWriteConfig cfg = this.getConfigBuilder().withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).retainFileVersions(2).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            HoodieTestDataGenerator.writePartitionMetadataDeprecated((HoodieStorage)this.storage, (String[])HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS, (String)this.basePath);
            String newCommitTime = "001";
            client.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(200));
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            List statuses = client.upsert(writeRecords, newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            newCommitTime = "002";
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, records);
            statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            client.savepoint("hoodie-unit-test", "test");
            newCommitTime = "003";
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, records);
            statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            HoodieWriteConfig config = this.getConfig();
            List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)config.getMetadataConfig(), (String)cfg.getBasePath());
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            TableFileSystemView.BaseFileOnlyView view1 = table.getBaseFileOnlyView();
            List dataFiles = partitionPaths.stream().flatMap(s -> view1.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("003"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 003 should be present");
            dataFiles = partitionPaths.stream().flatMap(s -> view1.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("002"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 002 should be present");
            newCommitTime = "004";
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, records);
            statuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            TableFileSystemView.BaseFileOnlyView view2 = table.getBaseFileOnlyView();
            dataFiles = partitionPaths.stream().flatMap(s -> view2.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("004"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 004 should be present");
            HoodieInstant savepoint = (HoodieInstant)table.getCompletedSavepointTimeline().getInstantsAsStream().findFirst().get();
            client.restoreToSavepoint(savepoint.requestedTime());
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            table = HoodieSparkTable.create((HoodieWriteConfig)this.getConfig(), (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
            TableFileSystemView.BaseFileOnlyView view3 = table.getBaseFileOnlyView();
            dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("002"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)dataFiles.size(), (String)"The data files for commit 002 be available");
            dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("003"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"The data files for commit 003 should be rolled back");
            dataFiles = partitionPaths.stream().flatMap(s -> view3.getAllBaseFiles(s).filter(f -> f.getCommitTime().equals("004"))).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)dataFiles.size(), (String)"The data files for commit 004 should be rolled back");
        }
    }

    @Test
    public void testRollbackCommit() throws Exception {
        String p1 = "2016/05/01";
        String p2 = "2016/05/02";
        String p3 = "2016/05/06";
        String commitTime1 = "20160501010101";
        String commitTime2 = "20160502020601";
        String commitTime3 = "20160506030611";
        HashMap<String, String> partitionAndFileId1 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id11");
                this.put("2016/05/02", "id12");
                this.put("2016/05/06", "id13");
            }
        };
        HashMap<String, String> partitionAndFileId2 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id21");
                this.put("2016/05/02", "id22");
                this.put("2016/05/06", "id23");
            }
        };
        HashMap<String, String> partitionAndFileId3 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id31");
                this.put("2016/05/02", "id32");
                this.put("2016/05/06", "id33");
            }
        };
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withRollbackUsingMarkers(false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).build();
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context));
            HashMap partitionToFilesNameLengthMap1 = new HashMap();
            partitionAndFileId1.forEach((k, v) -> partitionToFilesNameLengthMap1.put(k, Collections.singletonList(Pair.of((Object)v, (Object)100))));
            testTable.doWriteOperation("20160501010101", WriteOperationType.INSERT, Arrays.asList("2016/05/01", "2016/05/02", "2016/05/06"), partitionToFilesNameLengthMap1, false, false);
            HashMap partitionToFilesNameLengthMap2 = new HashMap();
            partitionAndFileId2.forEach((k, v) -> partitionToFilesNameLengthMap2.put(k, Collections.singletonList(Pair.of((Object)v, (Object)200))));
            testTable.doWriteOperation("20160502020601", WriteOperationType.INSERT, Collections.emptyList(), partitionToFilesNameLengthMap2, false, false);
            HashMap partitionToFilesNameLengthMap3 = new HashMap();
            partitionAndFileId3.forEach((k, v) -> partitionToFilesNameLengthMap3.put(k, Collections.singletonList(Pair.of((Object)v, (Object)300))));
            testTable.doWriteOperation("20160506030611", WriteOperationType.INSERT, Collections.emptyList(), partitionToFilesNameLengthMap3, false, true);
            try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
                client.rollback("20160506030611");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160506030611"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20160506030611"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                testTable.addInflightCommit("20160506030611");
                client.rollback("20160506030611");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160506030611"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                client.rollback("20160502020601");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.commitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                testTable.addInflightCommit("20160502020601").withBaseFilesInPartitions((Map)partitionAndFileId2);
                client.rollback("20160502020601");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.commitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                client.rollback("20160501010101");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.commitExists("20160501010101"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160501010101"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
            }
        }
    }

    private static Stream<Arguments> testFailedRollbackCommitParams() {
        return Arrays.stream(new Boolean[][]{{true, true}, {true, false}, {false, true}, {false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"testFailedRollbackCommitParams"})
    public void testFailedRollbackCommit(boolean enableMetadataTable, boolean instantToRollbackExists) throws Exception {
        String p1 = "2016/05/01";
        String p2 = "2016/05/02";
        String p3 = "2016/05/06";
        String commitTime1 = "20160501010101";
        String commitTime2 = "20160502020601";
        String commitTime3 = "20160506030611";
        HashMap<String, String> partitionAndFileId1 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id11");
                this.put("2016/05/02", "id12");
                this.put("2016/05/06", "id13");
            }
        };
        HashMap<String, String> partitionAndFileId2 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id21");
                this.put("2016/05/02", "id22");
                this.put("2016/05/06", "id23");
            }
        };
        HashMap<String, String> partitionAndFileId3 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id31");
                this.put("2016/05/02", "id32");
                this.put("2016/05/06", "id33");
            }
        };
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withRollbackUsingMarkers(false).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).enable(enableMetadataTable).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).build();
        HoodieTableMetadataWriter metadataWriter = enableMetadataTable ? SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context) : null;
        HoodieTestTable testTable = enableMetadataTable ? HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context)) : HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        ((HoodieTestTable)((HoodieTestTable)testTable.withPartitionMetaFiles(new String[]{"2016/05/01", "2016/05/02", "2016/05/06"}).addCommit("20160501010101").withBaseFilesInPartitions((Map)partitionAndFileId1).getLeft()).addCommit("20160502020601").withBaseFilesInPartitions((Map)partitionAndFileId2).getLeft()).addInflightCommit("20160506030611").withBaseFilesInPartitions((Map)partitionAndFileId3);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
            client.rollback("20160506030611");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160506030611"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20160506030611"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
            this.metaClient.reloadActiveTimeline();
            List rollbackInstants = this.metaClient.getActiveTimeline().getRollbackTimeline().getInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)rollbackInstants.size(), (int)1);
            HoodieInstant rollbackInstant = (HoodieInstant)rollbackInstants.get(0);
            FileCreateUtilsLegacy.deleteRollbackCommit((String)this.basePath, (String)rollbackInstant.requestedTime());
            if (instantToRollbackExists) {
                testTable.addInflightCommit("20160506030611").withBaseFilesInPartitions((Map)partitionAndFileId3);
            }
            client.rollback("20160506030611");
            this.metaClient.reloadActiveTimeline();
            rollbackInstants = this.metaClient.getActiveTimeline().getRollbackTimeline().getInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)rollbackInstants.size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals(rollbackInstants.get(0), (Object)rollbackInstant);
            String commitTime4 = "20160507040601";
            String commitTime5 = "20160507050611";
            testTable.addInflightCompaction("20160507040601", new HoodieCommitMetadata());
            HoodieRollbackPlan rollbackPlan = new HoodieRollbackPlan();
            rollbackPlan.setRollbackRequests(Collections.emptyList());
            rollbackPlan.setInstantToRollback(new HoodieInstantInfo("20160507040601", "compaction"));
            testTable.addRequestedRollback("20160507050611", rollbackPlan);
            this.metaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.getTableServiceClient().getPendingRollbackInfos(this.metaClient).size());
            client.rollback("20160507040601");
            this.metaClient.reloadActiveTimeline();
            rollbackInstants = this.metaClient.reloadActiveTimeline().getRollbackTimeline().getInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)rollbackInstants.size());
        }
        if (metadataWriter != null) {
            metadataWriter.close();
        }
    }

    @Test
    public void testAutoRollbackInflightCommit() throws Exception {
        String p1 = "2016/05/01";
        String p2 = "2016/05/02";
        String p3 = "2016/05/06";
        String commitTime1 = "20160501010101";
        String commitTime2 = "20160502020601";
        String commitTime3 = "20160506030611";
        HashMap<String, String> partitionAndFileId1 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id11");
                this.put("2016/05/02", "id12");
                this.put("2016/05/06", "id13");
            }
        };
        HashMap<String, String> partitionAndFileId2 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id21");
                this.put("2016/05/02", "id22");
                this.put("2016/05/06", "id23");
            }
        };
        HashMap<String, String> partitionAndFileId3 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id31");
                this.put("2016/05/02", "id32");
                this.put("2016/05/06", "id33");
            }
        };
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).build();
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context));
            HashMap partitionToFilesNameLengthMap1 = new HashMap();
            partitionAndFileId1.forEach((k, v) -> partitionToFilesNameLengthMap1.put(k, Collections.singletonList(Pair.of((Object)v, (Object)100))));
            testTable.doWriteOperation("20160501010101", WriteOperationType.INSERT, Arrays.asList("2016/05/01", "2016/05/02", "2016/05/06"), partitionToFilesNameLengthMap1, false, false);
            HashMap partitionToFilesNameLengthMap2 = new HashMap();
            partitionAndFileId2.forEach((k, v) -> partitionToFilesNameLengthMap2.put(k, Collections.singletonList(Pair.of((Object)v, (Object)200))));
            testTable.doWriteOperation("20160502020601", WriteOperationType.INSERT, Collections.emptyList(), partitionToFilesNameLengthMap2, false, true);
            HashMap partitionToFilesNameLengthMap3 = new HashMap();
            partitionAndFileId3.forEach((k, v) -> partitionToFilesNameLengthMap3.put(k, Collections.singletonList(Pair.of((Object)v, (Object)300))));
            testTable.doWriteOperation("20160506030611", WriteOperationType.INSERT, Collections.emptyList(), partitionToFilesNameLengthMap3, false, true);
            String commitTime4 = "20160506030621";
            try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
                client.startCommitWithTime("20160506030621");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.commitExists("20160501010101"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.inflightCommitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.inflightCommitExists("20160506030611"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20160506030611"));
            }
            config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withRollbackUsingMarkers(false).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).build();
            String commitTime5 = "20160506030631";
            try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
                client.startCommitWithTime("20160506030631");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.commitExists("20160501010101"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160506030611"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId1, "20160501010101"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20160506030611"));
            }
        }
    }

    private static Stream<Arguments> testRollbackWithRequestedRollbackPlanParams() {
        return Arrays.stream(new Boolean[][]{{true, true}, {true, false}, {false, true}, {false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"testRollbackWithRequestedRollbackPlanParams"})
    public void testRollbackWithRequestedRollbackPlan(boolean enableMetadataTable, boolean isRollbackPlanCorrupted) throws Exception {
        String p1 = "2022/04/05";
        String p2 = "2022/04/06";
        String commitTime1 = "20220406010101002";
        String commitTime2 = "20220406020601002";
        String commitTime3 = "20220406030611002";
        String rollbackInstantTime = "20220406040611002";
        HashMap<String, String> partitionAndFileId1 = new HashMap<String, String>(){
            {
                this.put("2022/04/05", "id11");
                this.put("2022/04/06", "id12");
            }
        };
        HashMap<String, String> partitionAndFileId2 = new HashMap<String, String>(){
            {
                this.put("2022/04/05", "id21");
                this.put("2022/04/06", "id22");
            }
        };
        HashMap<String, String> partitionAndFileId3 = new HashMap<String, String>(){
            {
                this.put("2022/04/05", "id31");
                this.put("2022/04/06", "id32");
            }
        };
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withRollbackUsingMarkers(false).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).enable(enableMetadataTable).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).build();
        HoodieTableMetadataWriter metadataWriter = enableMetadataTable ? SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.metaClient.getStorageConf(), (HoodieWriteConfig)config, (HoodieEngineContext)this.context) : null;
        HoodieTestTable testTable = enableMetadataTable ? HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context)) : HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        ((HoodieTestTable)((HoodieTestTable)testTable.withPartitionMetaFiles(new String[]{"2022/04/05", "2022/04/06"}).addCommit("20220406010101002").withBaseFilesInPartitions((Map)partitionAndFileId1).getLeft()).addCommit("20220406020601002").withBaseFilesInPartitions((Map)partitionAndFileId2).getLeft()).addInflightCommit("20220406030611002").withBaseFilesInPartitions((Map)partitionAndFileId3);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
            if (isRollbackPlanCorrupted) {
                FileCreateUtilsLegacy.createRequestedRollbackFile((String)this.metaClient.getBasePath().toString(), (String)"20220406040611002", (byte[])new byte[]{0, 1, 2});
            } else {
                HoodieRollbackPlan rollbackPlan = new HoodieRollbackPlan();
                List rollbackRequestList = partitionAndFileId3.keySet().stream().map(partition -> new HoodieRollbackRequest(partition, "", "", Collections.singletonList(this.metaClient.getBasePath() + "/" + partition + "/" + FileCreateUtilsLegacy.baseFileName((String)"20220406030611002", (String)((String)partitionAndFileId3.get("2022/04/05")))), Collections.emptyMap())).collect(Collectors.toList());
                rollbackPlan.setRollbackRequests(rollbackRequestList);
                rollbackPlan.setInstantToRollback(new HoodieInstantInfo("20220406030611002", "commit"));
                FileCreateUtilsLegacy.createRequestedRollbackFile((String)this.metaClient.getBasePath().toString(), (String)"20220406040611002", (HoodieRollbackPlan)rollbackPlan);
            }
            client.rollback("20220406030611002");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20220406030611002"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20220406030611002"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20220406020601002"));
            this.metaClient.reloadActiveTimeline();
            List rollbackInstants = this.metaClient.getActiveTimeline().getRollbackTimeline().getInstants();
            org.junit.jupiter.api.Assertions.assertEquals((int)rollbackInstants.size(), (int)1);
            HoodieInstant rollbackInstant = (HoodieInstant)rollbackInstants.get(0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)rollbackInstant.isCompleted());
            if (isRollbackPlanCorrupted) {
                org.junit.jupiter.api.Assertions.assertNotEquals((Object)"20220406040611002", (Object)rollbackInstant.requestedTime());
            } else {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"20220406040611002", (Object)rollbackInstant.requestedTime());
            }
        }
        if (metadataWriter != null) {
            metadataWriter.close();
        }
    }

    @Test
    public void testFallbackToListingBasedRollbackForCompletedInstant() throws Exception {
        String p1 = "2016/05/01";
        String p2 = "2016/05/02";
        String p3 = "2016/05/06";
        String commitTime1 = "20160501010101";
        String commitTime2 = "20160502020601";
        String commitTime3 = "20160506030611";
        HashMap<String, String> partitionAndFileId1 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id11");
                this.put("2016/05/02", "id12");
                this.put("2016/05/06", "id13");
            }
        };
        HashMap<String, String> partitionAndFileId2 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id21");
                this.put("2016/05/02", "id22");
                this.put("2016/05/06", "id23");
            }
        };
        HashMap<String, String> partitionAndFileId3 = new HashMap<String, String>(){
            {
                this.put("2016/05/01", "id31");
                this.put("2016/05/02", "id32");
                this.put("2016/05/06", "id33");
            }
        };
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withRollbackUsingMarkers(true).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).build()).build();
        try (HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.metaClient.getStorageConf(), (HoodieWriteConfig)config, (HoodieEngineContext)this.context);){
            HoodieTestTable testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)metadataWriter, (Option)Option.of((Object)this.context));
            ((HoodieTestTable)((HoodieTestTable)testTable.withPartitionMetaFiles(new String[]{"2016/05/01", "2016/05/02", "2016/05/06"}).addCommit("20160501010101").withBaseFilesInPartitions((Map)partitionAndFileId1).getLeft()).addCommit("20160502020601").withBaseFilesInPartitions((Map)partitionAndFileId2).getLeft()).addCommit("20160506030611").withBaseFilesInPartitions((Map)partitionAndFileId3);
            try (SparkRDDWriteClient client = this.getHoodieWriteClient(config);){
                client.rollback("20160506030611");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.inflightCommitExists("20160506030611"));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)testTable.baseFilesExist((Map)partitionAndFileId3, "20160506030611"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)testTable.baseFilesExist((Map)partitionAndFileId2, "20160502020601"));
            }
        }
    }
}

